<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airline_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for an Airline Object
 * @subpackage Structs
 */
class Airline_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airline Request References
     * - maxOccurs: unbounded
     * @var \StructType\AirlineObjectType[]
     */
    public $Airline_Reference;
    /**
     * Constructor method for Airline_Request_ReferencesType
     * @uses Airline_Request_ReferencesType::setAirline_Reference()
     * @param \StructType\AirlineObjectType[] $airline_Reference
     */
    public function __construct(array $airline_Reference = array())
    {
        $this
            ->setAirline_Reference($airline_Reference);
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType[]|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airline_Request_ReferencesTypeAirline_ReferenceItem) {
            // validation for constraint: itemType
            if (!$airline_Request_ReferencesTypeAirline_ReferenceItem instanceof \StructType\AirlineObjectType) {
                $invalidValues[] = is_object($airline_Request_ReferencesTypeAirline_ReferenceItem) ? get_class($airline_Request_ReferencesTypeAirline_ReferenceItem) : sprintf('%s(%s)', gettype($airline_Request_ReferencesTypeAirline_ReferenceItem), var_export($airline_Request_ReferencesTypeAirline_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @return \StructType\Airline_Request_ReferencesType
     */
    public function setAirline_Reference(array $airline_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airline_ReferenceArrayErrorMessage = self::validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference($airline_Reference))) {
            throw new \InvalidArgumentException($airline_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Add item to Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType $item
     * @return \StructType\Airline_Request_ReferencesType
     */
    public function addToAirline_Reference(\StructType\AirlineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline_Reference[] = $item;
        return $this;
    }
}
