<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Web_Item_AttributesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Web Item Attibutes.
 * @subpackage Structs
 */
class Web_Item_AttributesType extends AbstractStructBase
{
    /**
     * The Web_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Web Item.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Web_Item_Reference;
    /**
     * The Web_Item_Attributes_Data
     * Meta information extracted from the WSDL
     * - documentation: Web Item Attributes Data Element
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Web_Item_Attributes_DataType[]
     */
    public $Web_Item_Attributes_Data;
    /**
     * Constructor method for Web_Item_AttributesType
     * @uses Web_Item_AttributesType::setWeb_Item_Reference()
     * @uses Web_Item_AttributesType::setWeb_Item_Attributes_Data()
     * @param \StructType\Unique_IdentifierObjectType $web_Item_Reference
     * @param \StructType\Web_Item_Attributes_DataType[] $web_Item_Attributes_Data
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $web_Item_Reference = null, array $web_Item_Attributes_Data = array())
    {
        $this
            ->setWeb_Item_Reference($web_Item_Reference)
            ->setWeb_Item_Attributes_Data($web_Item_Attributes_Data);
    }
    /**
     * Get Web_Item_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getWeb_Item_Reference()
    {
        return $this->Web_Item_Reference;
    }
    /**
     * Set Web_Item_Reference value
     * @param \StructType\Unique_IdentifierObjectType $web_Item_Reference
     * @return \StructType\Web_Item_AttributesType
     */
    public function setWeb_Item_Reference(\StructType\Unique_IdentifierObjectType $web_Item_Reference = null)
    {
        $this->Web_Item_Reference = $web_Item_Reference;
        return $this;
    }
    /**
     * Get Web_Item_Attributes_Data value
     * @return \StructType\Web_Item_Attributes_DataType[]|null
     */
    public function getWeb_Item_Attributes_Data()
    {
        return $this->Web_Item_Attributes_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWeb_Item_Attributes_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeb_Item_Attributes_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeb_Item_Attributes_DataForArrayConstraintsFromSetWeb_Item_Attributes_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $web_Item_AttributesTypeWeb_Item_Attributes_DataItem) {
            // validation for constraint: itemType
            if (!$web_Item_AttributesTypeWeb_Item_Attributes_DataItem instanceof \StructType\Web_Item_Attributes_DataType) {
                $invalidValues[] = is_object($web_Item_AttributesTypeWeb_Item_Attributes_DataItem) ? get_class($web_Item_AttributesTypeWeb_Item_Attributes_DataItem) : sprintf('%s(%s)', gettype($web_Item_AttributesTypeWeb_Item_Attributes_DataItem), var_export($web_Item_AttributesTypeWeb_Item_Attributes_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Web_Item_Attributes_Data property can only contain items of type \StructType\Web_Item_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Web_Item_Attributes_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Item_Attributes_DataType[] $web_Item_Attributes_Data
     * @return \StructType\Web_Item_AttributesType
     */
    public function setWeb_Item_Attributes_Data(array $web_Item_Attributes_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($web_Item_Attributes_DataArrayErrorMessage = self::validateWeb_Item_Attributes_DataForArrayConstraintsFromSetWeb_Item_Attributes_Data($web_Item_Attributes_Data))) {
            throw new \InvalidArgumentException($web_Item_Attributes_DataArrayErrorMessage, __LINE__);
        }
        $this->Web_Item_Attributes_Data = $web_Item_Attributes_Data;
        return $this;
    }
    /**
     * Add item to Web_Item_Attributes_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Web_Item_Attributes_DataType $item
     * @return \StructType\Web_Item_AttributesType
     */
    public function addToWeb_Item_Attributes_Data(\StructType\Web_Item_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Web_Item_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Web_Item_Attributes_Data property can only contain items of type \StructType\Web_Item_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Web_Item_Attributes_Data[] = $item;
        return $this;
    }
}
