<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Classification_Field_Choice_Replacement_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all supplier classification field choice data
 * @subpackage Structs
 */
class Supplier_Classification_Field_Choice_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Field_Choice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing supplier classification field choice for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType
     */
    public $Supplier_Classification_Field_Choice_Reference;
    /**
     * The Supplier_Classification_Field_Choice_ID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier for the Supplier Classification Field Choice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Classification_Field_Choice_ID;
    /**
     * The Line_Order
     * Meta information extracted from the WSDL
     * - documentation: Optional line order. If specified, lines will be sorted by this value when displayed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Order;
    /**
     * The Field_Choice_Label
     * Meta information extracted from the WSDL
     * - documentation: The label of the supplier classification field choice
     * - maxOccurs: 1
     * @var string
     */
    public $Field_Choice_Label;
    /**
     * Constructor method for Supplier_Classification_Field_Choice_Replacement_DataType
     * @uses Supplier_Classification_Field_Choice_Replacement_DataType::setSupplier_Classification_Field_Choice_Reference()
     * @uses Supplier_Classification_Field_Choice_Replacement_DataType::setSupplier_Classification_Field_Choice_ID()
     * @uses Supplier_Classification_Field_Choice_Replacement_DataType::setLine_Order()
     * @uses Supplier_Classification_Field_Choice_Replacement_DataType::setField_Choice_Label()
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $supplier_Classification_Field_Choice_Reference
     * @param string $supplier_Classification_Field_Choice_ID
     * @param string $line_Order
     * @param string $field_Choice_Label
     */
    public function __construct(\StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $supplier_Classification_Field_Choice_Reference = null, $supplier_Classification_Field_Choice_ID = null, $line_Order = null, $field_Choice_Label = null)
    {
        $this
            ->setSupplier_Classification_Field_Choice_Reference($supplier_Classification_Field_Choice_Reference)
            ->setSupplier_Classification_Field_Choice_ID($supplier_Classification_Field_Choice_ID)
            ->setLine_Order($line_Order)
            ->setField_Choice_Label($field_Choice_Label);
    }
    /**
     * Get Supplier_Classification_Field_Choice_Reference value
     * @return \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType|null
     */
    public function getSupplier_Classification_Field_Choice_Reference()
    {
        return $this->Supplier_Classification_Field_Choice_Reference;
    }
    /**
     * Set Supplier_Classification_Field_Choice_Reference value
     * @param \StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $supplier_Classification_Field_Choice_Reference
     * @return \StructType\Supplier_Classification_Field_Choice_Replacement_DataType
     */
    public function setSupplier_Classification_Field_Choice_Reference(\StructType\Custom_Supplier_Classification_Field_ChoiceObjectType $supplier_Classification_Field_Choice_Reference = null)
    {
        $this->Supplier_Classification_Field_Choice_Reference = $supplier_Classification_Field_Choice_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Field_Choice_ID value
     * @return string|null
     */
    public function getSupplier_Classification_Field_Choice_ID()
    {
        return $this->Supplier_Classification_Field_Choice_ID;
    }
    /**
     * Set Supplier_Classification_Field_Choice_ID value
     * @param string $supplier_Classification_Field_Choice_ID
     * @return \StructType\Supplier_Classification_Field_Choice_Replacement_DataType
     */
    public function setSupplier_Classification_Field_Choice_ID($supplier_Classification_Field_Choice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Classification_Field_Choice_ID) && !is_string($supplier_Classification_Field_Choice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Classification_Field_Choice_ID, true), gettype($supplier_Classification_Field_Choice_ID)), __LINE__);
        }
        $this->Supplier_Classification_Field_Choice_ID = $supplier_Classification_Field_Choice_ID;
        return $this;
    }
    /**
     * Get Line_Order value
     * @return string|null
     */
    public function getLine_Order()
    {
        return $this->Line_Order;
    }
    /**
     * Set Line_Order value
     * @param string $line_Order
     * @return \StructType\Supplier_Classification_Field_Choice_Replacement_DataType
     */
    public function setLine_Order($line_Order = null)
    {
        // validation for constraint: string
        if (!is_null($line_Order) && !is_string($line_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Order, true), gettype($line_Order)), __LINE__);
        }
        $this->Line_Order = $line_Order;
        return $this;
    }
    /**
     * Get Field_Choice_Label value
     * @return string|null
     */
    public function getField_Choice_Label()
    {
        return $this->Field_Choice_Label;
    }
    /**
     * Set Field_Choice_Label value
     * @param string $field_Choice_Label
     * @return \StructType\Supplier_Classification_Field_Choice_Replacement_DataType
     */
    public function setField_Choice_Label($field_Choice_Label = null)
    {
        // validation for constraint: string
        if (!is_null($field_Choice_Label) && !is_string($field_Choice_Label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($field_Choice_Label, true), gettype($field_Choice_Label)), __LINE__);
        }
        $this->Field_Choice_Label = $field_Choice_Label;
        return $this;
    }
}
