<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Contact_Information_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is used to submit Supplier Contact Information into the system from the web service.
 * @subpackage Structs
 */
class Submit_Supplier_Contact_Information_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier containing Contact Information
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Contact_Information_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Contact_Information_Wrapper_DataType
     */
    public $Supplier_Contact_Information_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Contact_Information_RequestType
     * @uses Submit_Supplier_Contact_Information_RequestType::setSupplier_Reference()
     * @uses Submit_Supplier_Contact_Information_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Contact_Information_RequestType::setSupplier_Contact_Information_Data()
     * @uses Submit_Supplier_Contact_Information_RequestType::setVersion()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Contact_Information_Wrapper_DataType $supplier_Contact_Information_Data
     * @param string $version
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Contact_Information_Wrapper_DataType $supplier_Contact_Information_Data = null, $version = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Contact_Information_Data($supplier_Contact_Information_Data)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Submit_Supplier_Contact_Information_RequestType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Contact_Information_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Contact_Information_Data value
     * @return \StructType\Contact_Information_Wrapper_DataType|null
     */
    public function getSupplier_Contact_Information_Data()
    {
        return $this->Supplier_Contact_Information_Data;
    }
    /**
     * Set Supplier_Contact_Information_Data value
     * @param \StructType\Contact_Information_Wrapper_DataType $supplier_Contact_Information_Data
     * @return \StructType\Submit_Supplier_Contact_Information_RequestType
     */
    public function setSupplier_Contact_Information_Data(\StructType\Contact_Information_Wrapper_DataType $supplier_Contact_Information_Data = null)
    {
        $this->Supplier_Contact_Information_Data = $supplier_Contact_Information_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Contact_Information_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
