<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Template_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each project plan template based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Project_Plan_Template_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Template
     * Meta information extracted from the WSDL
     * - documentation: Contains all project plan template references and data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TemplateType[]
     */
    public $Project_Plan_Template;
    /**
     * Constructor method for Project_Plan_Template_Response_DataType
     * @uses Project_Plan_Template_Response_DataType::setProject_Plan_Template()
     * @param \StructType\Project_Plan_TemplateType[] $project_Plan_Template
     */
    public function __construct(array $project_Plan_Template = array())
    {
        $this
            ->setProject_Plan_Template($project_Plan_Template);
    }
    /**
     * Get Project_Plan_Template value
     * @return \StructType\Project_Plan_TemplateType[]|null
     */
    public function getProject_Plan_Template()
    {
        return $this->Project_Plan_Template;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Plan_Template method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Plan_Template method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Plan_TemplateForArrayConstraintsFromSetProject_Plan_Template(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem instanceof \StructType\Project_Plan_TemplateType) {
                $invalidValues[] = is_object($project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem) ? get_class($project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem) : sprintf('%s(%s)', gettype($project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem), var_export($project_Plan_Template_Response_DataTypeProject_Plan_TemplateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Plan_Template property can only contain items of type \StructType\Project_Plan_TemplateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Plan_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TemplateType[] $project_Plan_Template
     * @return \StructType\Project_Plan_Template_Response_DataType
     */
    public function setProject_Plan_Template(array $project_Plan_Template = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Plan_TemplateArrayErrorMessage = self::validateProject_Plan_TemplateForArrayConstraintsFromSetProject_Plan_Template($project_Plan_Template))) {
            throw new \InvalidArgumentException($project_Plan_TemplateArrayErrorMessage, __LINE__);
        }
        $this->Project_Plan_Template = $project_Plan_Template;
        return $this;
    }
    /**
     * Add item to Project_Plan_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TemplateType $item
     * @return \StructType\Project_Plan_Template_Response_DataType
     */
    public function addToProject_Plan_Template(\StructType\Project_Plan_TemplateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_TemplateType) {
            throw new \InvalidArgumentException(sprintf('The Project_Plan_Template property can only contain items of type \StructType\Project_Plan_TemplateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Plan_Template[] = $item;
        return $this;
    }
}
