<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture information to create an Internal Service Delivery. It includes subelements to create attachments, Internal Service Delivery Lines and Line Splits.
 * @subpackage Structs
 */
class Internal_Service_Delivery_Data_InboundType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery_ID
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Delivery Reference ID. This is optional and will be auto-generated if left blank on the Web Service request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Delivery_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to indicate whether the Internal Service Delivery should be submitted to the business process.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company to create the Internal Service Delivery.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Service Provider (ISP) for the Internal Service Delivery. The ISP should be active and also be associated with the Company specified on the Web Service request.
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Currency for the Internal Service Delivery.
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: Date used to generate accounting for the Internal Service Delivery.
     * - maxOccurs: 1
     * @var string
     */
    public $Document_Date;
    /**
     * The Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Default Service Date for the Internal Service Delivery. If left blank, it is defaulted to the Current System Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delivery_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Document Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Internal_Service_Delivery_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures Internal Service Delivery Line information. An Internal Service Delivery may have multiple lines, with or without Splits.
     * - maxOccurs: unbounded
     * @var \StructType\Internal_Service_Delivery_Line_Data_InboundType[]
     */
    public $Internal_Service_Delivery_Line_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing all Business Document Attachment data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * Constructor method for Internal_Service_Delivery_Data_InboundType
     * @uses Internal_Service_Delivery_Data_InboundType::setInternal_Service_Delivery_ID()
     * @uses Internal_Service_Delivery_Data_InboundType::setSubmit()
     * @uses Internal_Service_Delivery_Data_InboundType::setCompany_Reference()
     * @uses Internal_Service_Delivery_Data_InboundType::setInternal_Service_Provider_Reference()
     * @uses Internal_Service_Delivery_Data_InboundType::setCurrency_Reference()
     * @uses Internal_Service_Delivery_Data_InboundType::setDocument_Date()
     * @uses Internal_Service_Delivery_Data_InboundType::setDelivery_Date()
     * @uses Internal_Service_Delivery_Data_InboundType::setMemo()
     * @uses Internal_Service_Delivery_Data_InboundType::setWorktags_Reference()
     * @uses Internal_Service_Delivery_Data_InboundType::setInternal_Service_Delivery_Line_Data()
     * @uses Internal_Service_Delivery_Data_InboundType::setBusiness_Document_Attachment_Data()
     * @param string $internal_Service_Delivery_ID
     * @param bool $submit
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $document_Date
     * @param string $delivery_Date
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Internal_Service_Delivery_Line_Data_InboundType[] $internal_Service_Delivery_Line_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     */
    public function __construct($internal_Service_Delivery_ID = null, $submit = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, $document_Date = null, $delivery_Date = null, $memo = null, array $worktags_Reference = array(), array $internal_Service_Delivery_Line_Data = array(), array $business_Document_Attachment_Data = array())
    {
        $this
            ->setInternal_Service_Delivery_ID($internal_Service_Delivery_ID)
            ->setSubmit($submit)
            ->setCompany_Reference($company_Reference)
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setDocument_Date($document_Date)
            ->setDelivery_Date($delivery_Date)
            ->setMemo($memo)
            ->setWorktags_Reference($worktags_Reference)
            ->setInternal_Service_Delivery_Line_Data($internal_Service_Delivery_Line_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data);
    }
    /**
     * Get Internal_Service_Delivery_ID value
     * @return string|null
     */
    public function getInternal_Service_Delivery_ID()
    {
        return $this->Internal_Service_Delivery_ID;
    }
    /**
     * Set Internal_Service_Delivery_ID value
     * @param string $internal_Service_Delivery_ID
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setInternal_Service_Delivery_ID($internal_Service_Delivery_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Delivery_ID) && !is_string($internal_Service_Delivery_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Delivery_ID, true), gettype($internal_Service_Delivery_ID)), __LINE__);
        }
        $this->Internal_Service_Delivery_ID = $internal_Service_Delivery_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get Delivery_Date value
     * @return string|null
     */
    public function getDelivery_Date()
    {
        return $this->Delivery_Date;
    }
    /**
     * Set Delivery_Date value
     * @param string $delivery_Date
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setDelivery_Date($delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($delivery_Date) && !is_string($delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery_Date, true), gettype($delivery_Date)), __LINE__);
        }
        $this->Delivery_Date = $delivery_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem) ? get_class($internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem), var_export($internal_Service_Delivery_Data_InboundTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Line_Data value
     * @return \StructType\Internal_Service_Delivery_Line_Data_InboundType[]|null
     */
    public function getInternal_Service_Delivery_Line_Data()
    {
        return $this->Internal_Service_Delivery_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Delivery_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Delivery_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Delivery_Line_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem instanceof \StructType\Internal_Service_Delivery_Line_Data_InboundType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem) ? get_class($internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem), var_export($internal_Service_Delivery_Data_InboundTypeInternal_Service_Delivery_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Delivery_Line_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Delivery_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Data_InboundType[] $internal_Service_Delivery_Line_Data
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setInternal_Service_Delivery_Line_Data(array $internal_Service_Delivery_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Delivery_Line_DataArrayErrorMessage = self::validateInternal_Service_Delivery_Line_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Data($internal_Service_Delivery_Line_Data))) {
            throw new \InvalidArgumentException($internal_Service_Delivery_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Data = $internal_Service_Delivery_Line_Data;
        return $this;
    }
    /**
     * Add item to Internal_Service_Delivery_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Data_InboundType $item
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function addToInternal_Service_Delivery_Line_Data(\StructType\Internal_Service_Delivery_Line_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Delivery_Line_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Delivery_Line_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem) ? get_class($internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem), var_export($internal_Service_Delivery_Data_InboundTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Internal_Service_Delivery_Data_InboundType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
}
