<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_CatalogType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element for Internal Catalog Reference and Internal Catalog Data.
 * @subpackage Structs
 */
class Internal_CatalogType extends AbstractStructBase
{
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Internal Catalog.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_CatalogObjectType
     */
    public $Internal_Catalog_Reference;
    /**
     * The Internal_Catalog_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Internal Catalog data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Catalog_DataType[]
     */
    public $Internal_Catalog_Data;
    /**
     * The Catalog_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_for_Internal_Catalog_DataType[]
     */
    public $Catalog_Item_Data;
    /**
     * Constructor method for Internal_CatalogType
     * @uses Internal_CatalogType::setInternal_Catalog_Reference()
     * @uses Internal_CatalogType::setInternal_Catalog_Data()
     * @uses Internal_CatalogType::setCatalog_Item_Data()
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @param \StructType\Internal_Catalog_DataType[] $internal_Catalog_Data
     * @param \StructType\Catalog_Item_for_Internal_Catalog_DataType[] $catalog_Item_Data
     */
    public function __construct(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null, array $internal_Catalog_Data = array(), array $catalog_Item_Data = array())
    {
        $this
            ->setInternal_Catalog_Reference($internal_Catalog_Reference)
            ->setInternal_Catalog_Data($internal_Catalog_Data)
            ->setCatalog_Item_Data($catalog_Item_Data);
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Internal_Service_CatalogObjectType|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @param \StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference
     * @return \StructType\Internal_CatalogType
     */
    public function setInternal_Catalog_Reference(\StructType\Internal_Service_CatalogObjectType $internal_Catalog_Reference = null)
    {
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Get Internal_Catalog_Data value
     * @return \StructType\Internal_Catalog_DataType[]|null
     */
    public function getInternal_Catalog_Data()
    {
        return $this->Internal_Catalog_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Catalog_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Catalog_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Catalog_DataForArrayConstraintsFromSetInternal_Catalog_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_CatalogTypeInternal_Catalog_DataItem) {
            // validation for constraint: itemType
            if (!$internal_CatalogTypeInternal_Catalog_DataItem instanceof \StructType\Internal_Catalog_DataType) {
                $invalidValues[] = is_object($internal_CatalogTypeInternal_Catalog_DataItem) ? get_class($internal_CatalogTypeInternal_Catalog_DataItem) : sprintf('%s(%s)', gettype($internal_CatalogTypeInternal_Catalog_DataItem), var_export($internal_CatalogTypeInternal_Catalog_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Catalog_Data property can only contain items of type \StructType\Internal_Catalog_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Catalog_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Catalog_DataType[] $internal_Catalog_Data
     * @return \StructType\Internal_CatalogType
     */
    public function setInternal_Catalog_Data(array $internal_Catalog_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Catalog_DataArrayErrorMessage = self::validateInternal_Catalog_DataForArrayConstraintsFromSetInternal_Catalog_Data($internal_Catalog_Data))) {
            throw new \InvalidArgumentException($internal_Catalog_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Catalog_Data = $internal_Catalog_Data;
        return $this;
    }
    /**
     * Add item to Internal_Catalog_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Catalog_DataType $item
     * @return \StructType\Internal_CatalogType
     */
    public function addToInternal_Catalog_Data(\StructType\Internal_Catalog_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Catalog_DataType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Catalog_Data property can only contain items of type \StructType\Internal_Catalog_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Catalog_Data[] = $item;
        return $this;
    }
    /**
     * Get Catalog_Item_Data value
     * @return \StructType\Catalog_Item_for_Internal_Catalog_DataType[]|null
     */
    public function getCatalog_Item_Data()
    {
        return $this->Catalog_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_CatalogTypeCatalog_Item_DataItem) {
            // validation for constraint: itemType
            if (!$internal_CatalogTypeCatalog_Item_DataItem instanceof \StructType\Catalog_Item_for_Internal_Catalog_DataType) {
                $invalidValues[] = is_object($internal_CatalogTypeCatalog_Item_DataItem) ? get_class($internal_CatalogTypeCatalog_Item_DataItem) : sprintf('%s(%s)', gettype($internal_CatalogTypeCatalog_Item_DataItem), var_export($internal_CatalogTypeCatalog_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_for_Internal_Catalog_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_for_Internal_Catalog_DataType[] $catalog_Item_Data
     * @return \StructType\Internal_CatalogType
     */
    public function setCatalog_Item_Data(array $catalog_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Item_DataArrayErrorMessage = self::validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data($catalog_Item_Data))) {
            throw new \InvalidArgumentException($catalog_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Item_Data = $catalog_Item_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_for_Internal_Catalog_DataType $item
     * @return \StructType\Internal_CatalogType
     */
    public function addToCatalog_Item_Data(\StructType\Catalog_Item_for_Internal_Catalog_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_for_Internal_Catalog_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_for_Internal_Catalog_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Item_Data[] = $item;
        return $this;
    }
}
