<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Pooling_RuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing a reference to an existing asset pooling rule and its asset pooling rule data
 * @subpackage Structs
 */
class Asset_Pooling_RuleType extends AbstractStructBase
{
    /**
     * The Asset_Pooling_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing asset pooling rule to which the asset pooling rule data applies
     * - minOccurs: 0
     * @var \StructType\Asset_Pooling_RuleObjectType
     */
    public $Asset_Pooling_Rule_Reference;
    /**
     * The Asset_Pooling_Rule_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing all the Asset Pooling Rules
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Pooling_Rule_DataType[]
     */
    public $Asset_Pooling_Rule_Data;
    /**
     * Constructor method for Asset_Pooling_RuleType
     * @uses Asset_Pooling_RuleType::setAsset_Pooling_Rule_Reference()
     * @uses Asset_Pooling_RuleType::setAsset_Pooling_Rule_Data()
     * @param \StructType\Asset_Pooling_RuleObjectType $asset_Pooling_Rule_Reference
     * @param \StructType\Asset_Pooling_Rule_DataType[] $asset_Pooling_Rule_Data
     */
    public function __construct(\StructType\Asset_Pooling_RuleObjectType $asset_Pooling_Rule_Reference = null, array $asset_Pooling_Rule_Data = array())
    {
        $this
            ->setAsset_Pooling_Rule_Reference($asset_Pooling_Rule_Reference)
            ->setAsset_Pooling_Rule_Data($asset_Pooling_Rule_Data);
    }
    /**
     * Get Asset_Pooling_Rule_Reference value
     * @return \StructType\Asset_Pooling_RuleObjectType|null
     */
    public function getAsset_Pooling_Rule_Reference()
    {
        return $this->Asset_Pooling_Rule_Reference;
    }
    /**
     * Set Asset_Pooling_Rule_Reference value
     * @param \StructType\Asset_Pooling_RuleObjectType $asset_Pooling_Rule_Reference
     * @return \StructType\Asset_Pooling_RuleType
     */
    public function setAsset_Pooling_Rule_Reference(\StructType\Asset_Pooling_RuleObjectType $asset_Pooling_Rule_Reference = null)
    {
        $this->Asset_Pooling_Rule_Reference = $asset_Pooling_Rule_Reference;
        return $this;
    }
    /**
     * Get Asset_Pooling_Rule_Data value
     * @return \StructType\Asset_Pooling_Rule_DataType[]|null
     */
    public function getAsset_Pooling_Rule_Data()
    {
        return $this->Asset_Pooling_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Pooling_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Pooling_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Pooling_Rule_DataForArrayConstraintsFromSetAsset_Pooling_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem instanceof \StructType\Asset_Pooling_Rule_DataType) {
                $invalidValues[] = is_object($asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem) ? get_class($asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem) : sprintf('%s(%s)', gettype($asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem), var_export($asset_Pooling_RuleTypeAsset_Pooling_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Pooling_Rule_Data property can only contain items of type \StructType\Asset_Pooling_Rule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Pooling_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Pooling_Rule_DataType[] $asset_Pooling_Rule_Data
     * @return \StructType\Asset_Pooling_RuleType
     */
    public function setAsset_Pooling_Rule_Data(array $asset_Pooling_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Pooling_Rule_DataArrayErrorMessage = self::validateAsset_Pooling_Rule_DataForArrayConstraintsFromSetAsset_Pooling_Rule_Data($asset_Pooling_Rule_Data))) {
            throw new \InvalidArgumentException($asset_Pooling_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Pooling_Rule_Data = $asset_Pooling_Rule_Data;
        return $this;
    }
    /**
     * Add item to Asset_Pooling_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Pooling_Rule_DataType $item
     * @return \StructType\Asset_Pooling_RuleType
     */
    public function addToAsset_Pooling_Rule_Data(\StructType\Asset_Pooling_Rule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Pooling_Rule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Pooling_Rule_Data property can only contain items of type \StructType\Asset_Pooling_Rule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Pooling_Rule_Data[] = $item;
        return $this;
    }
}
