<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Import_Supplier_Invoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This background service operation will add or update Supplier Invoices and submit to the Supplier Invoice business process. This import is Asynchronous and the response will only be an acknowledgement or receipt. Supplier Invoice
     * Adjustment data includes Supplier Invoice Adjustment ID, Submit Flag, Locked in Workday Flag, Document Number, Company, Currency, Supplier, Contingent Worker, Document Date, Due Date Override, Control Total Amount, Payment Terms, Hold from Payment
     * Flag, Document Received, Reference, PO Number, Contract, Memo, Attachment and Supplier Invoice Line data. Line data includes Intercompany Affiliate, Purchase Item, Purchase Order Line, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo
     * and Worktags.Spend Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_Supplier_Invoice_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Supplier_Invoice(\StructType\Import_Supplier_Invoice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Supplier_Invoice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Travel_Booking_Records
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This background service operation will load travel data found in the travel booking data files that have been sourced from the corporate travel provider(s). This import is Asynchronous and the response will only be an acknowledgement
     * or receipt.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Travel_Booking_Header_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Travel_Booking_Records(\StructType\Travel_Booking_Header_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Travel_Booking_Records($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Credit_Card_Transactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will add or update an Expense Credit Card Transaction File. Each file will load one or more Expense Credit Card Transactions. Expense Credit Card Transactions are used in the Expense Report lines. Expense Credit Card
     * Transaction data includes the Corporate Credit Card Account, Employee ID, Cardholder Name, Amount, Currency, etc..No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Credit_Card_Transaction_Header__HV__RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Credit_Card_Transactions(\StructType\Credit_Card_Transaction_Header__HV__RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Credit_Card_Transactions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Catalog_Load
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Catalog Items. Catalog Load Requests contain supplier specific Catalog Items and effective dated pricing. Catalog Load Requests can be associated with Supplier Contracts. Once a Catalog Load
     * Request is fully approved Catalog Items are available for use on Requisitions and Purchase Orders based on their effective date. Catalog Loads include data such as Supplier, Supplier Contract, Effective Date, memo and item details such as Item ID,
     * Item Name, Item Description, Unit of Measure and Unit Price.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_Catalog_Load_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Catalog_Load(\StructType\Import_Catalog_Load_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Catalog_Load($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Credit_Cards
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will add or update a Cardholder Listing File. Each file will load one or more Expense Credit Cards. Expense Credit Cards are used in credit card transactions. Expense Credit Card data includes Corporate Credit Card
     * Account Reference, Employee Reference or ID, Credit Card Description, Last 4 Digits of Credit Card Number, Credit Card Expiration Date, Monthly Limit, Transaction Limit, Billing Currency Reference, Cash Access Allowed boolean, Cancel Date, Cardmember
     * Embossed Name, Document Status Reference, Card Holder Listing File Reference, and Expense Credit Card Token.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Credit_Card_Header__HV__RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Credit_Cards(\StructType\Credit_Card_Header__HV__RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Credit_Cards($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Guests
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will add or update a Guest Listing File. Each file will load one or more Guests for a Worker. Guest data includes Name, Title and Company.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Guest_Header__HV__RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Guests(\StructType\Guest_Header__HV__RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Guests($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Resource_Forecast
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This background service operation will add, update Resource Forecasts. This import is Asynchronous and the response will only be an acknowledgement or receipt. Resource Forecast data includes Project to which Resource Forecast is
     * created for, Worker and Project role for Resource Forecast Line and Forecasted Hours and Start Date of the forecast.This web service also provides the ability to replace all Resource Forecast for a Project, Replace all or Delete Resource Forecast
     * Lines and Delete Resource Forecast Line Allocation.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_Resource_Forecast_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Resource_Forecast(\StructType\Import_Resource_Forecast_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Resource_Forecast($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Expense_Rate_Table
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will add or update Expense Rate Tables. This contains Name, Type, Default Currency, Expense Item Type for evaluation and Rate Table Lines. Each Rate Table Line contains a reference to a Condition Rule,
     * Behavior Spend Data, and Graduated Expense Data.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Expense_Rate_Table_Header__HV__RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Expense_Rate_Table(\StructType\Expense_Rate_Table_Header__HV__RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Expense_Rate_Table($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Travel_Profiles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will add or update a Worker Travel Profile File. Each file will load one or more Travel Profile for a Worker or Contingent Worker. Travel Profile data includes Airline, Hotel and Fuel Type.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Worker_Travel_Profile_Header__HV__RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Travel_Profiles(\StructType\Worker_Travel_Profile_Header__HV__RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Travel_Profiles($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Supplier_Items
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update supplier information for purchase items. The Import Supplier Items contains the supplier information on purchase items including linked supplier catalog items. Import Supplier Items includes
     * Purchase item ID, Item Name, Item Description Supplier, Supplier Contract, Effective Date, Sourcing Priority, Lead Time, Unit of Measure, and Unit Price. Once Supplier Items request is approved, supplier information for purchase items is available
     * for use on requisitions and purchase orders based on their effective date.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Supplier_Item_Price_Update_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Supplier_Items(\StructType\Supplier_Item_Price_Update_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Supplier_Items($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Import_Purchase_Order_Close_Lines
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Closes purchase order lines for invoicing. You can't close lines associated to supplier invoices, receipts, or returns that are in draft or in progress. The entire purchase order is closed (displayed at the header) when the web
     * service closes the last open line on the purchase order.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Import_Purchase_Order_Close_Lines_RequestType $body
     * @return \StructType\Put_Import_Process_ResponseType|bool
     */
    public function Import_Purchase_Order_Close_Lines(\StructType\Import_Purchase_Order_Close_Lines_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Import_Purchase_Order_Close_Lines($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Put_Import_Process_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
