<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Request for Quote Data.
 * @subpackage Structs
 */
class Request_for_Quote_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_ID
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The RFQ_Number
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Number;
    /**
     * The RFQ_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Document Status for the Request for Quote. This field is read-only, and will be ignored on a Put or Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $RFQ_Status_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The RFQ_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Type Reference.
     * @var \StructType\Request_for_Quote_TypeObjectType
     */
    public $RFQ_Type_Reference;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Title.
     * - maxOccurs: 1
     * @var string
     */
    public $Title;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the Request for Quote.
     * - maxOccurs: 1
     * @var string
     */
    public $Document_Date;
    /**
     * The RFQ_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Start Date with time precision up to minute.
     * - maxOccurs: 1
     * @var string
     */
    public $RFQ_Start_Date;
    /**
     * The RFQ_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote End Date with time precision up to minute.
     * - maxOccurs: 1
     * @var string
     */
    public $RFQ_End_Date;
    /**
     * The Time_Zone_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Zone for RFQ Start Date and RFQ End Date.
     * @var \StructType\Time_ZoneObjectType
     */
    public $Time_Zone_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Sourcing Buyer of Request for Quote.
     * @var \StructType\WorkerObjectType
     */
    public $Sourcing_Buyer_Reference;
    /**
     * The Exclude_Target_Price
     * Meta information extracted from the WSDL
     * - documentation: Exclude Target Price.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_Target_Price;
    /**
     * The Request_for_Quote_Terms_and_Conditions
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Terms and Conditions.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request_for_Quote_Terms_and_Conditions;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Request_for_Quote_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Line_DataType[]
     */
    public $Request_for_Quote_Line_Data;
    /**
     * The Request_for_Quote_Participant_List_Data
     * Meta information extracted from the WSDL
     * - documentation: Proposed Suppliers for the Request for Quote at header level.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Participant_List_DataType[]
     */
    public $Request_for_Quote_Participant_List_Data;
    /**
     * The Request_for_Quote_Bid_Requirement_Data
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Bid Requirement Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Bid_Requirement_DataType[]
     */
    public $Request_for_Quote_Bid_Requirement_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Attachment_with_External_Option_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * Constructor method for Request_for_Quote_DataType
     * @uses Request_for_Quote_DataType::setRequest_for_Quote_ID()
     * @uses Request_for_Quote_DataType::setSubmit()
     * @uses Request_for_Quote_DataType::setRFQ_Number()
     * @uses Request_for_Quote_DataType::setRFQ_Status_Reference()
     * @uses Request_for_Quote_DataType::setCompany_Reference()
     * @uses Request_for_Quote_DataType::setRFQ_Type_Reference()
     * @uses Request_for_Quote_DataType::setTitle()
     * @uses Request_for_Quote_DataType::setDocument_Date()
     * @uses Request_for_Quote_DataType::setRFQ_Start_Date()
     * @uses Request_for_Quote_DataType::setRFQ_End_Date()
     * @uses Request_for_Quote_DataType::setTime_Zone_Reference()
     * @uses Request_for_Quote_DataType::setCurrency_Reference()
     * @uses Request_for_Quote_DataType::setSourcing_Buyer_Reference()
     * @uses Request_for_Quote_DataType::setExclude_Target_Price()
     * @uses Request_for_Quote_DataType::setRequest_for_Quote_Terms_and_Conditions()
     * @uses Request_for_Quote_DataType::setMemo()
     * @uses Request_for_Quote_DataType::setRequest_for_Quote_Line_Data()
     * @uses Request_for_Quote_DataType::setRequest_for_Quote_Participant_List_Data()
     * @uses Request_for_Quote_DataType::setRequest_for_Quote_Bid_Requirement_Data()
     * @uses Request_for_Quote_DataType::setBusiness_Document_Attachment_Data()
     * @param string $request_for_Quote_ID
     * @param bool $submit
     * @param string $rFQ_Number
     * @param \StructType\Document_StatusObjectType $rFQ_Status_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference
     * @param string $title
     * @param string $document_Date
     * @param string $rFQ_Start_Date
     * @param string $rFQ_End_Date
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @param bool $exclude_Target_Price
     * @param string $request_for_Quote_Terms_and_Conditions
     * @param string $memo
     * @param \StructType\Request_for_Quote_Line_DataType[] $request_for_Quote_Line_Data
     * @param \StructType\Request_for_Quote_Participant_List_DataType[] $request_for_Quote_Participant_List_Data
     * @param \StructType\Request_for_Quote_Bid_Requirement_DataType[] $request_for_Quote_Bid_Requirement_Data
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     */
    public function __construct($request_for_Quote_ID = null, $submit = null, $rFQ_Number = null, \StructType\Document_StatusObjectType $rFQ_Status_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference = null, $title = null, $document_Date = null, $rFQ_Start_Date = null, $rFQ_End_Date = null, \StructType\Time_ZoneObjectType $time_Zone_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\WorkerObjectType $sourcing_Buyer_Reference = null, $exclude_Target_Price = null, $request_for_Quote_Terms_and_Conditions = null, $memo = null, array $request_for_Quote_Line_Data = array(), array $request_for_Quote_Participant_List_Data = array(), array $request_for_Quote_Bid_Requirement_Data = array(), array $business_Document_Attachment_Data = array())
    {
        $this
            ->setRequest_for_Quote_ID($request_for_Quote_ID)
            ->setSubmit($submit)
            ->setRFQ_Number($rFQ_Number)
            ->setRFQ_Status_Reference($rFQ_Status_Reference)
            ->setCompany_Reference($company_Reference)
            ->setRFQ_Type_Reference($rFQ_Type_Reference)
            ->setTitle($title)
            ->setDocument_Date($document_Date)
            ->setRFQ_Start_Date($rFQ_Start_Date)
            ->setRFQ_End_Date($rFQ_End_Date)
            ->setTime_Zone_Reference($time_Zone_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setSourcing_Buyer_Reference($sourcing_Buyer_Reference)
            ->setExclude_Target_Price($exclude_Target_Price)
            ->setRequest_for_Quote_Terms_and_Conditions($request_for_Quote_Terms_and_Conditions)
            ->setMemo($memo)
            ->setRequest_for_Quote_Line_Data($request_for_Quote_Line_Data)
            ->setRequest_for_Quote_Participant_List_Data($request_for_Quote_Participant_List_Data)
            ->setRequest_for_Quote_Bid_Requirement_Data($request_for_Quote_Bid_Requirement_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data);
    }
    /**
     * Get Request_for_Quote_ID value
     * @return string|null
     */
    public function getRequest_for_Quote_ID()
    {
        return $this->Request_for_Quote_ID;
    }
    /**
     * Set Request_for_Quote_ID value
     * @param string $request_for_Quote_ID
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRequest_for_Quote_ID($request_for_Quote_ID = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_ID) && !is_string($request_for_Quote_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_ID, true), gettype($request_for_Quote_ID)), __LINE__);
        }
        $this->Request_for_Quote_ID = $request_for_Quote_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get RFQ_Number value
     * @return string|null
     */
    public function getRFQ_Number()
    {
        return $this->RFQ_Number;
    }
    /**
     * Set RFQ_Number value
     * @param string $rFQ_Number
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRFQ_Number($rFQ_Number = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Number) && !is_string($rFQ_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Number, true), gettype($rFQ_Number)), __LINE__);
        }
        $this->RFQ_Number = $rFQ_Number;
        return $this;
    }
    /**
     * Get RFQ_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRFQ_Status_Reference()
    {
        return $this->RFQ_Status_Reference;
    }
    /**
     * Set RFQ_Status_Reference value
     * @param \StructType\Document_StatusObjectType $rFQ_Status_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRFQ_Status_Reference(\StructType\Document_StatusObjectType $rFQ_Status_Reference = null)
    {
        $this->RFQ_Status_Reference = $rFQ_Status_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get RFQ_Type_Reference value
     * @return \StructType\Request_for_Quote_TypeObjectType|null
     */
    public function getRFQ_Type_Reference()
    {
        return $this->RFQ_Type_Reference;
    }
    /**
     * Set RFQ_Type_Reference value
     * @param \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRFQ_Type_Reference(\StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference = null)
    {
        $this->RFQ_Type_Reference = $rFQ_Type_Reference;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get RFQ_Start_Date value
     * @return string|null
     */
    public function getRFQ_Start_Date()
    {
        return $this->RFQ_Start_Date;
    }
    /**
     * Set RFQ_Start_Date value
     * @param string $rFQ_Start_Date
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRFQ_Start_Date($rFQ_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Start_Date) && !is_string($rFQ_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Start_Date, true), gettype($rFQ_Start_Date)), __LINE__);
        }
        $this->RFQ_Start_Date = $rFQ_Start_Date;
        return $this;
    }
    /**
     * Get RFQ_End_Date value
     * @return string|null
     */
    public function getRFQ_End_Date()
    {
        return $this->RFQ_End_Date;
    }
    /**
     * Set RFQ_End_Date value
     * @param string $rFQ_End_Date
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRFQ_End_Date($rFQ_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_End_Date) && !is_string($rFQ_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_End_Date, true), gettype($rFQ_End_Date)), __LINE__);
        }
        $this->RFQ_End_Date = $rFQ_End_Date;
        return $this;
    }
    /**
     * Get Time_Zone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getTime_Zone_Reference()
    {
        return $this->Time_Zone_Reference;
    }
    /**
     * Set Time_Zone_Reference value
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setTime_Zone_Reference(\StructType\Time_ZoneObjectType $time_Zone_Reference = null)
    {
        $this->Time_Zone_Reference = $time_Zone_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getSourcing_Buyer_Reference()
    {
        return $this->Sourcing_Buyer_Reference;
    }
    /**
     * Set Sourcing_Buyer_Reference value
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setSourcing_Buyer_Reference(\StructType\WorkerObjectType $sourcing_Buyer_Reference = null)
    {
        $this->Sourcing_Buyer_Reference = $sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Get Exclude_Target_Price value
     * @return bool|null
     */
    public function getExclude_Target_Price()
    {
        return $this->Exclude_Target_Price;
    }
    /**
     * Set Exclude_Target_Price value
     * @param bool $exclude_Target_Price
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setExclude_Target_Price($exclude_Target_Price = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_Target_Price) && !is_bool($exclude_Target_Price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_Target_Price, true), gettype($exclude_Target_Price)), __LINE__);
        }
        $this->Exclude_Target_Price = $exclude_Target_Price;
        return $this;
    }
    /**
     * Get Request_for_Quote_Terms_and_Conditions value
     * @return string|null
     */
    public function getRequest_for_Quote_Terms_and_Conditions()
    {
        return $this->Request_for_Quote_Terms_and_Conditions;
    }
    /**
     * Set Request_for_Quote_Terms_and_Conditions value
     * @param string $request_for_Quote_Terms_and_Conditions
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRequest_for_Quote_Terms_and_Conditions($request_for_Quote_Terms_and_Conditions = null)
    {
        // validation for constraint: string
        if (!is_null($request_for_Quote_Terms_and_Conditions) && !is_string($request_for_Quote_Terms_and_Conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_for_Quote_Terms_and_Conditions, true), gettype($request_for_Quote_Terms_and_Conditions)), __LINE__);
        }
        $this->Request_for_Quote_Terms_and_Conditions = $request_for_Quote_Terms_and_Conditions;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Request_for_Quote_Line_Data value
     * @return \StructType\Request_for_Quote_Line_DataType[]|null
     */
    public function getRequest_for_Quote_Line_Data()
    {
        return $this->Request_for_Quote_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem instanceof \StructType\Request_for_Quote_Line_DataType) {
                $invalidValues[] = is_object($request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem) ? get_class($request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem), var_export($request_for_Quote_DataTypeRequest_for_Quote_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Line_Data property can only contain items of type \StructType\Request_for_Quote_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_DataType[] $request_for_Quote_Line_Data
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRequest_for_Quote_Line_Data(array $request_for_Quote_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Line_DataArrayErrorMessage = self::validateRequest_for_Quote_Line_DataForArrayConstraintsFromSetRequest_for_Quote_Line_Data($request_for_Quote_Line_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Line_Data = $request_for_Quote_Line_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Line_DataType $item
     * @return \StructType\Request_for_Quote_DataType
     */
    public function addToRequest_for_Quote_Line_Data(\StructType\Request_for_Quote_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Line_Data property can only contain items of type \StructType\Request_for_Quote_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Participant_List_Data value
     * @return \StructType\Request_for_Quote_Participant_List_DataType[]|null
     */
    public function getRequest_for_Quote_Participant_List_Data()
    {
        return $this->Request_for_Quote_Participant_List_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Participant_List_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Participant_List_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Participant_List_DataForArrayConstraintsFromSetRequest_for_Quote_Participant_List_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem instanceof \StructType\Request_for_Quote_Participant_List_DataType) {
                $invalidValues[] = is_object($request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem) ? get_class($request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem), var_export($request_for_Quote_DataTypeRequest_for_Quote_Participant_List_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Participant_List_Data property can only contain items of type \StructType\Request_for_Quote_Participant_List_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Participant_List_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Participant_List_DataType[] $request_for_Quote_Participant_List_Data
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRequest_for_Quote_Participant_List_Data(array $request_for_Quote_Participant_List_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Participant_List_DataArrayErrorMessage = self::validateRequest_for_Quote_Participant_List_DataForArrayConstraintsFromSetRequest_for_Quote_Participant_List_Data($request_for_Quote_Participant_List_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Participant_List_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Participant_List_Data = $request_for_Quote_Participant_List_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Participant_List_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Participant_List_DataType $item
     * @return \StructType\Request_for_Quote_DataType
     */
    public function addToRequest_for_Quote_Participant_List_Data(\StructType\Request_for_Quote_Participant_List_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Participant_List_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Participant_List_Data property can only contain items of type \StructType\Request_for_Quote_Participant_List_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Participant_List_Data[] = $item;
        return $this;
    }
    /**
     * Get Request_for_Quote_Bid_Requirement_Data value
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType[]|null
     */
    public function getRequest_for_Quote_Bid_Requirement_Data()
    {
        return $this->Request_for_Quote_Bid_Requirement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote_Bid_Requirement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote_Bid_Requirement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_Quote_Bid_Requirement_DataForArrayConstraintsFromSetRequest_for_Quote_Bid_Requirement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem instanceof \StructType\Request_for_Quote_Bid_Requirement_DataType) {
                $invalidValues[] = is_object($request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem) ? get_class($request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem), var_export($request_for_Quote_DataTypeRequest_for_Quote_Bid_Requirement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote_Bid_Requirement_Data property can only contain items of type \StructType\Request_for_Quote_Bid_Requirement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote_Bid_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Bid_Requirement_DataType[] $request_for_Quote_Bid_Requirement_Data
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setRequest_for_Quote_Bid_Requirement_Data(array $request_for_Quote_Bid_Requirement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_Quote_Bid_Requirement_DataArrayErrorMessage = self::validateRequest_for_Quote_Bid_Requirement_DataForArrayConstraintsFromSetRequest_for_Quote_Bid_Requirement_Data($request_for_Quote_Bid_Requirement_Data))) {
            throw new \InvalidArgumentException($request_for_Quote_Bid_Requirement_DataArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote_Bid_Requirement_Data = $request_for_Quote_Bid_Requirement_Data;
        return $this;
    }
    /**
     * Add item to Request_for_Quote_Bid_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_Bid_Requirement_DataType $item
     * @return \StructType\Request_for_Quote_DataType
     */
    public function addToRequest_for_Quote_Bid_Requirement_Data(\StructType\Request_for_Quote_Bid_Requirement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_Bid_Requirement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote_Bid_Requirement_Data property can only contain items of type \StructType\Request_for_Quote_Bid_Requirement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote_Bid_Requirement_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Business_Document_Attachment_with_External_Option_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
                $invalidValues[] = is_object($request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem) ? get_class($request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem), var_export($request_for_Quote_DataTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Request_for_Quote_DataType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Attachment_with_External_Option_DataType $item
     * @return \StructType\Request_for_Quote_DataType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Business_Document_Attachment_with_External_Option_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Attachment_with_External_Option_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Business_Document_Attachment_with_External_Option_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
}
