<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Default_Worktag_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Reference to existing Default Realted Worktag or Add new Default Related Worktag
 * @subpackage Structs
 */
class Default_Worktag_DataType extends AbstractStructBase
{
    /**
     * The Default_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: IMPORTANT: You must check 'Separate Type Column' for this field in your EIB template to see values when you generate a template with data or to configure related worktags for multiple worktag types. The list of valid ID types for
     * this column exceeds the size limit of an Excel validation list so ID types must be entered as text. Valid ID types for this column may include: Business_Unit_ID, Cost_Center_Reference_ID, Custom_Organization_Reference_ID, Custom_Worktag_1-5_ID,
     * Custom_Worktag_06-15_ID, Fund_ID, Gift_Reference_ID, Grant_ID, Investor_ID, Location_ID, Opportunity_Reference_ID, Organization_Reference_ID, Program_ID, Project_ID, Project_Phase_Name_ID, Project_Task_Name_ID, Region_Reference_ID,
     * Sales_Item_Group_ID, Sales_Item_ID.
     * - minOccurs: 0
     * @var \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType
     */
    public $Default_Worktag_Reference;
    /**
     * The Delete_Default_Value
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if existing default value is to be deleted. The existing default value must be correctly specified. Do not set to true (or 'y' in EIB) to replace the existing default value.
     * @var bool
     */
    public $Delete_Default_Value;
    /**
     * Constructor method for Default_Worktag_DataType
     * @uses Default_Worktag_DataType::setDefault_Worktag_Reference()
     * @uses Default_Worktag_DataType::setDelete_Default_Value()
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $default_Worktag_Reference
     * @param bool $delete_Default_Value
     */
    public function __construct(\StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $default_Worktag_Reference = null, $delete_Default_Value = null)
    {
        $this
            ->setDefault_Worktag_Reference($default_Worktag_Reference)
            ->setDelete_Default_Value($delete_Default_Value);
    }
    /**
     * Get Default_Worktag_Reference value
     * @return \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType|null
     */
    public function getDefault_Worktag_Reference()
    {
        return $this->Default_Worktag_Reference;
    }
    /**
     * Set Default_Worktag_Reference value
     * @param \StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $default_Worktag_Reference
     * @return \StructType\Default_Worktag_DataType
     */
    public function setDefault_Worktag_Reference(\StructType\Accounting_Worktag_and_Aggregation_DimensionObjectType $default_Worktag_Reference = null)
    {
        $this->Default_Worktag_Reference = $default_Worktag_Reference;
        return $this;
    }
    /**
     * Get Delete_Default_Value value
     * @return bool|null
     */
    public function getDelete_Default_Value()
    {
        return $this->Delete_Default_Value;
    }
    /**
     * Set Delete_Default_Value value
     * @param bool $delete_Default_Value
     * @return \StructType\Default_Worktag_DataType
     */
    public function setDelete_Default_Value($delete_Default_Value = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete_Default_Value) && !is_bool($delete_Default_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete_Default_Value, true), gettype($delete_Default_Value)), __LINE__);
        }
        $this->Delete_Default_Value = $delete_Default_Value;
        return $this;
    }
}
