<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Card_Holder_Listing_File_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Card Holder Listing File response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Card_Holder_Listing_File_Response_DataType extends AbstractStructBase
{
    /**
     * The Card_Holder_Listing_File
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes Card Holder Listing File instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Card_Holder_Listing_FileType[]
     */
    public $Card_Holder_Listing_File;
    /**
     * Constructor method for Card_Holder_Listing_File_Response_DataType
     * @uses Card_Holder_Listing_File_Response_DataType::setCard_Holder_Listing_File()
     * @param \StructType\Card_Holder_Listing_FileType[] $card_Holder_Listing_File
     */
    public function __construct(array $card_Holder_Listing_File = array())
    {
        $this
            ->setCard_Holder_Listing_File($card_Holder_Listing_File);
    }
    /**
     * Get Card_Holder_Listing_File value
     * @return \StructType\Card_Holder_Listing_FileType[]|null
     */
    public function getCard_Holder_Listing_File()
    {
        return $this->Card_Holder_Listing_File;
    }
    /**
     * This method is responsible for validating the values passed to the setCard_Holder_Listing_File method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCard_Holder_Listing_File method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCard_Holder_Listing_FileForArrayConstraintsFromSetCard_Holder_Listing_File(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem) {
            // validation for constraint: itemType
            if (!$card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem instanceof \StructType\Card_Holder_Listing_FileType) {
                $invalidValues[] = is_object($card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem) ? get_class($card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem) : sprintf('%s(%s)', gettype($card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem), var_export($card_Holder_Listing_File_Response_DataTypeCard_Holder_Listing_FileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Card_Holder_Listing_File property can only contain items of type \StructType\Card_Holder_Listing_FileType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Card_Holder_Listing_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Card_Holder_Listing_FileType[] $card_Holder_Listing_File
     * @return \StructType\Card_Holder_Listing_File_Response_DataType
     */
    public function setCard_Holder_Listing_File(array $card_Holder_Listing_File = array())
    {
        // validation for constraint: array
        if ('' !== ($card_Holder_Listing_FileArrayErrorMessage = self::validateCard_Holder_Listing_FileForArrayConstraintsFromSetCard_Holder_Listing_File($card_Holder_Listing_File))) {
            throw new \InvalidArgumentException($card_Holder_Listing_FileArrayErrorMessage, __LINE__);
        }
        $this->Card_Holder_Listing_File = $card_Holder_Listing_File;
        return $this;
    }
    /**
     * Add item to Card_Holder_Listing_File value
     * @throws \InvalidArgumentException
     * @param \StructType\Card_Holder_Listing_FileType $item
     * @return \StructType\Card_Holder_Listing_File_Response_DataType
     */
    public function addToCard_Holder_Listing_File(\StructType\Card_Holder_Listing_FileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Card_Holder_Listing_FileType) {
            throw new \InvalidArgumentException(sprintf('The Card_Holder_Listing_File property can only contain items of type \StructType\Card_Holder_Listing_FileType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Card_Holder_Listing_File[] = $item;
        return $this;
    }
}
