<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Add_Supplier_Contract_Line_Hold_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Contract Reference and Lines which are being placed on Hold.
 * @subpackage Structs
 */
class Add_Supplier_Contract_Line_Hold_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Contract
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType[]
     */
    public $Business_Process_Parameters;
    /**
     * The Add_Supplier_Contract_Line_Hold_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Add_Supplier_Contract_Line_Hold_DataType[]
     */
    public $Add_Supplier_Contract_Line_Hold_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Add_Supplier_Contract_Line_Hold_RequestType
     * @uses Add_Supplier_Contract_Line_Hold_RequestType::setSupplier_Contract_Reference()
     * @uses Add_Supplier_Contract_Line_Hold_RequestType::setBusiness_Process_Parameters()
     * @uses Add_Supplier_Contract_Line_Hold_RequestType::setAdd_Supplier_Contract_Line_Hold_Data()
     * @uses Add_Supplier_Contract_Line_Hold_RequestType::setVersion()
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @param \StructType\Add_Supplier_Contract_Line_Hold_DataType[] $add_Supplier_Contract_Line_Hold_Data
     * @param string $version
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, array $business_Process_Parameters = array(), array $add_Supplier_Contract_Line_Hold_Data = array(), $version = null)
    {
        $this
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setAdd_Supplier_Contract_Line_Hold_Data($add_Supplier_Contract_Line_Hold_Data)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType[]|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Process_Parameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Process_Parameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem) {
            // validation for constraint: itemType
            if (!$add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem instanceof \StructType\Financials_Business_Process_ParametersType) {
                $invalidValues[] = is_object($add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem) ? get_class($add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem) : sprintf('%s(%s)', gettype($add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem), var_export($add_Supplier_Contract_Line_Hold_RequestTypeBusiness_Process_ParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType[] $business_Process_Parameters
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function setBusiness_Process_Parameters(array $business_Process_Parameters = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Process_ParametersArrayErrorMessage = self::validateBusiness_Process_ParametersForArrayConstraintsFromSetBusiness_Process_Parameters($business_Process_Parameters))) {
            throw new \InvalidArgumentException($business_Process_ParametersArrayErrorMessage, __LINE__);
        }
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Add item to Business_Process_Parameters value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Business_Process_ParametersType $item
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function addToBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Business_Process_ParametersType) {
            throw new \InvalidArgumentException(sprintf('The Business_Process_Parameters property can only contain items of type \StructType\Financials_Business_Process_ParametersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Process_Parameters[] = $item;
        return $this;
    }
    /**
     * Get Add_Supplier_Contract_Line_Hold_Data value
     * @return \StructType\Add_Supplier_Contract_Line_Hold_DataType[]|null
     */
    public function getAdd_Supplier_Contract_Line_Hold_Data()
    {
        return $this->Add_Supplier_Contract_Line_Hold_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdd_Supplier_Contract_Line_Hold_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdd_Supplier_Contract_Line_Hold_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdd_Supplier_Contract_Line_Hold_DataForArrayConstraintsFromSetAdd_Supplier_Contract_Line_Hold_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem) {
            // validation for constraint: itemType
            if (!$add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem instanceof \StructType\Add_Supplier_Contract_Line_Hold_DataType) {
                $invalidValues[] = is_object($add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem) ? get_class($add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem) : sprintf('%s(%s)', gettype($add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem), var_export($add_Supplier_Contract_Line_Hold_RequestTypeAdd_Supplier_Contract_Line_Hold_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Add_Supplier_Contract_Line_Hold_Data property can only contain items of type \StructType\Add_Supplier_Contract_Line_Hold_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Add_Supplier_Contract_Line_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Add_Supplier_Contract_Line_Hold_DataType[] $add_Supplier_Contract_Line_Hold_Data
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function setAdd_Supplier_Contract_Line_Hold_Data(array $add_Supplier_Contract_Line_Hold_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($add_Supplier_Contract_Line_Hold_DataArrayErrorMessage = self::validateAdd_Supplier_Contract_Line_Hold_DataForArrayConstraintsFromSetAdd_Supplier_Contract_Line_Hold_Data($add_Supplier_Contract_Line_Hold_Data))) {
            throw new \InvalidArgumentException($add_Supplier_Contract_Line_Hold_DataArrayErrorMessage, __LINE__);
        }
        $this->Add_Supplier_Contract_Line_Hold_Data = $add_Supplier_Contract_Line_Hold_Data;
        return $this;
    }
    /**
     * Add item to Add_Supplier_Contract_Line_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Add_Supplier_Contract_Line_Hold_DataType $item
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function addToAdd_Supplier_Contract_Line_Hold_Data(\StructType\Add_Supplier_Contract_Line_Hold_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Add_Supplier_Contract_Line_Hold_DataType) {
            throw new \InvalidArgumentException(sprintf('The Add_Supplier_Contract_Line_Hold_Data property can only contain items of type \StructType\Add_Supplier_Contract_Line_Hold_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Add_Supplier_Contract_Line_Hold_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Add_Supplier_Contract_Line_Hold_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
