<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_ScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Invoice Schedule Instance and Data
 * @subpackage Structs
 */
class Supplier_Invoice_ScheduleType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Schedule
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_ScheduleObjectType
     */
    public $Supplier_Invoice_Schedule_Reference;
    /**
     * The Supplier_Invoice_Schedule_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Schedule Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Schedule_DataType[]
     */
    public $Supplier_Invoice_Schedule_Data;
    /**
     * Constructor method for Supplier_Invoice_ScheduleType
     * @uses Supplier_Invoice_ScheduleType::setSupplier_Invoice_Schedule_Reference()
     * @uses Supplier_Invoice_ScheduleType::setSupplier_Invoice_Schedule_Data()
     * @param \StructType\Supplier_Invoice_ScheduleObjectType $supplier_Invoice_Schedule_Reference
     * @param \StructType\Supplier_Invoice_Schedule_DataType[] $supplier_Invoice_Schedule_Data
     */
    public function __construct(\StructType\Supplier_Invoice_ScheduleObjectType $supplier_Invoice_Schedule_Reference = null, array $supplier_Invoice_Schedule_Data = array())
    {
        $this
            ->setSupplier_Invoice_Schedule_Reference($supplier_Invoice_Schedule_Reference)
            ->setSupplier_Invoice_Schedule_Data($supplier_Invoice_Schedule_Data);
    }
    /**
     * Get Supplier_Invoice_Schedule_Reference value
     * @return \StructType\Supplier_Invoice_ScheduleObjectType|null
     */
    public function getSupplier_Invoice_Schedule_Reference()
    {
        return $this->Supplier_Invoice_Schedule_Reference;
    }
    /**
     * Set Supplier_Invoice_Schedule_Reference value
     * @param \StructType\Supplier_Invoice_ScheduleObjectType $supplier_Invoice_Schedule_Reference
     * @return \StructType\Supplier_Invoice_ScheduleType
     */
    public function setSupplier_Invoice_Schedule_Reference(\StructType\Supplier_Invoice_ScheduleObjectType $supplier_Invoice_Schedule_Reference = null)
    {
        $this->Supplier_Invoice_Schedule_Reference = $supplier_Invoice_Schedule_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Schedule_Data value
     * @return \StructType\Supplier_Invoice_Schedule_DataType[]|null
     */
    public function getSupplier_Invoice_Schedule_Data()
    {
        return $this->Supplier_Invoice_Schedule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Schedule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Schedule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Schedule_DataForArrayConstraintsFromSetSupplier_Invoice_Schedule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem instanceof \StructType\Supplier_Invoice_Schedule_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem) ? get_class($supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem), var_export($supplier_Invoice_ScheduleTypeSupplier_Invoice_Schedule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Schedule_Data property can only contain items of type \StructType\Supplier_Invoice_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Schedule_DataType[] $supplier_Invoice_Schedule_Data
     * @return \StructType\Supplier_Invoice_ScheduleType
     */
    public function setSupplier_Invoice_Schedule_Data(array $supplier_Invoice_Schedule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Schedule_DataArrayErrorMessage = self::validateSupplier_Invoice_Schedule_DataForArrayConstraintsFromSetSupplier_Invoice_Schedule_Data($supplier_Invoice_Schedule_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Schedule_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Schedule_Data = $supplier_Invoice_Schedule_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Schedule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Schedule_DataType $item
     * @return \StructType\Supplier_Invoice_ScheduleType
     */
    public function addToSupplier_Invoice_Schedule_Data(\StructType\Supplier_Invoice_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Schedule_Data property can only contain items of type \StructType\Supplier_Invoice_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Schedule_Data[] = $item;
        return $this;
    }
}
