<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing guest response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Guest_Response_DataType extends AbstractStructBase
{
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes guest instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Guest_WWSType[]
     */
    public $Guest;
    /**
     * Constructor method for Guest_Response_DataType
     * @uses Guest_Response_DataType::setGuest()
     * @param \StructType\Guest_WWSType[] $guest
     */
    public function __construct(array $guest = array())
    {
        $this
            ->setGuest($guest);
    }
    /**
     * Get Guest value
     * @return \StructType\Guest_WWSType[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $guest_Response_DataTypeGuestItem) {
            // validation for constraint: itemType
            if (!$guest_Response_DataTypeGuestItem instanceof \StructType\Guest_WWSType) {
                $invalidValues[] = is_object($guest_Response_DataTypeGuestItem) ? get_class($guest_Response_DataTypeGuestItem) : sprintf('%s(%s)', gettype($guest_Response_DataTypeGuestItem), var_export($guest_Response_DataTypeGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \StructType\Guest_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_WWSType[] $guest
     * @return \StructType\Guest_Response_DataType
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \StructType\Guest_WWSType $item
     * @return \StructType\Guest_Response_DataType
     */
    public function addToGuest(\StructType\Guest_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Guest_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \StructType\Guest_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
}
