<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_City_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Cities with the same Data Value, Country Region, and Country combination is not allowed. | Element that contains Travel City Data
 * @subpackage Structs
 */
class Travel_City_DataType extends AbstractStructBase
{
    /**
     * The Spend_Data_ID
     * Meta information extracted from the WSDL
     * - documentation: Travel City ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Spend_Data_ID;
    /**
     * The Travel_City_Value
     * Meta information extracted from the WSDL
     * - documentation: Travel City Value
     * - maxOccurs: 1
     * @var string
     */
    public $Travel_City_Value;
    /**
     * The Travel_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Travel Region and Country combination must be valid. | Reference to a Travel Region.
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Travel_Region_Reference;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Country.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Alternate_Travel_City_Name
     * Meta information extracted from the WSDL
     * - documentation: Element used to specify alternate names.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_City_Alternate_Name_DataType[]
     */
    public $Alternate_Travel_City_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Travel_City_DataType
     * @uses Travel_City_DataType::setSpend_Data_ID()
     * @uses Travel_City_DataType::setTravel_City_Value()
     * @uses Travel_City_DataType::setTravel_Region_Reference()
     * @uses Travel_City_DataType::setCountry_Reference()
     * @uses Travel_City_DataType::setAlternate_Travel_City_Name()
     * @uses Travel_City_DataType::setInactive()
     * @param string $spend_Data_ID
     * @param string $travel_City_Value
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Travel_City_Alternate_Name_DataType[] $alternate_Travel_City_Name
     * @param bool $inactive
     */
    public function __construct($spend_Data_ID = null, $travel_City_Value = null, \StructType\Country_RegionObjectType $travel_Region_Reference = null, \StructType\CountryObjectType $country_Reference = null, array $alternate_Travel_City_Name = array(), $inactive = null)
    {
        $this
            ->setSpend_Data_ID($spend_Data_ID)
            ->setTravel_City_Value($travel_City_Value)
            ->setTravel_Region_Reference($travel_Region_Reference)
            ->setCountry_Reference($country_Reference)
            ->setAlternate_Travel_City_Name($alternate_Travel_City_Name)
            ->setInactive($inactive);
    }
    /**
     * Get Spend_Data_ID value
     * @return string|null
     */
    public function getSpend_Data_ID()
    {
        return $this->Spend_Data_ID;
    }
    /**
     * Set Spend_Data_ID value
     * @param string $spend_Data_ID
     * @return \StructType\Travel_City_DataType
     */
    public function setSpend_Data_ID($spend_Data_ID = null)
    {
        // validation for constraint: string
        if (!is_null($spend_Data_ID) && !is_string($spend_Data_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spend_Data_ID, true), gettype($spend_Data_ID)), __LINE__);
        }
        $this->Spend_Data_ID = $spend_Data_ID;
        return $this;
    }
    /**
     * Get Travel_City_Value value
     * @return string|null
     */
    public function getTravel_City_Value()
    {
        return $this->Travel_City_Value;
    }
    /**
     * Set Travel_City_Value value
     * @param string $travel_City_Value
     * @return \StructType\Travel_City_DataType
     */
    public function setTravel_City_Value($travel_City_Value = null)
    {
        // validation for constraint: string
        if (!is_null($travel_City_Value) && !is_string($travel_City_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_City_Value, true), gettype($travel_City_Value)), __LINE__);
        }
        $this->Travel_City_Value = $travel_City_Value;
        return $this;
    }
    /**
     * Get Travel_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getTravel_Region_Reference()
    {
        return $this->Travel_Region_Reference;
    }
    /**
     * Set Travel_Region_Reference value
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     * @return \StructType\Travel_City_DataType
     */
    public function setTravel_Region_Reference(\StructType\Country_RegionObjectType $travel_Region_Reference = null)
    {
        $this->Travel_Region_Reference = $travel_Region_Reference;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Travel_City_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Alternate_Travel_City_Name value
     * @return \StructType\Travel_City_Alternate_Name_DataType[]|null
     */
    public function getAlternate_Travel_City_Name()
    {
        return $this->Alternate_Travel_City_Name;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Travel_City_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Travel_City_Name method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Travel_City_NameForArrayConstraintsFromSetAlternate_Travel_City_Name(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_City_DataTypeAlternate_Travel_City_NameItem) {
            // validation for constraint: itemType
            if (!$travel_City_DataTypeAlternate_Travel_City_NameItem instanceof \StructType\Travel_City_Alternate_Name_DataType) {
                $invalidValues[] = is_object($travel_City_DataTypeAlternate_Travel_City_NameItem) ? get_class($travel_City_DataTypeAlternate_Travel_City_NameItem) : sprintf('%s(%s)', gettype($travel_City_DataTypeAlternate_Travel_City_NameItem), var_export($travel_City_DataTypeAlternate_Travel_City_NameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Travel_City_Name property can only contain items of type \StructType\Travel_City_Alternate_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Travel_City_Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_City_Alternate_Name_DataType[] $alternate_Travel_City_Name
     * @return \StructType\Travel_City_DataType
     */
    public function setAlternate_Travel_City_Name(array $alternate_Travel_City_Name = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Travel_City_NameArrayErrorMessage = self::validateAlternate_Travel_City_NameForArrayConstraintsFromSetAlternate_Travel_City_Name($alternate_Travel_City_Name))) {
            throw new \InvalidArgumentException($alternate_Travel_City_NameArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Travel_City_Name = $alternate_Travel_City_Name;
        return $this;
    }
    /**
     * Add item to Alternate_Travel_City_Name value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_City_Alternate_Name_DataType $item
     * @return \StructType\Travel_City_DataType
     */
    public function addToAlternate_Travel_City_Name(\StructType\Travel_City_Alternate_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_City_Alternate_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Travel_City_Name property can only contain items of type \StructType\Travel_City_Alternate_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Travel_City_Name[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Travel_City_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
