<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Request_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the Reference to the Supplier Invoice Request along with its content
 * @subpackage Structs
 */
class Supplier_Invoice_Request_OutboundType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Request_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier Invoice Request
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_RequestObjectType
     */
    public $Supplier_Invoice_Request_Reference;
    /**
     * The Supplier_Invoice_Request_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the contents of the entire Supplier Invoice Request, including Lines (with and without splits) and Attachments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Request_Data_OutboundType[]
     */
    public $Supplier_Invoice_Request_Data;
    /**
     * Constructor method for Supplier_Invoice_Request_OutboundType
     * @uses Supplier_Invoice_Request_OutboundType::setSupplier_Invoice_Request_Reference()
     * @uses Supplier_Invoice_Request_OutboundType::setSupplier_Invoice_Request_Data()
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @param \StructType\Supplier_Invoice_Request_Data_OutboundType[] $supplier_Invoice_Request_Data
     */
    public function __construct(\StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null, array $supplier_Invoice_Request_Data = array())
    {
        $this
            ->setSupplier_Invoice_Request_Reference($supplier_Invoice_Request_Reference)
            ->setSupplier_Invoice_Request_Data($supplier_Invoice_Request_Data);
    }
    /**
     * Get Supplier_Invoice_Request_Reference value
     * @return \StructType\Supplier_Invoice_RequestObjectType|null
     */
    public function getSupplier_Invoice_Request_Reference()
    {
        return $this->Supplier_Invoice_Request_Reference;
    }
    /**
     * Set Supplier_Invoice_Request_Reference value
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @return \StructType\Supplier_Invoice_Request_OutboundType
     */
    public function setSupplier_Invoice_Request_Reference(\StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null)
    {
        $this->Supplier_Invoice_Request_Reference = $supplier_Invoice_Request_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Request_Data value
     * @return \StructType\Supplier_Invoice_Request_Data_OutboundType[]|null
     */
    public function getSupplier_Invoice_Request_Data()
    {
        return $this->Supplier_Invoice_Request_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Request_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Request_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Request_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem instanceof \StructType\Supplier_Invoice_Request_Data_OutboundType) {
                $invalidValues[] = is_object($supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem) ? get_class($supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem), var_export($supplier_Invoice_Request_OutboundTypeSupplier_Invoice_Request_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Request_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Request_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Data_OutboundType[] $supplier_Invoice_Request_Data
     * @return \StructType\Supplier_Invoice_Request_OutboundType
     */
    public function setSupplier_Invoice_Request_Data(array $supplier_Invoice_Request_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Request_DataArrayErrorMessage = self::validateSupplier_Invoice_Request_DataForArrayConstraintsFromSetSupplier_Invoice_Request_Data($supplier_Invoice_Request_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Request_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Request_Data = $supplier_Invoice_Request_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Request_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Request_Data_OutboundType $item
     * @return \StructType\Supplier_Invoice_Request_OutboundType
     */
    public function addToSupplier_Invoice_Request_Data(\StructType\Supplier_Invoice_Request_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Request_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Request_Data property can only contain items of type \StructType\Supplier_Invoice_Request_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Request_Data[] = $item;
        return $this;
    }
}
