<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Category_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Supplier Category data
 * @subpackage Structs
 */
class Supplier_Category_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Category_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Category Reference ID. This is the Supplier Category unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Category_ID;
    /**
     * The Supplier_Category_Name
     * Meta information extracted from the WSDL
     * - documentation: The Supplier Category Name is already in use. | Free form text field for a meaningful Supplier Category Name
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Category_Name;
    /**
     * Constructor method for Supplier_Category_DataType
     * @uses Supplier_Category_DataType::setSupplier_Category_ID()
     * @uses Supplier_Category_DataType::setSupplier_Category_Name()
     * @param string $supplier_Category_ID
     * @param string $supplier_Category_Name
     */
    public function __construct($supplier_Category_ID = null, $supplier_Category_Name = null)
    {
        $this
            ->setSupplier_Category_ID($supplier_Category_ID)
            ->setSupplier_Category_Name($supplier_Category_Name);
    }
    /**
     * Get Supplier_Category_ID value
     * @return string|null
     */
    public function getSupplier_Category_ID()
    {
        return $this->Supplier_Category_ID;
    }
    /**
     * Set Supplier_Category_ID value
     * @param string $supplier_Category_ID
     * @return \StructType\Supplier_Category_DataType
     */
    public function setSupplier_Category_ID($supplier_Category_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Category_ID) && !is_string($supplier_Category_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Category_ID, true), gettype($supplier_Category_ID)), __LINE__);
        }
        $this->Supplier_Category_ID = $supplier_Category_ID;
        return $this;
    }
    /**
     * Get Supplier_Category_Name value
     * @return string|null
     */
    public function getSupplier_Category_Name()
    {
        return $this->Supplier_Category_Name;
    }
    /**
     * Set Supplier_Category_Name value
     * @param string $supplier_Category_Name
     * @return \StructType\Supplier_Category_DataType
     */
    public function setSupplier_Category_Name($supplier_Category_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Category_Name) && !is_string($supplier_Category_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Category_Name, true), gettype($supplier_Category_Name)), __LINE__);
        }
        $this->Supplier_Category_Name = $supplier_Category_Name;
        return $this;
    }
}
