<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Requirement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: new web service
 * @subpackage Structs
 */
class Resource_Plan_Requirement_DataType extends AbstractStructBase
{
    /**
     * The Resource_Plan_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_ID;
    /**
     * The Resource_Plan_Line_Requirement_Data
     * Meta information extracted from the WSDL
     * - documentation: .
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_Line_Requirement_DataType[]
     */
    public $Resource_Plan_Line_Requirement_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: .
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Resource_Plan_Requirement_DataType
     * @uses Resource_Plan_Requirement_DataType::setResource_Plan_ID()
     * @uses Resource_Plan_Requirement_DataType::setResource_Plan_Line_Requirement_Data()
     * @uses Resource_Plan_Requirement_DataType::setReplace_All()
     * @param string $resource_Plan_ID
     * @param \StructType\Resource_Plan_Line_Requirement_DataType[] $resource_Plan_Line_Requirement_Data
     * @param bool $replace_All
     */
    public function __construct($resource_Plan_ID = null, array $resource_Plan_Line_Requirement_Data = array(), $replace_All = null)
    {
        $this
            ->setResource_Plan_ID($resource_Plan_ID)
            ->setResource_Plan_Line_Requirement_Data($resource_Plan_Line_Requirement_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Resource_Plan_ID value
     * @return string|null
     */
    public function getResource_Plan_ID()
    {
        return $this->Resource_Plan_ID;
    }
    /**
     * Set Resource_Plan_ID value
     * @param string $resource_Plan_ID
     * @return \StructType\Resource_Plan_Requirement_DataType
     */
    public function setResource_Plan_ID($resource_Plan_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_ID) && !is_string($resource_Plan_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_ID, true), gettype($resource_Plan_ID)), __LINE__);
        }
        $this->Resource_Plan_ID = $resource_Plan_ID;
        return $this;
    }
    /**
     * Get Resource_Plan_Line_Requirement_Data value
     * @return \StructType\Resource_Plan_Line_Requirement_DataType[]|null
     */
    public function getResource_Plan_Line_Requirement_Data()
    {
        return $this->Resource_Plan_Line_Requirement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Plan_Line_Requirement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Plan_Line_Requirement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Plan_Line_Requirement_DataForArrayConstraintsFromSetResource_Plan_Line_Requirement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem instanceof \StructType\Resource_Plan_Line_Requirement_DataType) {
                $invalidValues[] = is_object($resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem) ? get_class($resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem), var_export($resource_Plan_Requirement_DataTypeResource_Plan_Line_Requirement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Plan_Line_Requirement_Data property can only contain items of type \StructType\Resource_Plan_Line_Requirement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Plan_Line_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Line_Requirement_DataType[] $resource_Plan_Line_Requirement_Data
     * @return \StructType\Resource_Plan_Requirement_DataType
     */
    public function setResource_Plan_Line_Requirement_Data(array $resource_Plan_Line_Requirement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Plan_Line_Requirement_DataArrayErrorMessage = self::validateResource_Plan_Line_Requirement_DataForArrayConstraintsFromSetResource_Plan_Line_Requirement_Data($resource_Plan_Line_Requirement_Data))) {
            throw new \InvalidArgumentException($resource_Plan_Line_Requirement_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_Data = $resource_Plan_Line_Requirement_Data;
        return $this;
    }
    /**
     * Add item to Resource_Plan_Line_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Line_Requirement_DataType $item
     * @return \StructType\Resource_Plan_Requirement_DataType
     */
    public function addToResource_Plan_Line_Requirement_Data(\StructType\Resource_Plan_Line_Requirement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Plan_Line_Requirement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Plan_Line_Requirement_Data property can only contain items of type \StructType\Resource_Plan_Line_Requirement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Resource_Plan_Requirement_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
