<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Item_Line_Lot_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receipt Adjustment Item Line Lot Data
 * @subpackage Structs
 */
class Receipt_Adjustment_Item_Line_Lot_DataType extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Item_Lot_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Lot
     * - minOccurs: 0
     * @var \StructType\Item_LotObjectType
     */
    public $Item_Lot_Reference;
    /**
     * The Item_Serial_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Serial
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_SerialObjectType[]
     */
    public $Item_Serial_Reference;
    /**
     * The Stocking_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Stocking Location
     * - minOccurs: 0
     * @var \StructType\Inventory_Location_EnabledObjectType
     */
    public $Stocking_Location_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Stocking Unit of Measure
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * Constructor method for Receipt_Adjustment_Item_Line_Lot_DataType
     * @uses Receipt_Adjustment_Item_Line_Lot_DataType::setQuantity()
     * @uses Receipt_Adjustment_Item_Line_Lot_DataType::setItem_Lot_Reference()
     * @uses Receipt_Adjustment_Item_Line_Lot_DataType::setItem_Serial_Reference()
     * @uses Receipt_Adjustment_Item_Line_Lot_DataType::setStocking_Location_Reference()
     * @uses Receipt_Adjustment_Item_Line_Lot_DataType::setUnit_of_Measure_Reference()
     * @param float $quantity
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     * @param \StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     */
    public function __construct($quantity = null, \StructType\Item_LotObjectType $item_Lot_Reference = null, array $item_Serial_Reference = array(), \StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this
            ->setQuantity($quantity)
            ->setItem_Lot_Reference($item_Lot_Reference)
            ->setItem_Serial_Reference($item_Serial_Reference)
            ->setStocking_Location_Reference($stocking_Location_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference);
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Item_Lot_Reference value
     * @return \StructType\Item_LotObjectType|null
     */
    public function getItem_Lot_Reference()
    {
        return $this->Item_Lot_Reference;
    }
    /**
     * Set Item_Lot_Reference value
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function setItem_Lot_Reference(\StructType\Item_LotObjectType $item_Lot_Reference = null)
    {
        $this->Item_Lot_Reference = $item_Lot_Reference;
        return $this;
    }
    /**
     * Get Item_Serial_Reference value
     * @return \StructType\Item_SerialObjectType[]|null
     */
    public function getItem_Serial_Reference()
    {
        return $this->Item_Serial_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Serial_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Serial_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem instanceof \StructType\Item_SerialObjectType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem) ? get_class($receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem), var_export($receipt_Adjustment_Item_Line_Lot_DataTypeItem_Serial_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function setItem_Serial_Reference(array $item_Serial_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Serial_ReferenceArrayErrorMessage = self::validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference($item_Serial_Reference))) {
            throw new \InvalidArgumentException($item_Serial_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Serial_Reference = $item_Serial_Reference;
        return $this;
    }
    /**
     * Add item to Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function addToItem_Serial_Reference(\StructType\Item_SerialObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_SerialObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Serial_Reference[] = $item;
        return $this;
    }
    /**
     * Get Stocking_Location_Reference value
     * @return \StructType\Inventory_Location_EnabledObjectType|null
     */
    public function getStocking_Location_Reference()
    {
        return $this->Stocking_Location_Reference;
    }
    /**
     * Set Stocking_Location_Reference value
     * @param \StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function setStocking_Location_Reference(\StructType\Inventory_Location_EnabledObjectType $stocking_Location_Reference = null)
    {
        $this->Stocking_Location_Reference = $stocking_Location_Reference;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_Lot_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
}
