<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Award_PO_Defaults_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture PO Defaults at the time of creating a RFQ Award document
 * @subpackage Structs
 */
class RFQ_Award_PO_Defaults_Data_InboundType extends AbstractStructBase
{
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship-To Contact Person for RFQ Award Purchase Order Defaults
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Ship_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Ship To Contact for RFQ Award PO Defaults
     * - maxOccurs: 1
     * @var string
     */
    public $Ship_To_Contact_Detail;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship To Address for RFQ Award PO Defaults
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Bill_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Contact Person for RFQ Award Purchase Order Defaults
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Bill_To_Contact_Reference;
    /**
     * The Bill_To_Contact_Detail
     * Meta information extracted from the WSDL
     * - documentation: Bill To Contact for RFQ Award PO Defaults
     * - maxOccurs: 1
     * @var string
     */
    public $Bill_To_Contact_Detail;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bill To Address for RFQ Award PO Defaults
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Purchase_Order_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order Type in the system.
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType
     */
    public $Purchase_Order_Type_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Payment Terms for RFQ Award PO Defaults
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Issue Option for RFQ Award PO Defaults
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Issue_Option_Reference;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Buyer Reference for RFQ Award PO Defaults
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms Reference for Request for Quote Award
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Method Reference for Request for Quote Award
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Shipping_Instruction
     * Meta information extracted from the WSDL
     * - documentation: Shipping Instruction for Request for Quote Award
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipping_Instruction;
    /**
     * Constructor method for RFQ_Award_PO_Defaults_Data_InboundType
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShip_To_Contact_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShip_To_Contact_Detail()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShip_To_Address_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setBill_To_Contact_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setBill_To_Contact_Detail()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setBill_To_Address_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setPurchase_Order_Type_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setPayment_Terms_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setIssue_Option_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setBuyer_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShipping_Terms_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShipping_Method_Reference()
     * @uses RFQ_Award_PO_Defaults_Data_InboundType::setShipping_Instruction()
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param string $ship_To_Contact_Detail
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $bill_To_Contact_Reference
     * @param string $bill_To_Contact_Detail
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param string $shipping_Instruction
     */
    public function __construct(\StructType\WorkerObjectType $ship_To_Contact_Reference = null, $ship_To_Contact_Detail = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $bill_To_Contact_Reference = null, $bill_To_Contact_Detail = null, \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, \StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null, \StructType\WorkerObjectType $buyer_Reference = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, $shipping_Instruction = null)
    {
        $this
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setShip_To_Contact_Detail($ship_To_Contact_Detail)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setBill_To_Contact_Reference($bill_To_Contact_Reference)
            ->setBill_To_Contact_Detail($bill_To_Contact_Detail)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setPurchase_Order_Type_Reference($purchase_Order_Type_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setIssue_Option_Reference($issue_Option_Reference)
            ->setBuyer_Reference($buyer_Reference)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setShipping_Instruction($shipping_Instruction);
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->{'Ship-To_Contact_Reference'};
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $this->{'Ship-To_Contact_Reference'} = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Detail value
     * @return string|null
     */
    public function getShip_To_Contact_Detail()
    {
        return $this->{'Ship-To_Contact_Detail'};
    }
    /**
     * Set Ship_To_Contact_Detail value
     * @param string $ship_To_Contact_Detail
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShip_To_Contact_Detail($ship_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Contact_Detail) && !is_string($ship_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Contact_Detail, true), gettype($ship_To_Contact_Detail)), __LINE__);
        }
        $this->Ship_To_Contact_Detail = $this->{'Ship-To_Contact_Detail'} = $ship_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBill_To_Contact_Reference()
    {
        return $this->{'Bill-To_Contact_Reference'};
    }
    /**
     * Set Bill_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $bill_To_Contact_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setBill_To_Contact_Reference(\StructType\WorkerObjectType $bill_To_Contact_Reference = null)
    {
        $this->Bill_To_Contact_Reference = $this->{'Bill-To_Contact_Reference'} = $bill_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Bill_To_Contact_Detail value
     * @return string|null
     */
    public function getBill_To_Contact_Detail()
    {
        return $this->{'Bill-To_Contact_Detail'};
    }
    /**
     * Set Bill_To_Contact_Detail value
     * @param string $bill_To_Contact_Detail
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setBill_To_Contact_Detail($bill_To_Contact_Detail = null)
    {
        // validation for constraint: string
        if (!is_null($bill_To_Contact_Detail) && !is_string($bill_To_Contact_Detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_To_Contact_Detail, true), gettype($bill_To_Contact_Detail)), __LINE__);
        }
        $this->Bill_To_Contact_Detail = $this->{'Bill-To_Contact_Detail'} = $bill_To_Contact_Detail;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->Bill_To_Address_Reference;
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Type_Reference value
     * @return \StructType\Order_TypeObjectType|null
     */
    public function getPurchase_Order_Type_Reference()
    {
        return $this->Purchase_Order_Type_Reference;
    }
    /**
     * Set Purchase_Order_Type_Reference value
     * @param \StructType\Order_TypeObjectType $purchase_Order_Type_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setPurchase_Order_Type_Reference(\StructType\Order_TypeObjectType $purchase_Order_Type_Reference = null)
    {
        $this->Purchase_Order_Type_Reference = $purchase_Order_Type_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getIssue_Option_Reference()
    {
        return $this->Issue_Option_Reference;
    }
    /**
     * Set Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setIssue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $issue_Option_Reference = null)
    {
        $this->Issue_Option_Reference = $issue_Option_Reference;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Shipping_Instruction value
     * @return string|null
     */
    public function getShipping_Instruction()
    {
        return $this->Shipping_Instruction;
    }
    /**
     * Set Shipping_Instruction value
     * @param string $shipping_Instruction
     * @return \StructType\RFQ_Award_PO_Defaults_Data_InboundType
     */
    public function setShipping_Instruction($shipping_Instruction = null)
    {
        // validation for constraint: string
        if (!is_null($shipping_Instruction) && !is_string($shipping_Instruction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipping_Instruction, true), gettype($shipping_Instruction)), __LINE__);
        }
        $this->Shipping_Instruction = $shipping_Instruction;
        return $this;
    }
}
