<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Cash_Advance_Repayment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Spend Authorization reference for update and all Cash Advance Repayment data items
 * @subpackage Structs
 */
class Put_Cash_Advance_Repayment_RequestType extends AbstractStructBase
{
    /**
     * The Cash_Advance_Repayment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Cash Advance Repayment for update only purposes
     * - minOccurs: 0
     * @var \StructType\Cash_Advance_RepaymentObjectType
     */
    public $Cash_Advance_Repayment_Reference;
    /**
     * The Cash_Advance_Repayment_Data
     * Meta information extracted from the WSDL
     * - documentation: Cash Advance Repayment
     * @var \StructType\Cash_Advance_Repayment_DataType
     */
    public $Cash_Advance_Repayment_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Cash_Advance_Repayment_RequestType
     * @uses Put_Cash_Advance_Repayment_RequestType::setCash_Advance_Repayment_Reference()
     * @uses Put_Cash_Advance_Repayment_RequestType::setCash_Advance_Repayment_Data()
     * @uses Put_Cash_Advance_Repayment_RequestType::setAdd_Only()
     * @uses Put_Cash_Advance_Repayment_RequestType::setVersion()
     * @param \StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference
     * @param \StructType\Cash_Advance_Repayment_DataType $cash_Advance_Repayment_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference = null, \StructType\Cash_Advance_Repayment_DataType $cash_Advance_Repayment_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setCash_Advance_Repayment_Reference($cash_Advance_Repayment_Reference)
            ->setCash_Advance_Repayment_Data($cash_Advance_Repayment_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Cash_Advance_Repayment_Reference value
     * @return \StructType\Cash_Advance_RepaymentObjectType|null
     */
    public function getCash_Advance_Repayment_Reference()
    {
        return $this->Cash_Advance_Repayment_Reference;
    }
    /**
     * Set Cash_Advance_Repayment_Reference value
     * @param \StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference
     * @return \StructType\Put_Cash_Advance_Repayment_RequestType
     */
    public function setCash_Advance_Repayment_Reference(\StructType\Cash_Advance_RepaymentObjectType $cash_Advance_Repayment_Reference = null)
    {
        $this->Cash_Advance_Repayment_Reference = $cash_Advance_Repayment_Reference;
        return $this;
    }
    /**
     * Get Cash_Advance_Repayment_Data value
     * @return \StructType\Cash_Advance_Repayment_DataType|null
     */
    public function getCash_Advance_Repayment_Data()
    {
        return $this->Cash_Advance_Repayment_Data;
    }
    /**
     * Set Cash_Advance_Repayment_Data value
     * @param \StructType\Cash_Advance_Repayment_DataType $cash_Advance_Repayment_Data
     * @return \StructType\Put_Cash_Advance_Repayment_RequestType
     */
    public function setCash_Advance_Repayment_Data(\StructType\Cash_Advance_Repayment_DataType $cash_Advance_Repayment_Data = null)
    {
        $this->Cash_Advance_Repayment_Data = $cash_Advance_Repayment_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Cash_Advance_Repayment_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Cash_Advance_Repayment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
