<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Substitute_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Substitute details.
 * @subpackage Structs
 */
class Purchase_Item_Substitute_DataType extends AbstractStructBase
{
    /**
     * The Ordering_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date of Item Substitution for Ordering.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordering_Start_Date;
    /**
     * The Ordering_End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date of Item Substitution for Ordering.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ordering_End_Date;
    /**
     * The Item_Substitute_Data
     * Meta information extracted from the WSDL
     * - documentation: Item Substitute details for the purchase item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Substitute_DataType[]
     */
    public $Item_Substitute_Data;
    /**
     * Constructor method for Purchase_Item_Substitute_DataType
     * @uses Purchase_Item_Substitute_DataType::setOrdering_Start_Date()
     * @uses Purchase_Item_Substitute_DataType::setOrdering_End_Date()
     * @uses Purchase_Item_Substitute_DataType::setItem_Substitute_Data()
     * @param string $ordering_Start_Date
     * @param string $ordering_End_Date
     * @param \StructType\Item_Substitute_DataType[] $item_Substitute_Data
     */
    public function __construct($ordering_Start_Date = null, $ordering_End_Date = null, array $item_Substitute_Data = array())
    {
        $this
            ->setOrdering_Start_Date($ordering_Start_Date)
            ->setOrdering_End_Date($ordering_End_Date)
            ->setItem_Substitute_Data($item_Substitute_Data);
    }
    /**
     * Get Ordering_Start_Date value
     * @return string|null
     */
    public function getOrdering_Start_Date()
    {
        return $this->Ordering_Start_Date;
    }
    /**
     * Set Ordering_Start_Date value
     * @param string $ordering_Start_Date
     * @return \StructType\Purchase_Item_Substitute_DataType
     */
    public function setOrdering_Start_Date($ordering_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($ordering_Start_Date) && !is_string($ordering_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordering_Start_Date, true), gettype($ordering_Start_Date)), __LINE__);
        }
        $this->Ordering_Start_Date = $ordering_Start_Date;
        return $this;
    }
    /**
     * Get Ordering_End_Date value
     * @return string|null
     */
    public function getOrdering_End_Date()
    {
        return $this->Ordering_End_Date;
    }
    /**
     * Set Ordering_End_Date value
     * @param string $ordering_End_Date
     * @return \StructType\Purchase_Item_Substitute_DataType
     */
    public function setOrdering_End_Date($ordering_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($ordering_End_Date) && !is_string($ordering_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordering_End_Date, true), gettype($ordering_End_Date)), __LINE__);
        }
        $this->Ordering_End_Date = $ordering_End_Date;
        return $this;
    }
    /**
     * Get Item_Substitute_Data value
     * @return \StructType\Item_Substitute_DataType[]|null
     */
    public function getItem_Substitute_Data()
    {
        return $this->Item_Substitute_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Substitute_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Substitute_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Substitute_DataForArrayConstraintsFromSetItem_Substitute_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Substitute_DataTypeItem_Substitute_DataItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Substitute_DataTypeItem_Substitute_DataItem instanceof \StructType\Item_Substitute_DataType) {
                $invalidValues[] = is_object($purchase_Item_Substitute_DataTypeItem_Substitute_DataItem) ? get_class($purchase_Item_Substitute_DataTypeItem_Substitute_DataItem) : sprintf('%s(%s)', gettype($purchase_Item_Substitute_DataTypeItem_Substitute_DataItem), var_export($purchase_Item_Substitute_DataTypeItem_Substitute_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Substitute_Data property can only contain items of type \StructType\Item_Substitute_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Substitute_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Substitute_DataType[] $item_Substitute_Data
     * @return \StructType\Purchase_Item_Substitute_DataType
     */
    public function setItem_Substitute_Data(array $item_Substitute_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Substitute_DataArrayErrorMessage = self::validateItem_Substitute_DataForArrayConstraintsFromSetItem_Substitute_Data($item_Substitute_Data))) {
            throw new \InvalidArgumentException($item_Substitute_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Substitute_Data = $item_Substitute_Data;
        return $this;
    }
    /**
     * Add item to Item_Substitute_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Substitute_DataType $item
     * @return \StructType\Purchase_Item_Substitute_DataType
     */
    public function addToItem_Substitute_Data(\StructType\Item_Substitute_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Substitute_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Substitute_Data property can only contain items of type \StructType\Item_Substitute_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Substitute_Data[] = $item;
        return $this;
    }
}
