<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Receipt_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify the same company for both the supplier contract header and the receipt header. | Purchase Order Line cannot be used because it has been Canceled. | You can’t create a receipt for this line as there’s no net quantity left
 * to receive. | Sum of Split Amount does not equal total amount. | Duplicate serial numbers entered.on Item Receipt Line Replacement Serial Data | The Supplier Contract Line referenced is for a Contract that is Closed or Pending Close. | The Purchase
 * Order Line referenced is from a PO that is Closed or Pending Close. | Quantity must be greater than zero and cannot be partial when the document line's spend category is Tracked (unless related to a supplier contract line). | The Purchase Order Line
 * must be for the same Supplier as the Receipt. | Purchase Order Line must be for a Goods item. The line specified is for another type of line. | Quantity must be greater than zero. | Purchase Order Line must be from an issued Order. | Item Receipt
 * Line Data
 * @subpackage Structs
 */
class Item_Receipt_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line associated with the Receipt Line. It must be for a goods item, or else an invalid instance error will occur.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Supplier_Contract_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Line associated with the Receipt Line. It must be for a goods item, or else an invalid instance error will occur.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Item_LineObjectType
     */
    public $Supplier_Contract_Line_Reference;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company from the purchase order line or receipt header.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item linked to the Catalog Item on the Receipt Line.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a valid Unit of Measure for the purchase item. This unit of measure is not defined for the supplier. | Only the unit of measure of the corresponding supplier contract line is valid. | Only the unit of measure of the purchase
     * order line is valid. | The Unit of Measure is invalid for the catalog item. Only defined ordering units of measure for the catalog item can be used. | Unit of measure for this receipt line
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Delivery_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Delivery Type for the Inventory Supplier Contract Line Items
     * - minOccurs: 0
     * @var \StructType\Delivery_TypeObjectType
     */
    public $Delivery_Type_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. Workday derives the Address Reference from the related Purchase Order Line or Supplier Contract Line when creating a Receipt and does not expect this to be included in the Submit Web
     * Service request.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact. Workday derives the Ship-To Contact from the related Purchase Order Line or Supplier Contract Line when creating a Receipt and does not expect this to be included in
     * the Submit Web Service request.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered. Workday derives the Deliver-To Location from the related Purchase Order Line when creating a Receipt and does not expect this to be included in the
     * Submit Web Service request.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Reference;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comment for Receipt Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Receipt Adjustment adjust current Receipt Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_AdjustmentObjectType[]
     */
    public $Receipt_Adjustment_Reference;
    /**
     * The Goods_Delivery_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Goods Delivery Ticket for Receipt Line
     * - minOccurs: 0
     * @var \StructType\Goods_Delivery_LineObjectType
     */
    public $Goods_Delivery_Line_Reference;
    /**
     * The Item_Receipt_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Receipt_Line_Split_DataType[]
     */
    public $Item_Receipt_Line_Split_Data;
    /**
     * The Item_Receipt_Line_Replacement_Lot_Data
     * Meta information extracted from the WSDL
     * - documentation: Receipt Line Item Lot Quantity Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Receipt_Line_Replacement_Lot_DataType[]
     */
    public $Item_Receipt_Line_Replacement_Lot_Data;
    /**
     * Constructor method for Item_Receipt_Line_Replacement_DataType
     * @uses Item_Receipt_Line_Replacement_DataType::setPurchase_Order_Line_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setSupplier_Contract_Line_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setLine_Company_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setPackaging_String()
     * @uses Item_Receipt_Line_Replacement_DataType::setPurchase_Item_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setQuantity()
     * @uses Item_Receipt_Line_Replacement_DataType::setUnit_of_Measure_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setDelivery_Type_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setDeliver_To_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setCommodity_Code_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setMemo()
     * @uses Item_Receipt_Line_Replacement_DataType::setReceipt_Adjustment_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setGoods_Delivery_Line_Reference()
     * @uses Item_Receipt_Line_Replacement_DataType::setItem_Receipt_Line_Split_Data()
     * @uses Item_Receipt_Line_Replacement_DataType::setItem_Receipt_Line_Replacement_Lot_Data()
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param string $packaging_String
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Reference
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param string $memo
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @param \StructType\Goods_Delivery_LineObjectType $goods_Delivery_Line_Reference
     * @param \StructType\Item_Receipt_Line_Split_DataType[] $item_Receipt_Line_Split_Data
     * @param \StructType\Item_Receipt_Line_Replacement_Lot_DataType[] $item_Receipt_Line_Replacement_Lot_Data
     */
    public function __construct(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference = null, \StructType\CompanyObjectType $line_Company_Reference = null, $packaging_String = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, \StructType\Delivery_TypeObjectType $delivery_Type_Reference = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Reference = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, $memo = null, array $receipt_Adjustment_Reference = array(), \StructType\Goods_Delivery_LineObjectType $goods_Delivery_Line_Reference = null, array $item_Receipt_Line_Split_Data = array(), array $item_Receipt_Line_Replacement_Lot_Data = array())
    {
        $this
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setSupplier_Contract_Line_Reference($supplier_Contract_Line_Reference)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setPackaging_String($packaging_String)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setDelivery_Type_Reference($delivery_Type_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Reference($deliver_To_Reference)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setMemo($memo)
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference)
            ->setGoods_Delivery_Line_Reference($goods_Delivery_Line_Reference)
            ->setItem_Receipt_Line_Split_Data($item_Receipt_Line_Split_Data)
            ->setItem_Receipt_Line_Replacement_Lot_Data($item_Receipt_Line_Replacement_Lot_Data);
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Reference value
     * @return \StructType\Supplier_Contract_Item_LineObjectType|null
     */
    public function getSupplier_Contract_Line_Reference()
    {
        return $this->Supplier_Contract_Line_Reference;
    }
    /**
     * Set Supplier_Contract_Line_Reference value
     * @param \StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Reference(\StructType\Supplier_Contract_Item_LineObjectType $supplier_Contract_Line_Reference = null)
    {
        $this->Supplier_Contract_Line_Reference = $supplier_Contract_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Delivery_Type_Reference value
     * @return \StructType\Delivery_TypeObjectType|null
     */
    public function getDelivery_Type_Reference()
    {
        return $this->Delivery_Type_Reference;
    }
    /**
     * Set Delivery_Type_Reference value
     * @param \StructType\Delivery_TypeObjectType $delivery_Type_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setDelivery_Type_Reference(\StructType\Delivery_TypeObjectType $delivery_Type_Reference = null)
    {
        $this->Delivery_Type_Reference = $delivery_Type_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Reference()
    {
        return $this->Deliver_To_Reference;
    }
    /**
     * Set Deliver_To_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setDeliver_To_Reference(\StructType\LocationObjectType $deliver_To_Reference = null)
    {
        $this->Deliver_To_Reference = $deliver_To_Reference;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType[]|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Adjustment_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Adjustment_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem instanceof \StructType\Receipt_AdjustmentObjectType) {
                $invalidValues[] = is_object($item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) ? get_class($item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem) : sprintf('%s(%s)', gettype($item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem), var_export($item_Receipt_Line_Replacement_DataTypeReceipt_Adjustment_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType[] $receipt_Adjustment_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setReceipt_Adjustment_Reference(array $receipt_Adjustment_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_Adjustment_ReferenceArrayErrorMessage = self::validateReceipt_Adjustment_ReferenceForArrayConstraintsFromSetReceipt_Adjustment_Reference($receipt_Adjustment_Reference))) {
            throw new \InvalidArgumentException($receipt_Adjustment_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Add item to Receipt_Adjustment_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_AdjustmentObjectType $item
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function addToReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_AdjustmentObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Adjustment_Reference property can only contain items of type \StructType\Receipt_AdjustmentObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Adjustment_Reference[] = $item;
        return $this;
    }
    /**
     * Get Goods_Delivery_Line_Reference value
     * @return \StructType\Goods_Delivery_LineObjectType|null
     */
    public function getGoods_Delivery_Line_Reference()
    {
        return $this->Goods_Delivery_Line_Reference;
    }
    /**
     * Set Goods_Delivery_Line_Reference value
     * @param \StructType\Goods_Delivery_LineObjectType $goods_Delivery_Line_Reference
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setGoods_Delivery_Line_Reference(\StructType\Goods_Delivery_LineObjectType $goods_Delivery_Line_Reference = null)
    {
        $this->Goods_Delivery_Line_Reference = $goods_Delivery_Line_Reference;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Split_Data value
     * @return \StructType\Item_Receipt_Line_Split_DataType[]|null
     */
    public function getItem_Receipt_Line_Split_Data()
    {
        return $this->Item_Receipt_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_Split_DataForArrayConstraintsFromSetItem_Receipt_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem instanceof \StructType\Item_Receipt_Line_Split_DataType) {
                $invalidValues[] = is_object($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem) ? get_class($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem) : sprintf('%s(%s)', gettype($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem), var_export($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Split_Data property can only contain items of type \StructType\Item_Receipt_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Split_DataType[] $item_Receipt_Line_Split_Data
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setItem_Receipt_Line_Split_Data(array $item_Receipt_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_Split_DataArrayErrorMessage = self::validateItem_Receipt_Line_Split_DataForArrayConstraintsFromSetItem_Receipt_Line_Split_Data($item_Receipt_Line_Split_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Split_Data = $item_Receipt_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Split_DataType $item
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function addToItem_Receipt_Line_Split_Data(\StructType\Item_Receipt_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Receipt_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Split_Data property can only contain items of type \StructType\Item_Receipt_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Split_Data[] = $item;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Replacement_Lot_Data value
     * @return \StructType\Item_Receipt_Line_Replacement_Lot_DataType[]|null
     */
    public function getItem_Receipt_Line_Replacement_Lot_Data()
    {
        return $this->Item_Receipt_Line_Replacement_Lot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Replacement_Lot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Replacement_Lot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_Replacement_Lot_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Lot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem) {
            // validation for constraint: itemType
            if (!$item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem instanceof \StructType\Item_Receipt_Line_Replacement_Lot_DataType) {
                $invalidValues[] = is_object($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem) ? get_class($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem) : sprintf('%s(%s)', gettype($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem), var_export($item_Receipt_Line_Replacement_DataTypeItem_Receipt_Line_Replacement_Lot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Replacement_Lot_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_Lot_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Replacement_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_Lot_DataType[] $item_Receipt_Line_Replacement_Lot_Data
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function setItem_Receipt_Line_Replacement_Lot_Data(array $item_Receipt_Line_Replacement_Lot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_Replacement_Lot_DataArrayErrorMessage = self::validateItem_Receipt_Line_Replacement_Lot_DataForArrayConstraintsFromSetItem_Receipt_Line_Replacement_Lot_Data($item_Receipt_Line_Replacement_Lot_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_Replacement_Lot_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Lot_Data = $item_Receipt_Line_Replacement_Lot_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Replacement_Lot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Receipt_Line_Replacement_Lot_DataType $item
     * @return \StructType\Item_Receipt_Line_Replacement_DataType
     */
    public function addToItem_Receipt_Line_Replacement_Lot_Data(\StructType\Item_Receipt_Line_Replacement_Lot_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Receipt_Line_Replacement_Lot_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Replacement_Lot_Data property can only contain items of type \StructType\Item_Receipt_Line_Replacement_Lot_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Replacement_Lot_Data[] = $item;
        return $this;
    }
}
