<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate_Credit_Card_Account_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Corporate Credit Card Account Instance and Data
 * @subpackage Structs
 */
class Corporate_Credit_Card_Account_Response_DataType extends AbstractStructBase
{
    /**
     * The Corporate_Credit_Card_Account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountType[]
     */
    public $Corporate_Credit_Card_Account;
    /**
     * Constructor method for Corporate_Credit_Card_Account_Response_DataType
     * @uses Corporate_Credit_Card_Account_Response_DataType::setCorporate_Credit_Card_Account()
     * @param \StructType\Corporate_Credit_Card_AccountType[] $corporate_Credit_Card_Account
     */
    public function __construct(array $corporate_Credit_Card_Account = array())
    {
        $this
            ->setCorporate_Credit_Card_Account($corporate_Credit_Card_Account);
    }
    /**
     * Get Corporate_Credit_Card_Account value
     * @return \StructType\Corporate_Credit_Card_AccountType[]|null
     */
    public function getCorporate_Credit_Card_Account()
    {
        return $this->Corporate_Credit_Card_Account;
    }
    /**
     * This method is responsible for validating the values passed to the setCorporate_Credit_Card_Account method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCorporate_Credit_Card_Account method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCorporate_Credit_Card_AccountForArrayConstraintsFromSetCorporate_Credit_Card_Account(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem) {
            // validation for constraint: itemType
            if (!$corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem instanceof \StructType\Corporate_Credit_Card_AccountType) {
                $invalidValues[] = is_object($corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem) ? get_class($corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem) : sprintf('%s(%s)', gettype($corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem), var_export($corporate_Credit_Card_Account_Response_DataTypeCorporate_Credit_Card_AccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Corporate_Credit_Card_Account property can only contain items of type \StructType\Corporate_Credit_Card_AccountType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Corporate_Credit_Card_Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountType[] $corporate_Credit_Card_Account
     * @return \StructType\Corporate_Credit_Card_Account_Response_DataType
     */
    public function setCorporate_Credit_Card_Account(array $corporate_Credit_Card_Account = array())
    {
        // validation for constraint: array
        if ('' !== ($corporate_Credit_Card_AccountArrayErrorMessage = self::validateCorporate_Credit_Card_AccountForArrayConstraintsFromSetCorporate_Credit_Card_Account($corporate_Credit_Card_Account))) {
            throw new \InvalidArgumentException($corporate_Credit_Card_AccountArrayErrorMessage, __LINE__);
        }
        $this->Corporate_Credit_Card_Account = $corporate_Credit_Card_Account;
        return $this;
    }
    /**
     * Add item to Corporate_Credit_Card_Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountType $item
     * @return \StructType\Corporate_Credit_Card_Account_Response_DataType
     */
    public function addToCorporate_Credit_Card_Account(\StructType\Corporate_Credit_Card_AccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Corporate_Credit_Card_AccountType) {
            throw new \InvalidArgumentException(sprintf('The Corporate_Credit_Card_Account property can only contain items of type \StructType\Corporate_Credit_Card_AccountType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Corporate_Credit_Card_Account[] = $item;
        return $this;
    }
}
