<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Response Group is a wrapper element around a list of elements representing the amount of data that should be included in the response.
 * @subpackage Structs
 */
class Asset_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: If true, a reference to the primary business object will be returned in the Get Response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Custodian_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Custodian Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Custodian_Data;
    /**
     * The Include_Depreciation_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Depreciation Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Depreciation_Data;
    /**
     * The Include_Depreciation_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Depreciation Detail Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Depreciation_Detail_Data;
    /**
     * The Include_Disposal_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Disposal Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Disposal_Data;
    /**
     * The Include_Intercompany_Transfer_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Intercompany Transfer Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Intercompany_Transfer_Data;
    /**
     * The Include_Impairment_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Impairment Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Impairment_Data;
    /**
     * The Include_Reinstatement_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Reinstatement Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reinstatement_Data;
    /**
     * The Include_In_Service_Schedule_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the In Service Schedule Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_In_Service_Schedule_Data;
    /**
     * The Include_Cost_Adjustment_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Cost Adjustment Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Cost_Adjustment_Data;
    /**
     * The Include_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Attachment Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Attachment_Data;
    /**
     * The Include_Reclassification_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Reclassification Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reclassification_Data;
    /**
     * The Include_Removal_Data
     * Meta information extracted from the WSDL
     * - documentation: If true, includes the Removal Data element in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Removal_Data;
    /**
     * Constructor method for Asset_Response_GroupType
     * @uses Asset_Response_GroupType::setInclude_Reference()
     * @uses Asset_Response_GroupType::setInclude_Custodian_Data()
     * @uses Asset_Response_GroupType::setInclude_Depreciation_Data()
     * @uses Asset_Response_GroupType::setInclude_Depreciation_Detail_Data()
     * @uses Asset_Response_GroupType::setInclude_Disposal_Data()
     * @uses Asset_Response_GroupType::setInclude_Intercompany_Transfer_Data()
     * @uses Asset_Response_GroupType::setInclude_Impairment_Data()
     * @uses Asset_Response_GroupType::setInclude_Reinstatement_Data()
     * @uses Asset_Response_GroupType::setInclude_In_Service_Schedule_Data()
     * @uses Asset_Response_GroupType::setInclude_Cost_Adjustment_Data()
     * @uses Asset_Response_GroupType::setInclude_Attachment_Data()
     * @uses Asset_Response_GroupType::setInclude_Reclassification_Data()
     * @uses Asset_Response_GroupType::setInclude_Removal_Data()
     * @param bool $include_Reference
     * @param bool $include_Custodian_Data
     * @param bool $include_Depreciation_Data
     * @param bool $include_Depreciation_Detail_Data
     * @param bool $include_Disposal_Data
     * @param bool $include_Intercompany_Transfer_Data
     * @param bool $include_Impairment_Data
     * @param bool $include_Reinstatement_Data
     * @param bool $include_In_Service_Schedule_Data
     * @param bool $include_Cost_Adjustment_Data
     * @param bool $include_Attachment_Data
     * @param bool $include_Reclassification_Data
     * @param bool $include_Removal_Data
     */
    public function __construct($include_Reference = null, $include_Custodian_Data = null, $include_Depreciation_Data = null, $include_Depreciation_Detail_Data = null, $include_Disposal_Data = null, $include_Intercompany_Transfer_Data = null, $include_Impairment_Data = null, $include_Reinstatement_Data = null, $include_In_Service_Schedule_Data = null, $include_Cost_Adjustment_Data = null, $include_Attachment_Data = null, $include_Reclassification_Data = null, $include_Removal_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Custodian_Data($include_Custodian_Data)
            ->setInclude_Depreciation_Data($include_Depreciation_Data)
            ->setInclude_Depreciation_Detail_Data($include_Depreciation_Detail_Data)
            ->setInclude_Disposal_Data($include_Disposal_Data)
            ->setInclude_Intercompany_Transfer_Data($include_Intercompany_Transfer_Data)
            ->setInclude_Impairment_Data($include_Impairment_Data)
            ->setInclude_Reinstatement_Data($include_Reinstatement_Data)
            ->setInclude_In_Service_Schedule_Data($include_In_Service_Schedule_Data)
            ->setInclude_Cost_Adjustment_Data($include_Cost_Adjustment_Data)
            ->setInclude_Attachment_Data($include_Attachment_Data)
            ->setInclude_Reclassification_Data($include_Reclassification_Data)
            ->setInclude_Removal_Data($include_Removal_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Custodian_Data value
     * @return bool|null
     */
    public function getInclude_Custodian_Data()
    {
        return $this->Include_Custodian_Data;
    }
    /**
     * Set Include_Custodian_Data value
     * @param bool $include_Custodian_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Custodian_Data($include_Custodian_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Custodian_Data) && !is_bool($include_Custodian_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Custodian_Data, true), gettype($include_Custodian_Data)), __LINE__);
        }
        $this->Include_Custodian_Data = $include_Custodian_Data;
        return $this;
    }
    /**
     * Get Include_Depreciation_Data value
     * @return bool|null
     */
    public function getInclude_Depreciation_Data()
    {
        return $this->Include_Depreciation_Data;
    }
    /**
     * Set Include_Depreciation_Data value
     * @param bool $include_Depreciation_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Depreciation_Data($include_Depreciation_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Depreciation_Data) && !is_bool($include_Depreciation_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Depreciation_Data, true), gettype($include_Depreciation_Data)), __LINE__);
        }
        $this->Include_Depreciation_Data = $include_Depreciation_Data;
        return $this;
    }
    /**
     * Get Include_Depreciation_Detail_Data value
     * @return bool|null
     */
    public function getInclude_Depreciation_Detail_Data()
    {
        return $this->Include_Depreciation_Detail_Data;
    }
    /**
     * Set Include_Depreciation_Detail_Data value
     * @param bool $include_Depreciation_Detail_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Depreciation_Detail_Data($include_Depreciation_Detail_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Depreciation_Detail_Data) && !is_bool($include_Depreciation_Detail_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Depreciation_Detail_Data, true), gettype($include_Depreciation_Detail_Data)), __LINE__);
        }
        $this->Include_Depreciation_Detail_Data = $include_Depreciation_Detail_Data;
        return $this;
    }
    /**
     * Get Include_Disposal_Data value
     * @return bool|null
     */
    public function getInclude_Disposal_Data()
    {
        return $this->Include_Disposal_Data;
    }
    /**
     * Set Include_Disposal_Data value
     * @param bool $include_Disposal_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Disposal_Data($include_Disposal_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Disposal_Data) && !is_bool($include_Disposal_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Disposal_Data, true), gettype($include_Disposal_Data)), __LINE__);
        }
        $this->Include_Disposal_Data = $include_Disposal_Data;
        return $this;
    }
    /**
     * Get Include_Intercompany_Transfer_Data value
     * @return bool|null
     */
    public function getInclude_Intercompany_Transfer_Data()
    {
        return $this->Include_Intercompany_Transfer_Data;
    }
    /**
     * Set Include_Intercompany_Transfer_Data value
     * @param bool $include_Intercompany_Transfer_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Intercompany_Transfer_Data($include_Intercompany_Transfer_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Intercompany_Transfer_Data) && !is_bool($include_Intercompany_Transfer_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Intercompany_Transfer_Data, true), gettype($include_Intercompany_Transfer_Data)), __LINE__);
        }
        $this->Include_Intercompany_Transfer_Data = $include_Intercompany_Transfer_Data;
        return $this;
    }
    /**
     * Get Include_Impairment_Data value
     * @return bool|null
     */
    public function getInclude_Impairment_Data()
    {
        return $this->Include_Impairment_Data;
    }
    /**
     * Set Include_Impairment_Data value
     * @param bool $include_Impairment_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Impairment_Data($include_Impairment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Impairment_Data) && !is_bool($include_Impairment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Impairment_Data, true), gettype($include_Impairment_Data)), __LINE__);
        }
        $this->Include_Impairment_Data = $include_Impairment_Data;
        return $this;
    }
    /**
     * Get Include_Reinstatement_Data value
     * @return bool|null
     */
    public function getInclude_Reinstatement_Data()
    {
        return $this->Include_Reinstatement_Data;
    }
    /**
     * Set Include_Reinstatement_Data value
     * @param bool $include_Reinstatement_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Reinstatement_Data($include_Reinstatement_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reinstatement_Data) && !is_bool($include_Reinstatement_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reinstatement_Data, true), gettype($include_Reinstatement_Data)), __LINE__);
        }
        $this->Include_Reinstatement_Data = $include_Reinstatement_Data;
        return $this;
    }
    /**
     * Get Include_In_Service_Schedule_Data value
     * @return bool|null
     */
    public function getInclude_In_Service_Schedule_Data()
    {
        return $this->Include_In_Service_Schedule_Data;
    }
    /**
     * Set Include_In_Service_Schedule_Data value
     * @param bool $include_In_Service_Schedule_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_In_Service_Schedule_Data($include_In_Service_Schedule_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_In_Service_Schedule_Data) && !is_bool($include_In_Service_Schedule_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_In_Service_Schedule_Data, true), gettype($include_In_Service_Schedule_Data)), __LINE__);
        }
        $this->Include_In_Service_Schedule_Data = $include_In_Service_Schedule_Data;
        return $this;
    }
    /**
     * Get Include_Cost_Adjustment_Data value
     * @return bool|null
     */
    public function getInclude_Cost_Adjustment_Data()
    {
        return $this->Include_Cost_Adjustment_Data;
    }
    /**
     * Set Include_Cost_Adjustment_Data value
     * @param bool $include_Cost_Adjustment_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Cost_Adjustment_Data($include_Cost_Adjustment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Cost_Adjustment_Data) && !is_bool($include_Cost_Adjustment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Cost_Adjustment_Data, true), gettype($include_Cost_Adjustment_Data)), __LINE__);
        }
        $this->Include_Cost_Adjustment_Data = $include_Cost_Adjustment_Data;
        return $this;
    }
    /**
     * Get Include_Attachment_Data value
     * @return bool|null
     */
    public function getInclude_Attachment_Data()
    {
        return $this->Include_Attachment_Data;
    }
    /**
     * Set Include_Attachment_Data value
     * @param bool $include_Attachment_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Attachment_Data($include_Attachment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Attachment_Data) && !is_bool($include_Attachment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Attachment_Data, true), gettype($include_Attachment_Data)), __LINE__);
        }
        $this->Include_Attachment_Data = $include_Attachment_Data;
        return $this;
    }
    /**
     * Get Include_Reclassification_Data value
     * @return bool|null
     */
    public function getInclude_Reclassification_Data()
    {
        return $this->Include_Reclassification_Data;
    }
    /**
     * Set Include_Reclassification_Data value
     * @param bool $include_Reclassification_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Reclassification_Data($include_Reclassification_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reclassification_Data) && !is_bool($include_Reclassification_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reclassification_Data, true), gettype($include_Reclassification_Data)), __LINE__);
        }
        $this->Include_Reclassification_Data = $include_Reclassification_Data;
        return $this;
    }
    /**
     * Get Include_Removal_Data value
     * @return bool|null
     */
    public function getInclude_Removal_Data()
    {
        return $this->Include_Removal_Data;
    }
    /**
     * Set Include_Removal_Data value
     * @param bool $include_Removal_Data
     * @return \StructType\Asset_Response_GroupType
     */
    public function setInclude_Removal_Data($include_Removal_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Removal_Data) && !is_bool($include_Removal_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Removal_Data, true), gettype($include_Removal_Data)), __LINE__);
        }
        $this->Include_Removal_Data = $include_Removal_Data;
        return $this;
    }
}
