<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Get_Resource_Categories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Spend Categories for the specified criteria. Spend Categories are a classification for items and services that drives the accounting in Workday. Whenever an accounting entry is made, Workday looks
     * first at the spend category. All items—expense items, purchase items—and services are associated with a Spend Category. Sales items are associated with its analog: Revenue Category. Spend Category data for this service includes Spend Category ID,
     * Spend Category Name, Procurement Usage flag, Expense Usage flag, Track Items flag, Accounting Treatment, Depreciation Profile, and UNSPSC Code Range. The request criteria can be for a single transaction based on Reference, or all transaction can be
     * retrieved if no criteria is specified.Spend Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Categories_RequestType $body
     * @return \StructType\Get_Resource_Categories_ResponseType|bool
     */
    public function Get_Resource_Categories(\StructType\Get_Resource_Categories_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Categories($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Item_Groups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Purchase Item Groups for the specified criteria. Purchase Items groups can be used to make it easier to search for and select items. Purchase items can belong to multiple groups. Purchase Item Group
     * data includes Purchase Item Group ID and Name. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Item_Groups_RequestType $body
     * @return \StructType\Get_Purchase_Item_Groups_ResponseType|bool
     */
    public function Get_Purchase_Item_Groups(\StructType\Get_Purchase_Item_Groups_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Item_Groups($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Items
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Expense Items for the specified criteria. Expense Item are used to create and track goods and services which can be expensed to a company by Employees. Expense item data includes Expense Item ID, Item
     * Name, Spend Category, Item Description, Item Unit Price, Currency, Instructions for the User, Fixed Expense flag, Maximum Expense flag, and Memo Require Flag. The request criteria can be for a single transaction based on Reference, or all transaction
     * can be retrieved if no criteria is specified.Spend Category and Resource Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Items_RequestType $body
     * @return \StructType\Get_Expense_Items_ResponseType|bool
     */
    public function Get_Expense_Items(\StructType\Get_Expense_Items_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Items($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Items
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Purchase Items for the specified criteria. Purchase items are goods and services that are purchased from suppliers. Purchase Item data includes Purchase Item ID, Name, Spend Category, Item Description,
     * Item Identifier, Unit of Measure, Item Unit Price, Currency and Purchase Item Group. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.Spend Category and Resource
     * Category are synonymous and refer to the same business object.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Items_RequestType $body
     * @return \StructType\Get_Purchase_Items_ResponseType|bool
     */
    public function Get_Purchase_Items(\StructType\Get_Purchase_Items_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Items($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Suppliers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Suppliers for the specified criteria. Supplier data includes Supplier ID, Supplier Reference ID, Supplier Name, Worktag Only, Approval Status, Tax Authority Form Type, IRS 1099 Supplier Flag, Report
     * 1099 with Parent Flag, TIN Type Reference, Supplier Category, Supplier Group, Tax Document Date, Default Tax Code Reference, Certificate of Insurance Date, Customer Account Number, DUNS Number, Disable Change Order Flag, Purchase Order Issue Option,
     * Payment Terms, Payment Types accepted, Default Payment Type, Procurement Credit Card, Included Children, Proposed Children Reference, Business Entity data, Settlement Account data, Do Not Pay if Settlement Bank Account Change In Progress flag,
     * Supplier Status, Proposed Supplier Status, Separate Payments flag, Memo, Business Entity Alternate Name data, Business Entity Attachment data and Areas Change Flags. Business Entity data includes Name, Tax ID, External ID, Contact Information data,
     * and Business Entity Logo. Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is
     * specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Suppliers_RequestType $body
     * @return \StructType\Get_Suppliers_ResponseType|bool
     */
    public function Get_Suppliers(\StructType\Get_Suppliers_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Suppliers($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Item_Groups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Expense Item Groups for the specified criteria. Expense Item Group data includes Expense Item Group ID and Name. Expense Item Group can be used to make it easier to search for and select items. Expense
     * items can belong to multiple groups. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Item_Groups_RequestType $body
     * @return \StructType\Get_Expense_Item_Groups_ResponseType|bool
     */
    public function Get_Expense_Item_Groups(\StructType\Get_Expense_Item_Groups_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Item_Groups($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_PO_for_PO_Issue_Outbound
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: DEPRECATED: This operation has been deprecated. The "Get Purchase Orders" operation should be used to retrieve Purchase Order information.This service operation will get Purchase Orders for the specified criteria. Purchase Orders can
     * be issued to Suppliers using this service operation. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.cXML Notes:This is the Web Service task used to send the
     * cXML Order Message (Issue PO) to the punchout Supplier1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_PO_Outbound_RequestType $body
     * @return \StructType\Issue_Purchase_Order_OutboundType|bool
     */
    public function Get_PO_for_PO_Issue_Outbound(\StructType\Get_PO_Outbound_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_PO_for_PO_Issue_Outbound($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Categories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Categories for the specified criteria. Supplier Category data includes the Supplier Category ID and the Supplier Category Name. Supplier Categories are used to maintain suppliers and apply
     * accounting rules to procurement transactions. You can also use Supplier categories when selecting or searching for Suppliers. All Suppliers must have one and only one category. The request criteria can be for a single transaction based on Reference,
     * or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Categories_RequestType $body
     * @return \StructType\Get_Supplier_Categories_ResponseType|bool
     */
    public function Get_Supplier_Categories(\StructType\Get_Supplier_Categories_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Categories($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Groups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Groups for the specified criteria. Supplier Groups are used for reporting and selection. Supplier groups can include individual suppliers. Supplier Group data includes Supplier Group ID and
     * Name. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Groups_RequestType $body
     * @return \StructType\Get_Supplier_Groups_ResponseType|bool
     */
    public function Get_Supplier_Groups(\StructType\Get_Supplier_Groups_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Groups($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Timesheets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Worker Timesheets for the specified criteria. Timesheets include data such as Supervisory Organization, Worker, Start and End Date for the time reporting period. They also include hours per day, time
     * code, billable flag and memo information. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if Supervisory Organization is specified. There are also other criteria that will return different
     * types of timesheets.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Timesheets_RequestType $body
     * @return \StructType\Get_Timesheets_ResponseType|bool
     */
    public function Get_Timesheets(\StructType\Get_Timesheets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Timesheets($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Corporate_Credit_Card_Billing_Accounts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Corporate Credit Card Accounts for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Corporate_Credit_Card_Billing_Accounts_RequestType $body
     * @return \StructType\Get_Corporate_Credit_Card_Billing_Accounts_ResponseType|bool
     */
    public function Get_Corporate_Credit_Card_Billing_Accounts(\StructType\Get_Corporate_Credit_Card_Billing_Accounts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Corporate_Credit_Card_Billing_Accounts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Credit_Cards
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Expense Credit Cards for the specified criteria. The response will include specific information about the Expense Credit Cards such as the Cardholder Reference, Corporate Credit Card Account, Credit Card
     * Description, Credit Card Expiration Date, etc...No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Credit_Cards_RequestType $body
     * @return \StructType\Get_Expense_Credit_Cards_ResponseType|bool
     */
    public function Get_Expense_Credit_Cards(\StructType\Get_Expense_Credit_Cards_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Credit_Cards($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Business_Entity_Contacts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Get Business Entity Contacts for the specified criteria. The data includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier, Customer, Financial Institution or Tax
     * Authority), the Personal Data including Name Detail data and Contact Information data. Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix. Contact Information data
     * includes Address, Phone, Email, Instance Messenger and Web Address data. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Business_Entity_Contacts_RequestType $body
     * @return \StructType\Get_Business_Entity_Contacts_ResponseType|bool
     */
    public function Get_Business_Entity_Contacts(\StructType\Get_Business_Entity_Contacts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Business_Entity_Contacts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Invoices for the specified criteria. Supplier Invoice data includes Supplier Invoice ID, Submit Flag, Locked in Workday Flag, Document Number, Company, Currency, Supplier, Contingent Worker,
     * Document Date, Due Date Override, Control Total Amount, Payment Terms, Hold from Payment Flag, Document Received, Reference, PO Number, Contract, Memo, Attachment and Supplier Invoice Line data. Line data includes Intercompany Affiliate, Purchase
     * Item, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo and Worktags. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoices_RequestType $body
     * @return \StructType\Get_Supplier_Invoices_ResponseType|bool
     */
    public function Get_Supplier_Invoices(\StructType\Get_Supplier_Invoices_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoices($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoice_Adjustments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Invoice Adjustments for the specified criteria. Supplier Invoice Adjustment data includes Supplier Invoice Adjustment ID, Submit Flag, Locked in Workday Flag, Document Number, Company,
     * Currency, Supplier, Contingent Worker, Increase Liability Flag, Adjustment Reason, Adjustment Date, Due Date Override, Control Total Amount, Original Invoice, Payment Terms, Hold from Payment Flag, Document Received, Reference, PO Number, Contract,
     * Memo, Attachment and Supplier Invoice Line data. Line data includes Intercompany Affiliate, Purchase Item, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo and Worktags. The request criteria can be for a single transaction based on
     * Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Adjustments_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Adjustments_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Adjustments(\StructType\Get_Supplier_Invoice_Adjustments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Adjustments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Catalog_Loads
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Catalog Loads for the specified criteria. Catalog Load Data includes Event Effective Date, Supplier Catalog Load, Supplier Contract, Lead Time, Catalog Load Item Data and Memo. Catalog Load Item Data
     * includes Catalog Item Reference ID, Item Identifier, Item Name, Item Description, Unit Price, URL, Unit of Measure, Lead Time, Spend Category, UNSPSC Code, Purchase Item linked and Conversion Factor. The request criteria can be for a single Catalog
     * Load based on Reference or all Catalog Loads if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Catalog_Loads_RequestType $body
     * @return \StructType\Get_Catalog_Loads_ResponseType|bool
     */
    public function Get_Catalog_Loads(\StructType\Get_Catalog_Loads_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Catalog_Loads($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoice_Histories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve instances of Supplier Invoice Histories. This contains data for Reference ID, Company, Currency, Supplier, Total Invoice Amount, document Reference Number, Invoice Date, External PO Number,
     * Document Number, and Source Integration System name. On the web service request, you can specify a specific reference to a Supplier Invoice History to return, or find them by supplying search criteria of Company, Supplier, Supplier Reference Number,
     * Invoice Date, Invoice Amount, Currency, External PO Number, Invoice Number, or Source Integration System.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Histories_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Histories_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Histories(\StructType\Get_Supplier_Invoice_Histories_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Histories($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Worker_Roles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Project Worker Roles for the specified criteria. Project Worker Role data includes Project Worker Role ID, Project Worker Role Name, Project Worker Role Description, Default Hourly Billable Rate,
     * Default Hourly Internal Rate, and Currency. The request criteria can be for a single Project Worker Role based on Reference, or all transactions can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Worker_Roles_RequestType $body
     * @return \StructType\Get_Project_Worker_Roles_ResponseType|bool
     */
    public function Get_Project_Worker_Roles(\StructType\Get_Project_Worker_Roles_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Worker_Roles($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Plan_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Project Plan Templates for the specified criteria. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Plan_Templates_RequestType $body
     * @return \StructType\Get_Project_Plan_Templates_ResponseType|bool
     */
    public function Get_Project_Plan_Templates(\StructType\Get_Project_Plan_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Plan_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Project Templates for the specified criteria. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Templates_RequestType $body
     * @return \StructType\Get_Project_Templates_ResponseType|bool
     */
    public function Get_Project_Templates(\StructType\Get_Project_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Tasks
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the GET Project Tasks web serviceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Tasks_RequestType $body
     * @return \StructType\Get_Project_Tasks_ResponseType|bool
     */
    public function Get_Project_Tasks(\StructType\Get_Project_Tasks_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Tasks($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Phases
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Project Phases based on a specific reference or Project Phase Name criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Phases_RequestType $body
     * @return \StructType\Get_Project_Phases_ResponseType|bool
     */
    public function Get_Project_Phases(\StructType\Get_Project_Phases_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Phases($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Reports
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Expense Reports for the specified criteria. Expense Reports are used to track expenses incurred by workers or applicants so they can be reimbursed. Expense Report data includes Date, Business Purpose,
     * Spend Authorization, Total Amount, Payment Type, Memo, and Expense Report Lines. The data for the lines includes Date, Quantity, Amount, Expense Item, Conversion Rate, Converted Amount, Expense Item Attributes, Credit Card, Credit Card Transaction,
     * Memo, Flags for Billable and Receipt Included, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Reports_RequestType $body
     * @return \StructType\Get_Expense_Reports_ResponseType|bool
     */
    public function Get_Expense_Reports(\StructType\Get_Expense_Reports_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Reports($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Order_Contracts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: DEPRECATED: This operation is being deprecated in favor of the Get Supplier Contracts web service in W16.This service operation will get Supplier Order Contracts for the specified criteria. Supplier Order Contract data includes
     * Supplier Contract ID, Supplier Contract Name, Resource Provider, Supplier Contract Reference Number, Company, Contract Start Date, Contract End Date, Total Contract Amount, Contract Overview, Locked in Workday Flag and Attachment data. The request
     * criteria can be for a specific supplier order contract based on reference(s), Company or Company Hierarchies (returning contracts belonging to subordinate hierarchies and companies), Supplier(s), Start Date, End Date, Supplier Contract Number,
     * Contract Name, Status, and Creating Worker.If no criteria are specified, all supplier order contracts will be retrieved.1No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Order_Contracts_RequestType $body
     * @return \StructType\Get_Supplier_Order_Contracts_ResponseType|bool
     */
    public function Get_Supplier_Order_Contracts(\StructType\Get_Supplier_Order_Contracts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Order_Contracts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Orders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Purchase Orders for the specified criteria. Purchase Order Data include Purchase Order Reference, Document Number, Invoice Status, Receiving Status, Payment Status, Shipping Status, Tracking Status,
     * Company, Supplier, Purchase Order Date, Payment Terms, Due Date, Supplier Contract, Currency, Default Tax Code, Bill-To Contact, Bill-To Address, Ship-To Contact, Ship-To Address, Description, Goods Line Data, Deliverables Line Data, Contingent
     * Worker Line Data, Tax Code Data, and Attachment Data. Goods Line Data include Item, Line Number, Item Description, Resource Category, Tax Applicability, Tax Code, Quantity, Unit of Measure, Unit Cost, Extended Amount, Memo, and Worktags. Deliverables
     * Line Data include Line Number, Project, Memo, Resource Category, Project Phase Data, Extended Amount, and Worktags. Project Phase Data includes Project Plan Phase and Project Plan Task Data. Project Plan Task Data include Project Plan Task and
     * Project Subtask Data. Project Subtask Data include Description and Amount. Contingent Worker Line Data include Line Number, Contingent Worker, Position, Business Site, Position Time Type, Start Date, End Date, Scheduled Hours, Contract Pay Rate, Time
     * Code Data, Extended Amount, Resource Category, Tax Applicability, Tax Code, Worktags, and Memo. Time Code Data includes the Time Code. The request criteria can be for a single purchase order based on Reference, purchase orders based on search
     * criteria, or all purchase orders if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Orders_RequestType $body
     * @return \StructType\Get_Purchase_Orders_ResponseType|bool
     */
    public function Get_Purchase_Orders(\StructType\Get_Purchase_Orders_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Orders($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Policy_Groups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Expense Policy Groups for the specified criteria. Expense Policy Group data includes Expense Policy Group ID and Name. Expense Policy Group can be used to make it easier to search for and select items
     * for administrators. Expense items can belong to multiple groups. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Policy_Groups_RequestType $body
     * @return \StructType\Get_Expense_Policy_Groups_ResponseType|bool
     */
    public function Get_Expense_Policy_Groups(\StructType\Get_Expense_Policy_Groups_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Policy_Groups($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Rate_Table_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve Expense Rate Table Rules. An Expense Rate Table Rule contains a Condition Rule, including an ID, a Description, and lines of Condition Items. Each Condition Rule contains Open or Close
     * Parentheses, an And or Or operator, and filter criteria for the rule. On the web service request, you can specify a specific reference to a Expense Rate Table Rule to return.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Rate_Table_Rules_RequestType $body
     * @return \StructType\Get_Expense_Rate_Table_Rules_ResponseType|bool
     */
    public function Get_Expense_Rate_Table_Rules(\StructType\Get_Expense_Rate_Table_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Rate_Table_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Rate_Tables
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve instances of Expense Rate Tables. This contains Name, Type, Default Currency, Expense Item Type for evaluation and Rate Table Lines. Each Rate Table Line contains a reference to a Condition
     * Rule, Behavior Spend Data, and Graduated Expense Data. On the web service request, you can specify a specific reference to a Expense Rate Tables to return.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Rate_Tables_RequestType $body
     * @return \StructType\Get_Expense_Rate_Tables_ResponseType|bool
     */
    public function Get_Expense_Rate_Tables(\StructType\Get_Expense_Rate_Tables_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Rate_Tables($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Spend_Category_Hierarchies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Spend Category Hierarchies for the specified criteria. The request criteria can be for a single Spend Category Hierarchy based on Reference, Spend Category Hierarchy Name, or all Hierarchies can be
     * retrieved if no Reference is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Spend_Category_Hierarchies_RequestType $body
     * @return \StructType\Get_Spend_Category_Hierarchies_ResponseType|bool
     */
    public function Get_Spend_Category_Hierarchies(\StructType\Get_Spend_Category_Hierarchies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Spend_Category_Hierarchies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Payroll_Timesheets_Time_In_Time_Out
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Payroll Timesheet Time In Time Out instances for the specified criteria. These types of timesheets are used to track time on an interval basis. For instance, work can be recorded against a specified
     * time code from the hours of 8:00 am to 11:00 am, a different time code from 11:00 am to 12:00 pm, and so on. Payroll Timesheet Time In Time Out data includes Time Zone, the Worker the timesheet is for, the Period the timesheet covers, and data for
     * each day on the timesheet. Data for each day includes the Date, and 0 or more work intervals specifying the Time In, Time Out, the Time Code, and a Memo.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Payroll_Timesheets_Time_In_Time_Out_RequestType $body
     * @return \StructType\Get_Payroll_Timesheets_Time_In_Time_Out_ResponseType|bool
     */
    public function Get_Payroll_Timesheets_Time_In_Time_Out(\StructType\Get_Payroll_Timesheets_Time_In_Time_Out_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Payroll_Timesheets_Time_In_Time_Out($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Payroll_Timesheets_Total_Hours
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve instances of Payroll Timesheet Total Hours. This type of timesheet contains references to the Worker and Period the timesheet is for, and one or more Timesheet Lines. A Timesheet Line contains
     * references to a Time Code, a Position, a Cost Center, and Hours worked for each Day for the date range the timesheet covers. On the web service request, you can specify a specific reference to a Payroll Timesheet Total Hours to return, or find them
     * by supplying search criteria of Period, Supervisory Organization, timesheet Status, and Worker.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Payroll_Timesheets_Total_Hours_RequestType $body
     * @return \StructType\Get_Payroll_Timesheets_Total_Hours_ResponseType|bool
     */
    public function Get_Payroll_Timesheets_Total_Hours(\StructType\Get_Payroll_Timesheets_Total_Hours_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Payroll_Timesheets_Total_Hours($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Timesheets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will get Project Timesheets for the specified criteria. A Project Timesheet is used to track time for an Activity such as the Project or Project Task for a Workday configured Project. Other Timesheet types
     * include Payroll Total Hours and Payroll Time in Time Out.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Timesheets_RequestType $body
     * @return \StructType\Get_Project_Timesheets_ResponseType|bool
     */
    public function Get_Project_Timesheets(\StructType\Get_Project_Timesheets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Timesheets($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Travel_Profiles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: A Web Service for retrieving Worker Travel Profiles. Accepts the WIDs of Worker Travel Profiles in the request and returns the referenced Worker Travel Profiles if a WID is supplied. If no WID is supplied, all Worker Travel Profiles
     * are returned.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Travel_Profiles_RequestType $body
     * @return \StructType\Get_Travel_Profiles_ResponseType|bool
     */
    public function Get_Travel_Profiles(\StructType\Get_Travel_Profiles_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Travel_Profiles($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Expense_Credit_Card_Transaction_Files
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Expense Credit Card Transaction Files for the specified criteria. The response will include specific information about the Expense Credit Card Transaction Files such as the Expense Credit Card Transaction
     * File Reference, Expense Credit Card Transaction File Number, Expense Credit Card Transaction File Name, etc...No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Credit_Card_Transaction_Files_RequestType $body
     * @return \StructType\Get_Credit_Card_Transaction_Files_ResponseType|bool
     */
    public function Get_Expense_Credit_Card_Transaction_Files(\StructType\Get_Credit_Card_Transaction_Files_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Credit_Card_Transaction_Files($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Expense_Credit_Card_Transactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Expense Credit Card Transactions for the specified criteria. The response will include specific information about the Expense Credit Card Transactions such as the Corporate Credit Card Account, Cardholder
     * ID, Cardholder Name, Amount, Currency, etc...No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Credit_Card_Transactions_RequestType $body
     * @return \StructType\Get_Expense_Credit_Card_Transactions_ResponseType|bool
     */
    public function Get_Expense_Credit_Card_Transactions(\StructType\Get_Expense_Credit_Card_Transactions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Credit_Card_Transactions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Company_Defaults
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get default companies on expense reports for the specified criteria that may be different from worker’s own company of which they are a member. Expense Company Default data includes Company ID and
     * Worker. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Company_Defaults_RequestType $body
     * @return \StructType\Get_Expense_Company_Defaults_ResponseType|bool
     */
    public function Get_Expense_Company_Defaults(\StructType\Get_Expense_Company_Defaults_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Company_Defaults($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Card_Holder_Listing_Files
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Card Holder Listing Files for the specified criteria. The response will include specific information about the Card Holder Listing Files such as the Card Holder Listing File Reference, Card Holder Listing
     * File Number, Card Holder Listing File Name, etc...No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Card_Holder_Listing_Files_RequestType $body
     * @return \StructType\Get_Card_Holder_Listing_Files_ResponseType|bool
     */
    public function Get_Card_Holder_Listing_Files(\StructType\Get_Card_Holder_Listing_Files_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Card_Holder_Listing_Files($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Expense_Item_Attribute_Groups
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Expense Item Attribute Groups for the specified criteria. Expense Item Attribute Group data includes Expense Item Attribute Group ID and Name. Expense Item Attribute Group can be used to make it easier
     * to search for and select items. Expense item attributes can belong to multiple groups. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Expense_Item_Attribute_Groups_RequestType $body
     * @return \StructType\Get_Expense_Item_Attribute_Groups_ResponseType|bool
     */
    public function Get_Expense_Item_Attribute_Groups(\StructType\Get_Expense_Item_Attribute_Groups_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Expense_Item_Attribute_Groups($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Receipts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Receipts for the specified criteria. Receipt data includes Receipt Number, Company, Supplier, Document Date, Memo, Attachment data, and Receipt Line. For a Receipt Line, there is a Purchase Order Line
     * Reference, and Quantity Received. The request criteria can be for a single receipt based on Reference, or all receipts. Only goods and contingent worker receipt lines will be shown, not any other kinds of receipt lines. Receipts without any goods or
     * contingent worker lines will not be returned.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Receipts_RequestType $body
     * @return \StructType\Get_Receipts_ResponseType|bool
     */
    public function Get_Receipts(\StructType\Get_Receipts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Receipts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Catalog_Items
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Catalog Items for the specified criteria. Catalog Item Data includes Catalog Item Reference, Item Identifier, Item Name, Item Description, current Unit Price, Unit of Measure Reference, Spend Category
     * Reference, Item URL, Supplier Order Contract Reference, Is Catalog Load Active, and Catalog Item Data Data. Catalog Item Data Data includes Catalog Item Data Effective Date, Unit Price and Catalog Item Data isActive. The request criteria can be for a
     * single Catalog Item based on Reference, Catalog Items based on search criteria (Such as Item Identifier and/or one of the following: Supplier Order Contract, Resource Provider and Company or Company Hierarchy), or all Catalog Items if no criteria is
     * specified. There is no corresponding Put Catalog Item web service task as this is accomplished through the Catalog Load Request.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Catalog_Items_RequestType $body
     * @return \StructType\Get_Catalog_Items_ResponseType|bool
     */
    public function Get_Catalog_Items(\StructType\Get_Catalog_Items_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Catalog_Items($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requisitions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Requisitions for the specified criteria. Requisition Data include Requisition Number, Requisition Date, Company, Ship-To Address, Requester, High Priority, Item Request Line Data, Deliverables Line
     * Data and Attachment Data. Item Request Line Data include Requisition Goods Line, Item, Item Description, Spend Category, Supplier, Quantity, Unit of Measure, Unit Cost, Extended Amount, Memo, and Worktags. Deliverables Line Data include Deliverables
     * Line, Project, Memo, Spend Category, Project Phase Data, Extended Amount, and Worktags. Project Phase Data includes Project Plan Phase and Project Plan Task Data. Project Plan Task Data include Project Plan Task and Project Subtask Data. Project
     * Subtask Data include Description and Amount. The request criteria can be for a single Requisition based on Reference, Requisitions based on search criteria, or all Requisitions if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requisitions_RequestType $body
     * @return \StructType\Get_Requisitions_ResponseType|bool
     */
    public function Get_Requisitions(\StructType\Get_Requisitions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requisitions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Asset_Book_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to get asset book rules. Asset Book Rules are ordered, and allow you to specify Accounting Treatment and Depreciation Profile based on Spend Category, Asset Class, Asset Type, Company, Amount, Currency, and
     * Amount Basis Reference (Unit Amount or Extended Amount).No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Asset_Book_Rules_RequestType $body
     * @return \StructType\Get_Asset_Book_Rules_ResponseType|bool
     */
    public function Get_Asset_Book_Rules(\StructType\Get_Asset_Book_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Asset_Book_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Spend_Authorizations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Spend Authorizations for the specified criteria. Spend Authorizations are used to request prior approval for expenses. After these authorized expenses are incurred, a worker submits an expense report for them and attaches the
     * approved Spend Authorization to the report. Spend Authorization data includes Worker, Company, Date, Description, Justification, Estimated Amount, Spend Authorization Lines, and Attachments. The Spend Authorization lines include: Expense Item,
     * Quantity, Unit Cost, Billable flag, Worktags, and Memo.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Spend_Authorizations_RequestType $body
     * @return \StructType\Get_Spend_Authorizations_ResponseType|bool
     */
    public function Get_Spend_Authorizations(\StructType\Get_Spend_Authorizations_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Spend_Authorizations($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoice_Schedules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Supplier Invoice Schedules that match the specified criteria. The Supplier Invoice data includes:Supplier Invoice Schedule ID; Submit; Schedule Status; Company or Company Hierarchy; Supplier; Currency; Supplier Contract;
     * Supplier Contract Lines; Schedule Description; On Hold Flag; Default Tax Code; Payment Terms; Override Payment Type; Auto-submit for Approval flag; Distribution Method; Distribute by Quantity; Frequency Behavior; Schedule From Date; Schedule To Date;
     * Number of Installments; Date Option; Day of Month; Automatically Regenerate Schedules; Automatically Submit Schedules and Supplier Invoice Installment Data.The Supplier Invoice Installment Data includes:Supplier Invoice Installment ID; Supplier
     * Invoice Installment; Installment Number; Installment Status; Installment (Invoice) Date; Installment Start(From) Date; Installment End(To) Date; Supplier Invoice reference; On Hold Flag; Use Installment Overrides Flag; Override Tax Code; Override
     * Payment Terms; Override Payment Type; Override Memo and Supplier Invoice Installment Line Data. The Supplier Invoice Installment Line Data includes:Supplier Contract Line; Line Order; Use Line Overrides; Quantity; From Date; To Date; Amount; Override
     * Unit Of Measure; Override Line Description; Override Spend Category and Override Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Schedules_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Schedules_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Schedules(\StructType\Get_Supplier_Invoice_Schedules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Schedules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Order_Schedules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Purchase Order Schedules that match the specified criteria. The Purchase Order data includes:Purchase Order Schedule ID; Submit; Schedule Status; Company or Company Hierarchy; Supplier; Currency; Supplier Contract; Supplier
     * Contract Lines; Schedule Description; On Hold Flag; Buyer; Issue Option; Default Tax Code; Payment Terms; Auto-submit for Approval flag; Override Payment Type; Procurement Card; Bill-To Contact; Bill-To Address; Ship-To Contact; Ship-To Address;
     * Distribution Method; Frequency Behavior; Schedule From Date; Schedule To Date; Number of Installments; Date Option; Day of Month; Automatically Regenerate Schedules; Automatically Submit Schedules and Purchase Order Installment Data.The Purchase
     * Order Installment Data includes:Purchase Order Installment ID; Purchase Order Installment; Installment Number; Installment Status; Installment (Purchase Order) Date; Installment Start(From) Date; Installment End(To) Date; Purchase Order reference; On
     * Hold Flag; Use Installment Overrides Flag; Override Buyer; Override Tax Code; Override Purchase Order Issue Option; Override Payment Terms; Override Bill-To Contact; Override Bill-To Address; Override Ship-To Contact; Override Ship-To Address;
     * Override Payment Type; Override Procurement Card; Override Memo and Purchase Order Installment Line Data. The Purchase Order Installment Line Data includes:Supplier Contract Line; Line Order; Use Line Overrides; Quantity; From Date; To Date; Amount;
     * Override Unit Of Measure; Override Line Description; Override Spend Category and Override Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Order_Schedules_RequestType $body
     * @return \StructType\Get_Purchase_Order_Schedules_ResponseType|bool
     */
    public function Get_Purchase_Order_Schedules(\StructType\Get_Purchase_Order_Schedules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Order_Schedules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Contracts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Supplier Contracts that match the specified criteria. Supplier Contract data includes Supplier Contract ID; Company or Company Hierarchy; Supplier; Contract Specialist; Buyer; Supplier Contract Type; Contract Name; Supplier
     * Reference Number; Contract Start, Signed, and End Dates; Total and Original Contract Amounts; Currency; Tax Code; Contract Overview; Supplier Catalog; Supplier Catalog Discount Percentage; Supplier Invoice Company; Supplier Invoice Payment Terms;
     * Override Payment Type; Purchase Order Company; Purchase Order Issue Option; Purchase Order Payment Terms; Bill-To and Ship-To Contacts and Addresses; On Hold Flag; Submit Flag; Attachment Data; and Supplier Contract Line Data. The Supplier Contract
     * Line Data includes the Line Number, Company, Item, Item Description, Item Spend Category, Tax Applicability, Tax Code, Quantity, Unit of Measure, Unit Cost, Extended Amount, Start and End Date, Memo, Location, and Worktags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Contracts_RequestType $body
     * @return \StructType\Get_Supplier_Contracts_ResponseType|bool
     */
    public function Get_Supplier_Contracts(\StructType\Get_Supplier_Contracts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Contracts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Catalogs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves Supplier Catalogs by References or by Criteria. Either References or Criteria must be provided, but not both at the same time. References can be specified by one or more Reference ID or WID. Request Criteria includes
     * Catalog Name, Currency, and Supplier Reference. Response Data includes Catalog Name, Supplier Reference, Currency, and Catalog Data if available. Catalog Data contains Catalog Item Data loaded into the catalog. Each Catalog Item Data has the
     * following attributes: Currently Active, Current Rate, Unit of Measure, Spend Category, Item Description, Lead Time, Item URL, Purchase Item, and Pricing History.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Catalogs_RequestType $body
     * @return \StructType\Get_Supplier_Catalogs_ResponseType|bool
     */
    public function Get_Supplier_Catalogs(\StructType\Get_Supplier_Catalogs_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Catalogs($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Airlines
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Airline objects. An Airline object consists of an ID, a name, and an optional Merchant Code.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Airlines_RequestType $body
     * @return \StructType\Get_Airlines_ResponseType|bool
     */
    public function Get_Airlines(\StructType\Get_Airlines_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Airlines($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Hotels
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Hotel objects. A Hotel object consists of an ID, a name and an optional Merchant Code.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Hotels_RequestType $body
     * @return \StructType\Get_Hotels_ResponseType|bool
     */
    public function Get_Hotels(\StructType\Get_Hotels_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Hotels($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Car_Rental_Agencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Gets Car Rental Agency objects. A Car Rental Agency object consists of an ID, a name, and an optional Merchant Code.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Car_Rental_Agencies_RequestType $body
     * @return \StructType\Get_Car_Rental_Agencies_ResponseType|bool
     */
    public function Get_Car_Rental_Agencies(\StructType\Get_Car_Rental_Agencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Car_Rental_Agencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Travel_Cities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Travel City objects. Use filtering criteria to retrieve specific Travel City objects.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Travel_Cities_RequestType $body
     * @return \StructType\Get_Travel_Cities_ResponseType|bool
     */
    public function Get_Travel_Cities(\StructType\Get_Travel_Cities_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Travel_Cities($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Airports
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Gets Airport objects. An Airport object consists of a name. You specify the Airport name when retrieving Airport objects.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Airports_RequestType $body
     * @return \StructType\Get_Airports_ResponseType|bool
     */
    public function Get_Airports(\StructType\Get_Airports_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Airports($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Assets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Business Assets for the specified criteria. Workday Business Asset Management allows you to perform a basic accounting flow of fixed assets (capitalization and depreciation) and to track custodianship of an asset regardless
     * of its accounting treatment. In Workday, a business asset is anything you want to track, from tractors to software licenses. Business Asset data includes Business Asset ID, Company, Spend Category, Expense Item, Purchase Item, Acquisition Method,
     * Depreciation Method, Depreciation Posting Frequency, Currency, Resource Name, Description, PO Number, Useful Life, Remaining Depreciation Periods, Serial Number, Date Acquired, Date Placed in Service, Last Issue Date, Depreciation Start Date. Also
     * included in the response are all asset activity, including acquisitions, transfers, issues, disposals, reinstatements, and impairments.The request criteria can be for a single Asset based on reference, or you can find assets by Company, Location,
     * Worker Issued to, Worktags assigned, acquisition date, or identifiers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Assets_RequestType $body
     * @return \StructType\Get_Assets_ResponseType|bool
     */
    public function Get_Assets(\StructType\Get_Assets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Assets($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Asset_Book_Configurations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation gets asset depreciation schedule information for non-primary asset books for the specified criteria. An asset can have multiple depreciation schedules based on different depreciation information such as
     * depreciation profile, accounting treatment, depreciation method, depreciation convention, bonus depreciation information and historical information. The data retrieved includes the complete list of fields that you can change and load back using the
     * inbound service operation Update Asset Depreciation Schedule.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Asset_Book_Configurations_RequestType $body
     * @return \StructType\Get_Asset_Book_Configurations_ResponseType|bool
     */
    public function Get_Asset_Book_Configurations(\StructType\Get_Asset_Book_Configurations_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Asset_Book_Configurations($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Prepaid_Spend_Amortizations
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Prepaid Spend Amortization for the specified criteria. Prepaid Spend Amortization data includes the Accounting Date and Supplier Invoice. The request criteria can be for a single transaction based on
     * Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Prepaid_Spend_Amortizations_RequestType $body
     * @return \StructType\Get_Prepaid_Spend_Amortizations_ResponseType|bool
     */
    public function Get_Prepaid_Spend_Amortizations(\StructType\Get_Prepaid_Spend_Amortizations_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Prepaid_Spend_Amortizations($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Prepaid_Spend_Amortization_Schedules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This will retrieve a set of prepaid spend amortization schedules with their installments. A criteria can be given.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Prepaid_Spend_Amortization_Schedules_RequestType $body
     * @return \StructType\Get_Prepaid_Spend_Amortization_Schedules_ResponseType|bool
     */
    public function Get_Prepaid_Spend_Amortization_Schedules(\StructType\Get_Prepaid_Spend_Amortization_Schedules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Prepaid_Spend_Amortization_Schedules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Project Assets for the specified criteria. The request criteria can be for the following: 1) A single transaction based on Reference2) A single project in which case all project assets for the project
     * will be retrieved3) All project assets can be retrieved if no criteria is specifiedNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Asset_RequestType $body
     * @return \StructType\Get_Project_Asset_ResponseType|bool
     */
    public function Get_Project_Asset(\StructType\Get_Project_Asset_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Asset_Pooling_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to get asset pooling rules. Asset Pooling Rules are ordered, and are based on Company, Spend Category, Item, Currency, Quantity Greater Than, and Unit Cost Less Than.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Asset_Pooling_Rules_RequestType $body
     * @return \StructType\Get_Asset_Pooling_Rules_ResponseType|bool
     */
    public function Get_Asset_Pooling_Rules(\StructType\Get_Asset_Pooling_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Asset_Pooling_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Returns
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Returns for the specified criteria. Return data includes Return Number, Return Status, Company for Return, Supplier for Return, Return Reason, Return Date, Supplier Invoice on Return, Supplier RMA,
     * Return Memo, Created by, Line Data, and Attachment Data. The request criteria can be a single Return based on a reference, or Returns with matching criteria of Company, Return Number, Status, Date On or After, Date On or Before, Supplier, Return
     * Reason, Returns for Purchase Order Reference, Returns for Supplier Contract Reference, Spend Categories, Items, Supplier RMA, Created by, or Approved by.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Returns_RequestType $body
     * @return \StructType\Get_Returns_ResponseType|bool
     */
    public function Get_Returns(\StructType\Get_Returns_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Returns($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Workday_Project_Hierarchies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Workday Project Hierarchies WS TaskNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Workday_Project_Hierarchies_RequestType $body
     * @return \StructType\Get_Workday_Project_Hierarchies_ResponseType|bool
     */
    public function Get_Workday_Project_Hierarchies(\StructType\Get_Workday_Project_Hierarchies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Workday_Project_Hierarchies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Workday_Project_Hierarchies_without_Dependencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Workday Project Hierarchies without Dependencies WS Task.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Workday_Project_Hierarchies_without_Dependencies_RequestType $body
     * @return \StructType\Get_Workday_Project_Hierarchies_without_Dependencies_ResponseType|bool
     */
    public function Get_Workday_Project_Hierarchies_without_Dependencies(\StructType\Get_Workday_Project_Hierarchies_without_Dependencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Workday_Project_Hierarchies_without_Dependencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Procurement_Card_Transaction_Verifications
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Procurement Card Transaction Verifications for the specified criteria. The response will include specific information about the Procurement Card Transaction Verification such as the Company, Worker, Date,
     * Credit Card Transaction, Purchase Order or Supplier Contract (if applicable), the Lines, etc... The request criteria can be for a single Procurement Card Transaction Verification based on Reference or Procurement Card Transaction Verifications based
     * on Company, Worker, or Transaction Date.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Procurement_Card_Transaction_Verifications_RequestType $body
     * @return \StructType\Get_Procurement_Card_Transaction_Verifications_ResponseType|bool
     */
    public function Get_Procurement_Card_Transaction_Verifications(\StructType\Get_Procurement_Card_Transaction_Verifications_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Procurement_Card_Transaction_Verifications($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Procurement_Mass_Close
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Procurement Mass Close requests for the specified criteria. Procurement Mass Close Data includes Company or Company Hierarchy, Procurement Document Type, Procurement Mass Close Request Name, header
     * Memo, the Business Documents for the request, a line Memo and Exclude from Process.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Procurement_Mass_Close_RequestType $body
     * @return \StructType\Get_Procurement_Mass_Close_ResponseType|bool
     */
    public function Get_Procurement_Mass_Close(\StructType\Get_Procurement_Mass_Close_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Procurement_Mass_Close($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Travel_Booking_Files
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Travel Booking Files based on Travel Booking File Instance OR based on a Start and End Date range for the Travel File Load Date.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Travel_Booking_Files_RequestType $body
     * @return \StructType\Get_Travel_Booking_Files_ResponseType|bool
     */
    public function Get_Travel_Booking_Files(\StructType\Get_Travel_Booking_Files_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Travel_Booking_Files($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Task_Resources
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The service operations would get all Project Task Resources for a Project reference or specified Project Task Resource Reference.Project Task Resource Data contains Project Task Resource ID,Project Plan Task Reference,Project
     * Resource Plan Detail Reference,Worker Reference,Resource Start Date,Resource End Date,% Allocation,Estimated HoursNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Task_Resources_RequestType $body
     * @return \StructType\Get_Project_Task_Resources_ResponseType|bool
     */
    public function Get_Project_Task_Resources(\StructType\Get_Project_Task_Resources_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Task_Resources($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Projects
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Projects for the specified criteria. A project can be used as a worktag throughout Financial Management and HCM. Project data includes Project ID, Description, Name, Reference, Start Date, End Date,
     * and Customer. The request criteria can be for a single transaction based on Reference, or all transaction can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Projects_RequestType $body
     * @return \StructType\Get_Projects_ResponseType|bool
     */
    public function Get_Projects(\StructType\Get_Projects_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Projects($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Plans
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This is the GET Project Plan web service.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Plans_RequestType $body
     * @return \StructType\Get_Project_Plans_ResponseType|bool
     */
    public function Get_Project_Plans(\StructType\Get_Project_Plans_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Plans($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Resource_Plans
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation retrieves Resource Plan and Resource Plan Line Data.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Plans_RequestType $body
     * @return \StructType\Get_Resource_Plans_ResponseType|bool
     */
    public function Get_Resource_Plans(\StructType\Get_Resource_Plans_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Plans($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Request_for_Quote
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Request for Quotes for the specified criteria. The request criteria can be for a specific RFQ document based on a Reference or can be for a search criteria based on the Attributes - Company, RFQ Type,
     * Document Date, Start Date, End Date, Sourcing Buyer and RFQ Status. Request for Quote response data includes RFQ Number, RFQ Type, Status, RFQ Title, Company, Sourcing Buyer, Start Date, End Date, Buyer, Terms and Conditions, Proposed Suppliers for
     * the RFQ and Bid Requirements. RFQ lines can be of type Goods Lines or Service Lines. Goods lines include Line Number, Item, Quantity, Unit of Measure, Unit Cost, Amount, Target Price, Due Date, Spend Category, Worktags and Memo. Service Lines include
     * similar information as Goods line except that it does not have the Quantity, Unit of Measure and Unit cost. In addition Service Lines have Start Date and End Date for the Services. Both the line types can have Bid Requirements.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Request_for_Quote_RequestType $body
     * @return \StructType\Get_Request_for_Quote_ResponseType|bool
     */
    public function Get_Request_for_Quote(\StructType\Get_Request_for_Quote_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Request_for_Quote($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Item_Identifier_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Item Identifiers Types. Request can be made for a list of Item Identifiers Types or for all Item Identifiers Types.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Item_Identifier_Types_RequestType $body
     * @return \StructType\Get_Item_Identifier_Types_ResponseType|bool
     */
    public function Get_Item_Identifier_Types(\StructType\Get_Item_Identifier_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Item_Identifier_Types($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Request_for_Quote_Responses
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Request for Quote Responses for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Request_for_Quote_Responses_RequestType $body
     * @return \StructType\Get_Request_for_Quote_Responses_ResponseType|bool
     */
    public function Get_Request_for_Quote_Responses(\StructType\Get_Request_for_Quote_Responses_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Request_for_Quote_Responses($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Remit_To_Supplier_Connections
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Connections for the specified Supplier criteria, The request criteria can be for a single supplier based on Reference, or all supplier connections can be retrieved if no criteria is specified.
     * Supplier Connection data includes owning Supplier, Supplier Connection ID, Supplier Connection Name, Remit To Supplier Reference, Default Payment Type, Accepted Payment Type, Settlement Bank Account Reference, Remit To Address Reference, Remit To
     * Email, Payee Alternate Name Reference, Payment Memo, Default flag and inactive flag.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Remit_To_Supplier_Connections_RequestType $body
     * @return \StructType\Get_Remit_To_Supplier_Connections_ResponseType|bool
     */
    public function Get_Remit_To_Supplier_Connections(\StructType\Get_Remit_To_Supplier_Connections_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Remit_To_Supplier_Connections($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requirements_for_Resource_Plan
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation retrieves Resource Requirements.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requirements_for_Resource_Plan_RequestType $body
     * @return \StructType\Get_Requirements_for_Resource_Plan_ResponseType|bool
     */
    public function Get_Requirements_for_Resource_Plan(\StructType\Get_Requirements_for_Resource_Plan_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requirements_for_Resource_Plan($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Request_for_Quote_Awards
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Request for Quote (RFQ) Awards for the specified criteria. The request criteria can be for a specific RFQ Award document based on a Reference or can be for a search criteria based on the following
     * Attributes - Company, RFQ, RFQ Award Type, Award Date, Supplier and RFQ Award Status. RFQ Awards Response data includes RFQ Award Number, Award Type, Status, RFQ, RFQ Response, Company, Sourcing Buyer, Supplier, Award Date, Memo, Award Lines,
     * Attachments, Purchase Order Defaults or Supplier Contract Defaults. RFQ Award lines can be of either Goods or Service based Lines and may or may not include Splits and Attachments.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Request_for_Quote_Awards_RequestType $body
     * @return \StructType\Get_Request_for_Quote_Awards_ResponseType|bool
     */
    public function Get_Request_for_Quote_Awards(\StructType\Get_Request_for_Quote_Awards_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Request_for_Quote_Awards($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requisition_Sourcing_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Requisition Sourcing Rules for the specified criteria. The request criteria can be for a specific Sourcing Rule based on one or more References, or if no references are supplied, all sourcing rules are
     * returned. Requisition Sourcing Rule response data returns global attributes: Apply Sourcing Rules to Items on Contracts, Default to Supplier with Purchase Item on Contract, Order-From Connection on Contract has Priority, Use Default Inventory Site
     * for Company, Default Fulfillment Source to Inventory for Valid Items for Inventory Site. Each Requisition Sourcing Rule returned includes Requisition Sourcing Rule Reference. There are four kinds of Requisition Sourcing Rules: Buyer Sourcing Rules
     * return ID, Company, Ship To Address, Active Location or Location Hierarchy, Requisition Type, Spend Category, Supplier, Resulting Buyer, Use Submitted By Worker on Requisition as Buyer, and Use Requisition Sourcing Buyer.Supplier Sourcing Rules
     * return ID, Company, Spend Category, Ship-To Address, Purchase Item, Contract Required, and Resulting Supplier.Inventory Site Sourcing Rules return ID, Company, Requisition Type, Spend Category, Supplier, Ship-To Address, Active Location or Location
     * Hierarchy, Purchase Item, Inventory Site Location, and Resulting Stock Request Type.Order-From Connection Sourcing Rules return ID, Supplier, Company, Purchase Order Type, Ship-To Address, Spend Category, and Resulting Order-From Connection.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requisition_Sourcing_Rules_RequestType $body
     * @return \StructType\Get_Requisition_Sourcing_Rules_ResponseType|bool
     */
    public function Get_Requisition_Sourcing_Rules(\StructType\Get_Requisition_Sourcing_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requisition_Sourcing_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Guests
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Guests for the specified criteria. The response will include specific information about the Guests such as the Guest Name, Guest Company and Guest Title.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Guests_RequestType $body
     * @return \StructType\Get_Guests_ResponseType|bool
     */
    public function Get_Guests(\StructType\Get_Guests_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Guests($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Guest_Listing_Files
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will get all Guest Listing Files for the specified criteria. The response will include specific information about the File including Number, Name and Date. It will also include information about Guests such as the
     * Guest Name, Guest Company and Guest Title.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Guest_Listing_Files_RequestType $body
     * @return \StructType\Get_Guest_Listing_Files_ResponseType|bool
     */
    public function Get_Guest_Listing_Files(\StructType\Get_Guest_Listing_Files_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Guest_Listing_Files($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Contact_Information
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Contact Information for the specified criteria. Supplier Contact Information data includes Address, Phone, Email, Instant Messenger and Web Address data. The request criteria can be for a
     * single transaction based on Supplier Reference, or all transactions can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Contact_Information_RequestType $body
     * @return \StructType\Get_Supplier_Contact_Information_ResponseType|bool
     */
    public function Get_Supplier_Contact_Information(\StructType\Get_Supplier_Contact_Information_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Contact_Information($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Resource_Forecasts
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This GET Web Service retrieves Resource Forecast based on Resource Forecast Reference ID or Project ID passed in as request criteriaNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Forecasts_RequestType $body
     * @return \StructType\Get_Resource_Forecasts_ResponseType|bool
     */
    public function Get_Resource_Forecasts(\StructType\Get_Resource_Forecasts_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Forecasts($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Cash_Advance_Repayments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Cash Advance Repayments for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Cash_Advance_Repayments_RequestType $body
     * @return \StructType\Get_Cash_Advance_Repayments_ResponseType|bool
     */
    public function Get_Cash_Advance_Repayments(\StructType\Get_Cash_Advance_Repayments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Cash_Advance_Repayments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Order_Change_Orders
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get the purchase order with a version #. The data include header, line, and split level information.The request criteria can be for a single change order based on Reference, change orders based on search
     * criteria, or allchange orders if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Order_Change_Orders_RequestType $body
     * @return \StructType\Get_Purchase_Order_Change_Orders_ResponseType|bool
     */
    public function Get_Purchase_Order_Change_Orders(\StructType\Get_Purchase_Order_Change_Orders_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Order_Change_Orders($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Asset_Shares
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to get asset shares for a business asset.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Asset_Shares_RequestType $body
     * @return \StructType\Get_Asset_Shares_ResponseType|bool
     */
    public function Get_Asset_Shares(\StructType\Get_Asset_Shares_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Asset_Shares($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Project_Standard_Cost_Rate_Sheets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation retrieves and exports Project Standard Cost Rate Sheet and associated Project Standard Cost Rates data, i.e., project worker roles, rules and standard cost rates.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Standard_Cost_Rate_Sheets_RequestType $body
     * @return \StructType\Get_Project_Standard_Cost_Rate_Sheets_ResponseType|bool
     */
    public function Get_Project_Standard_Cost_Rate_Sheets(\StructType\Get_Project_Standard_Cost_Rate_Sheets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Standard_Cost_Rate_Sheets($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Internal_Service_Deliveries
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation will get Internal Service Deliveries for the specified criteria. The request criteria can be for a specific Internal Service Delivery document based on a Reference ID or can include search criteria based on
     * the following attributes - Company, Document Status, Internal Service Provider, Created by Workers, Approved by Workers, Intercompany and Document Date Range. Internal Service Delivery response data includes Internal Service Delivery Number, Company,
     * Internal Service Provider, Currency, Delivery Date, Document Date, Internal Catalog, Approved on Date, Intercompany, Worktags, Lines and Attachments. Internal Service Delivery Line Data includes Line Number, Item, Description, Spend Category,
     * Quantity, Unit of Measure, Unit Cost, Amount, Requester, Delivery Date, Memo and Worktags. An Internal Service Delivery line may or may not include Line Splits.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Internal_Service_Deliveries_RequestType $body
     * @return \StructType\Get_Internal_Service_Deliveries_ResponseType|bool
     */
    public function Get_Internal_Service_Deliveries(\StructType\Get_Internal_Service_Deliveries_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Internal_Service_Deliveries($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Item_Tags
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Get Item Tags. Request can be made for a list of Item Tags or for all Item Tags.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Item_Tags_RequestType $body
     * @return \StructType\Get_Item_Tags_ResponseType|bool
     */
    public function Get_Item_Tags(\StructType\Get_Item_Tags_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Item_Tags($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Internal_Service_Providers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation will get Internal Service Providers for the specified criteria. The request criteria can be for a specific Internal Service Provider based on a Reference ID or can include search criteria based on the
     * following attributes - Company, Internal Service Provider Name, Internal Service Provider ID, Inactive, and Currency. Internal Service Provider response data includes Company, Internal Service Provider Name, Internal Service Provider ID, Inactive,
     * and Currency.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Internal_Service_Providers_RequestType $body
     * @return \StructType\Get_Internal_Service_Providers_ResponseType|bool
     */
    public function Get_Internal_Service_Providers(\StructType\Get_Internal_Service_Providers_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Internal_Service_Providers($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Internal_Catalogs
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation is for retrieving Internal Catalogs by References or by Criteria. Either References or Criteria must be provided, but not both at the same time. References can be specified by one or more Reference ID or
     * WID. Criteria can be specified by the attributes catalog Name, Currency, and Internal Service Provider. If using Criteria, at least one criterion attribute must be provided. The Response Data will include the following catalog attributes: Name,
     * Internal Service Provider, Currency, and Catalog Data if available. The Catalog Data contains Catalog Item Data loaded for the catalog. Each Catalog Item Data has the following attributes: Currently Active, Current Rate, Unit of Measure, Spend
     * Category, Item Description, Lead Time, Item URL, Purchase Item, and the Pricing History.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Internal_Catalogs_RequestType $body
     * @return \StructType\Get_Internal_Catalogs_ResponseType|bool
     */
    public function Get_Internal_Catalogs(\StructType\Get_Internal_Catalogs_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Internal_Catalogs($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Credit_Card_Code_Mappings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get all Merchant Code to Expense Item mappingsNot Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Credit_Card_Code_Mappings_RequestType $body
     * @return \StructType\Get_Credit_Card_Code_Mappings_ResponseType|bool
     */
    public function Get_Credit_Card_Code_Mappings(\StructType\Get_Credit_Card_Code_Mappings_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Credit_Card_Code_Mappings($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoice_Requests
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Invoice Requests for the specified criteria. Supplier Invoice Request data includes Supplier Invoice Request ID, Invoice Request Number, Invoice Request Document Status, Invoice Date, Canceled
     * on Date, Requester, Company, Currency, Supplier, Contingent Worker, Supplier Connection, Due Date, Control Total Amount, Invoice Request Total Amount, Shipping Address, Payment Terms, Payment Handling Instruction, Freight Amount, Supplier Reference,
     * Memo, Supplier Invoice, Attachment and Supplier Invoice Request Line data. Line data includes Supplier Invoice Request Line ID, Line Type, Purchase Item, Item Description, Spend Category, Quantity, Unit Cost, Extended Amount, Line Memo and Worktags.
     * The request criteria can be for a single or multiple transactions based on Reference. If no criteria are specified, then the service will not retrieve any transactions.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Requests_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Requests_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Requests(\StructType\Get_Supplier_Invoice_Requests_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Requests($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Resource_Plan_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Web service operation for retrieving instance data from the Project Resource Plan Template class.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Plan_Templates_RequestType $body
     * @return \StructType\Get_Resource_Plan_Templates_ResponseType|bool
     */
    public function Get_Resource_Plan_Templates(\StructType\Get_Resource_Plan_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Plan_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Advanced_Ship_Notices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Advanced Ship Notices for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Advanced_Ship_Notices_RequestType $body
     * @return \StructType\Get_Advanced_Ship_Notices_ResponseType|bool
     */
    public function Get_Advanced_Ship_Notices(\StructType\Get_Advanced_Ship_Notices_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Advanced_Ship_Notices($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Worker_Travel_Profile_Listing_Files
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Travel Profile Files based on Travel Profile File Instance.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Worker_Travel_Profile_Listing_Files_RequestType $body
     * @return \StructType\Get_Worker_Travel_Profile_Listing_Files_ResponseType|bool
     */
    public function Get_Worker_Travel_Profile_Listing_Files(\StructType\Get_Worker_Travel_Profile_Listing_Files_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Worker_Travel_Profile_Listing_Files($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Order_Acknowledgement
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Purchase Order Acknowledgements for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Order_Acknowledgements_RequestType $body
     * @return \StructType\Get_Purchase_Order_Acknowledgements_ResponseType|bool
     */
    public function Get_Purchase_Order_Acknowledgement(\StructType\Get_Purchase_Order_Acknowledgements_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Order_Acknowledgement($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Location_Customer_Account_Number_Details
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation is to retrieve Location Customer Account Number Details by References or by Criteria. Either References or Criteria must be provided, but not both at the same time. References can be specified by one or
     * more Reference ID or WID.Request Criteria can be Supplier, Location, Customer Account Number or Inactive flag. If no request references or request criteria is provided, then all Location Customer Account Number Details are returned by the Web Service
     * operation. Response Data includes Supplier, Location, Customer Account Number, JIT Customer Account Number and Inactive flag.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Location_Customer_Account_Number_Details_RequestType $body
     * @return \StructType\Get_Location_Customer_Account_Number_Details_ResponseType|bool
     */
    public function Get_Location_Customer_Account_Number_Details(\StructType\Get_Location_Customer_Account_Number_Details_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Location_Customer_Account_Number_Details($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Role_Categories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Project Role Categories by Reference ID, or returns all Project Role Categories if no Reference ID is provided.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Role_Categories_RequestType $body
     * @return \StructType\Get_Project_Role_Categories_ResponseType|bool
     */
    public function Get_Project_Role_Categories(\StructType\Get_Project_Role_Categories_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Role_Categories($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Classifications
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get supplier classifications for the specified criteria. Supplier classifications are used for reporting. Supplier classification data includes classification name, external site boolean, country, and
     * attributes. The request criteria can be for a specific classifications based on references, or all supplier classifications can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Classifications_RequestType $body
     * @return \StructType\Get_Supplier_Classifications_ResponseType|bool
     */
    public function Get_Supplier_Classifications(\StructType\Get_Supplier_Classifications_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Classifications($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Invoice_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Returns Invoice Types for the specified criteria. Invoice Type data includes Invoice Type Value, Country, Description, Usage Location, Inactive Indicator, and In Use indicator.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Invoice_Types_RequestType $body
     * @return \StructType\Get_Invoice_Types_ResponseType|bool
     */
    public function Get_Invoice_Types(\StructType\Get_Invoice_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Invoice_Types($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Resource_Pool_Hierarchies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service task retrieves Resource Pool Hierarchies.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Pool_Hierarchies_RequestType $body
     * @return \StructType\Get_Resource_Pool_Hierarchies_ResponseType|bool
     */
    public function Get_Resource_Pool_Hierarchies(\StructType\Get_Resource_Pool_Hierarchies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Pool_Hierarchies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Resource_Pools
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service task retrieves Resource Pools.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Pools_RequestType $body
     * @return \StructType\Get_Resource_Pools_ResponseType|bool
     */
    public function Get_Resource_Pools(\StructType\Get_Resource_Pools_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Pools($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Resource_Pool_Hierarchies_without_Dependencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service task retrieves Resource Pool Hierarchies without Dependencies.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Resource_Pool_Hierarchies_without_Dependencies_RequestType $body
     * @return \StructType\Get_Resource_Pool_Hierarchies_without_Dependencies_ResponseType|bool
     */
    public function Get_Resource_Pool_Hierarchies_without_Dependencies(\StructType\Get_Resource_Pool_Hierarchies_without_Dependencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Resource_Pool_Hierarchies_without_Dependencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requisition_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enable retrieval of custom objects for the Requisition.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requisition_Additional_Data_RequestType $body
     * @return \StructType\Get_Requisition_Additional_Data_ResponseType|bool
     */
    public function Get_Requisition_Additional_Data(\StructType\Get_Requisition_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requisition_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Requisition_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enable retrieval of custom objects for the Requisition Line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requisition_Line_Additional_Data_RequestType $body
     * @return \StructType\Get_Requisition_Line_Additional_Data_ResponseType|bool
     */
    public function Get_Requisition_Line_Additional_Data(\StructType\Get_Requisition_Line_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requisition_Line_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Company_Asset_Book_Restrictions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Company asset book restrictions for company asset books can be retrieved according to company. Restrictions are ordered.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Company_Asset_Book_Restrictions_RequestType $body
     * @return \StructType\Get_Company_Asset_Book_Restrictions_ResponseType|bool
     */
    public function Get_Company_Asset_Book_Restrictions(\StructType\Get_Company_Asset_Book_Restrictions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Company_Asset_Book_Restrictions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Transfer_Pricing_Rate_Sheet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation retrieves and exports Transfer Pricing Rate Sheet and associated Transfer Pricing Rate data, i.e., rules, transfer pricing cost rates and basis.Returns Transfer Pricing Rate Sheets by Reference ID, or
     * returns all Transfer Pricing Rate Sheet s if no Reference ID is provided.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Transfer_Pricing_Rate_Sheets_RequestType $body
     * @return \StructType\Get_Transfer_Pricing_Rate_Sheets_ResponseType|bool
     */
    public function Get_Transfer_Pricing_Rate_Sheet(\StructType\Get_Transfer_Pricing_Rate_Sheets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Transfer_Pricing_Rate_Sheet($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Order_From_Supplier_Connections
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Order-From Supplier Connections for the specified Supplier criteria, The request criteria can be for a single supplier based on Reference, or all supplier connections can be retrieved if no criteria is
     * specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Order_From_Supplier_Connections_RequestType $body
     * @return \StructType\Get_Order_From_Supplier_Connections_ResponseType|bool
     */
    public function Get_Order_From_Supplier_Connections(\StructType\Get_Order_From_Supplier_Connections_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Order_From_Supplier_Connections($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requisition_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will retrieve Requisition Templates. Requisition Template Data includes Company, Template Name, Owned By, Document Date, Job Profile.The request criteria can be for a single Requisition Template based on
     * Reference IDs, multiple Requisition Templates based on search criteria, or all Requisition Templates if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requisition_Templates_RequestType $body
     * @return \StructType\Get_Requisition_Templates_ResponseType|bool
     */
    public function Get_Requisition_Templates(\StructType\Get_Requisition_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requisition_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Items
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Items for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Items_RequestType $body
     * @return \StructType\Get_Supplier_Items_ResponseType|bool
     */
    public function Get_Supplier_Items(\StructType\Get_Supplier_Items_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Items($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Revenue_Centers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Revenue Center for the specified criteria. Revenue Center data includes Revenue Center ID, Code, Active, Organization and Description. The request criteria can be for a single transaction based on
     * Reference, or all transaction can be retrieved if no criteria is specified.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Revenue_Centers_RequestType $body
     * @return \StructType\Get_Revenue_Centers_ResponseType|bool
     */
    public function Get_Revenue_Centers(\StructType\Get_Revenue_Centers_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Revenue_Centers($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Contract_Amendments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves supplier contract amendments records which includes header and line information. The request criteria can be for any number of supplier contract amendments by reference or the most recently created amendment for the
     * contract if no references are present.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Contract_Amendments_RequestType $body
     * @return \StructType\Get_Supplier_Contract_Amendments_ResponseType|bool
     */
    public function Get_Supplier_Contract_Amendments(\StructType\Get_Supplier_Contract_Amendments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Contract_Amendments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Invoice_Line_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enable retrieval of custom objects for the Supplier Invoice Line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Line_Additional_Data_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Line_Additional_Data_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Line_Additional_Data(\StructType\Get_Supplier_Invoice_Line_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Line_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Worker_Utilization_Target_Sheets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: The Web service operation retrieves and exports Worker Utilization Target Sheet and associated Utilization Target data, i.e., Utilization Target % defined for Utilization Target Rules or Workers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Worker_Utilization_Target_Sheets_RequestType $body
     * @return \StructType\Get_Worker_Utilization_Target_Sheets_ResponseType|bool
     */
    public function Get_Worker_Utilization_Target_Sheets(\StructType\Get_Worker_Utilization_Target_Sheets_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Worker_Utilization_Target_Sheets($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Purchase_Order_Lines_Additional_Data
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Enable retrieval of custom objects for the purchase order line.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Order_Lines_Additional_Data_RequestType $body
     * @return \StructType\Get_Purchase_Order_Lines_Additional_Data_ResponseType|bool
     */
    public function Get_Purchase_Order_Lines_Additional_Data(\StructType\Get_Purchase_Order_Lines_Additional_Data_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Order_Lines_Additional_Data($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Portfolios
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation provides Project Portfolios for the specified criteria. The request criteria can be for:1. A single transaction based on Reference or Project Portfolio Name.2. A set of transactions based on parent project
     * portfolio.3. All transactions, if criteria isn't specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Portfolios_RequestType $body
     * @return \StructType\Get_Project_Portfolios_ResponseType|bool
     */
    public function Get_Project_Portfolios(\StructType\Get_Project_Portfolios_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Portfolios($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Contract_Lease_Amendments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieve lease amendments for supplier contracts by search criteriaNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Contract_Lease_Amendments_RequestType $body
     * @return \StructType\Get_Supplier_Contract_Lease_Amendments_ResponseType|bool
     */
    public function Get_Supplier_Contract_Lease_Amendments(\StructType\Get_Supplier_Contract_Lease_Amendments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Contract_Lease_Amendments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Worktag_Split_Template_Restrictions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Worktag Split Template Restrictions for the specified restriction. Worktag Split Template Restrictions are used to filter Worktag Split Templates based on restriction selection. Worktag Split Template
     * Restriction data includes Worktag Split Template Criteria ID, Name, Description, and the Companies and Company Hierarchies it is restricted by. The request restriction can be for a single transaction based on Reference, or all transactions can be
     * retrieved if no restriction is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Worktag_Split_Template_Restrictions_RequestType $body
     * @return \StructType\Get_Worktag_Split_Template_Restrictions_ResponseType|bool
     */
    public function Get_Worktag_Split_Template_Restrictions(\StructType\Get_Worktag_Split_Template_Restrictions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Worktag_Split_Template_Restrictions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Worktag_Split_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Worktag Split Templates for the specified criteria.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Worktag_Split_Templates_RequestType $body
     * @return \StructType\Get_Worktag_Split_Templates_ResponseType|bool
     */
    public function Get_Worktag_Split_Templates(\StructType\Get_Worktag_Split_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Worktag_Split_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Project_Portfolios_without_Dependencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service retrieves Project Portfolios without dependent projects, and project portfolios data, enabling you to reimport data to other tenants.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Portfolios_without_Dependencies_RequestType $body
     * @return \StructType\Get_Project_Portfolios_without_Dependencies_ResponseType|bool
     */
    public function Get_Project_Portfolios_without_Dependencies(\StructType\Get_Project_Portfolios_without_Dependencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Portfolios_without_Dependencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Travel_Booking_Records
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves travel booking records that are based on defined parameters.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Travel_Booking_Records_RequestType $body
     * @return \StructType\Get_Travel_Booking_Records_ResponseType|bool
     */
    public function Get_Travel_Booking_Records(\StructType\Get_Travel_Booking_Records_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Travel_Booking_Records($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Receivable_Repayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Receivable Repayments for the specified criteria. Receivable Repayments are used to pay balances on expenses incurred by workers or applicants as an alternative to Recovery Expense Report.No
     * Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Receivable_Repayment_RequestType $body
     * @return \StructType\Get_Receivable_Repayment_ResponseType|bool
     */
    public function Get_Receivable_Repayment(\StructType\Get_Receivable_Repayment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Receivable_Repayment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Invoice_Lines
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Invoice Lines for the specified criteria. Supplier Invoice Lines data includes Supplier Invoice ID, Document Number, Company, PO Number, PO Line, PO Type. The request criteria can be for a
     * single transaction based on Reference, or all transaction can be retrieved if no criteria is specified. Supplier Invoices lines that are sourced to PO with external type are only retrieved.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Lines_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Lines_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Lines(\StructType\Get_Supplier_Invoice_Lines_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Lines($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Receipt_Adjustments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Receipt Adjustments for the specified criteria. Receipt Adjustment data includes Receipt Adjustment Number, Receipt, Company, Supplier, Document Date, Memo, Attachment data. For a Receipt Line, there
     * is a Purchase Order Line Reference, and Quantity Received.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Receipt_Adjustments_RequestType $body
     * @return \StructType\Get_Receipt_Adjustments_ResponseType|bool
     */
    public function Get_Receipt_Adjustments(\StructType\Get_Receipt_Adjustments_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Receipt_Adjustments($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Commodity_Code_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieve commodity code types by references, or retrieve all if no references are present.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Commodity_Code_Types_RequestType $body
     * @return \StructType\Get_Commodity_Code_Types_ResponseType|bool
     */
    public function Get_Commodity_Code_Types(\StructType\Get_Commodity_Code_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Commodity_Code_Types($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Invoice_Work_Queue_Tags
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get supplier invoice work queue tags for the specified criteria. Supplier invoice work queue tags are used for reporting and management of work flow. Supplier invoice work queue tag data includes name,
     * description, urgent boolean, and inactive boolean.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Work_Queue_Tags_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Work_Queue_Tags_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Work_Queue_Tags(\StructType\Get_Supplier_Invoice_Work_Queue_Tags_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Work_Queue_Tags($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Commodity_Codes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation will get Commodity Codes for the specified criteria. The request criteria can be for a specific Commodity Code based on a Reference ID or can include search criteria based on the following attributes -
     * Spend Categories, Parent Commodity CodesNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Commodity_Codes_RequestType $body
     * @return \StructType\Get_Commodity_Codes_ResponseType|bool
     */
    public function Get_Commodity_Codes(\StructType\Get_Commodity_Codes_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Commodity_Codes($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will retrieve all Supplier Invoice Work Queue Tag Assignment Rules or a single Supplier Invoice Work Queue Tag Assignment Rule based on ID.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules(\StructType\Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Project_Plans_without_Dependencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Get Project Plans without Dependencies WS TaskNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Plans_without_Dependencies_RequestType $body
     * @return \StructType\Get_Project_Plans_without_Dependencies_ResponseType|bool
     */
    public function Get_Project_Plans_without_Dependencies(\StructType\Get_Project_Plans_without_Dependencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Plans_without_Dependencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Invoice_Assignment_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This operation will retrieve all Supplier Invoice Assignment Rules or a single Supplier Invoice Assignment Rule based on ID.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_Assignment_Rules_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_Assignment_Rules_ResponseType|bool
     */
    public function Get_Supplier_Invoice_Assignment_Rules(\StructType\Get_Supplier_Invoice_Assignment_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_Assignment_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Assign_Supplier_to_Contingent_Worker
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves supplier for existing, already hired contingent workers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Assign_Supplier_to_Contingent_Worker_RequestType $body
     * @return \StructType\Get_Assign_Supplier_to_Contingent_Worker_ResponseType|bool
     */
    public function Get_Assign_Supplier_to_Contingent_Worker(\StructType\Get_Assign_Supplier_to_Contingent_Worker_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Assign_Supplier_to_Contingent_Worker($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Procurement_Conditional_Rules_Without_Dependencies
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve instances of Procurement Conditional Rules for a given Procurement Conditional Rules Context. The response contains the reference to the Procurement Conditional Rules Context and the items
     * that make up logic used in the the returned Procurement Conditional Rules. On the web service request, you can specify a specific reference to a Procurement Conditional Rules Context to return. If no context is provided, the response will include all
     * Procurement Conditional Rules Contexts and their corresponding Procurement Conditional Rules (if defined). Condition Rules can refer to other Condition Rules, creating a nested structure of rules. This operation will ONLY return the top-most
     * Condition Rules, and will not include any other rules referred to in the "Source Condition Rule" field.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Procurement_Conditional_Rules_Without_Dependencies_RequestType $body
     * @return \StructType\Get_Procurement_Conditional_Rules_Without_Dependencies_ResponseType|bool
     */
    public function Get_Procurement_Conditional_Rules_Without_Dependencies(\StructType\Get_Procurement_Conditional_Rules_Without_Dependencies_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Procurement_Conditional_Rules_Without_Dependencies($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Procurement_Conditional_Rules
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This web service operation will retrieve instances of Procurement Conditional Rules for a given Procurement Conditional Rules Context. The response contains the reference to the Procurement Conditional Rules Context and the items
     * that make up logic used in the the returned Procurement Conditional Rules. On the web service request, you can specify a specific reference to a Procurement Conditional Rules Context to return. If no context is provided, the response will include all
     * Procurement Conditional Rules Contexts and their corresponding Procurement Conditional Rules (if defined).No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Procurement_Conditional_Rules_RequestType $body
     * @return \StructType\Get_Procurement_Conditional_Rules_ResponseType|bool
     */
    public function Get_Procurement_Conditional_Rules(\StructType\Get_Procurement_Conditional_Rules_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Procurement_Conditional_Rules($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Project_Budget_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get the Project Budget Templates for the specified criteria. A Project Budget Template is used to define default budget plan lines for Project Budgets.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Project_Budget_Templates_RequestType $body
     * @return \StructType\Get_Project_Budget_Templates_ResponseType|bool
     */
    public function Get_Project_Budget_Templates(\StructType\Get_Project_Budget_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Project_Budget_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Purchase_Item_Request_Templates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves workbook templates for purchase item requests which enable you to configure the required item information before processing requests. You can select from these options of item information for purchase item request
     * templates:Purchase Item InformationSupplier Item InformationAdvanced PricingSupplier UOM and PricingNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Item_Request_Templates_RequestType $body
     * @return \StructType\Get_Purchase_Item_Request_Templates_ResponseType|bool
     */
    public function Get_Purchase_Item_Request_Templates(\StructType\Get_Purchase_Item_Request_Templates_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Item_Request_Templates($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Item_Request_Types
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves the request types for updating purchase item information. You can view the templates, questionnaires (optional), and the task associated to the purchase item request type.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Item_Request_Types_RequestType $body
     * @return \StructType\Get_Purchase_Item_Request_Types_ResponseType|bool
     */
    public function Get_Purchase_Item_Request_Types(\StructType\Get_Purchase_Item_Request_Types_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Item_Request_Types($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_External_Transaction_Sources
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get External Transaction Sources for the specified criteria.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_External_Transaction_Sources_RequestType $body
     * @return \StructType\Get_External_Transaction_Sources_ResponseType|bool
     */
    public function Get_External_Transaction_Sources(\StructType\Get_External_Transaction_Sources_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_External_Transaction_Sources($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Netting_Transactions
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Netting Transactions for the specified criteria. Netting Transaction data includes Netting Transaction ID, Submit Flag, Company, Currency, Netting Rule, Netting Transaction Date, Supplier Invoice Date
     * on or after Date, Supplier Invoice Date on or before Date, Customer Invoice Date on or after Date, Customer Invoice Date on or before Date, Attachment, Supplier Invoice Line Data and Customer Invoice Line Data. Supplier Invoice Line Data includes
     * Supplier Invoice ID, Amount to Net, and Amount Netted. Customer Invoice Line Data includes Customer Invoice ID, Amount to Net and Amount Netted. The request criteria can be for a single transaction based on Reference, or all transaction can be
     * retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Netting_Transactions_RequestType $body
     * @return \StructType\Get_Netting_Transactions_ResponseType|bool
     */
    public function Get_Netting_Transactions(\StructType\Get_Netting_Transactions_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Netting_Transactions($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Supplier_Refunds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Supplier Refund Transactions for the specified request criteria. You can submit Reference information to the request criteria to get a single transaction or leave the request criteria blank to get all
     * transactions.The Supplier Refund transactions include Supplier Refund Number, Supplier, Company, Currency, Application Date, Memo, Supplier Refund Amount, Attachment, Supplier Invoice Adjustments Data. The Supplier Invoice Adjustment data includes
     * Supplier Invoice Adjustment ID, Invoice Date, Invoice Amount, Amount Due, Amount Applied, and Amount Due Remaining.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Refunds_RequestType $body
     * @return \StructType\Get_Supplier_Refunds_ResponseType|bool
     */
    public function Get_Supplier_Refunds(\StructType\Get_Supplier_Refunds_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Refunds($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Requesting_Entities
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Requesting entities that have access to requisition restricted purchase items or restricted purchase item lists.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Requesting_Entities_RequestType $body
     * @return \StructType\Get_Requesting_Entities_ResponseType|bool
     */
    public function Get_Requesting_Entities(\StructType\Get_Requesting_Entities_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Requesting_Entities($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Purchase_Item_Lists
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Retrieves purchase item list or lists and displays name, inactive, related purchase items and related requesting entitiesNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Purchase_Item_Lists_RequestType $body
     * @return \StructType\Get_Purchase_Item_Lists_ResponseType|bool
     */
    public function Get_Purchase_Item_Lists(\StructType\Get_Purchase_Item_Lists_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Purchase_Item_Lists($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Web_Item_Attributes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web Service operation will get Web Items for the specified criteria. The request criteria can be for a specific Web Item based on a Reference ID or can include search criteria based on Suppliers.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Web_Item_Attributes_RequestType $body
     * @return \StructType\Get_Web_Item_Attributes_ResponseType|bool
     */
    public function Get_Web_Item_Attributes(\StructType\Get_Web_Item_Attributes_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Web_Item_Attributes($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_External_Business_Entity_Contact
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will get Get External Business Entity Contacts for the specified criteria. The data includes the Business Entity Contact ID, the Business Entity the Contact is for (Supplier, Customer, Financial Institution or
     * Tax Authority), the Personal Data including Name Detail data and Contact Information data. Name Detail data includes formatted Name, Country, Prefix, First Name, Middle Name, Last Name, Secondary Last Name, and Name Suffix. Contact Information data
     * includes Address, Phone, Email, Instance Messenger and Web Address data. The request criteria can be for a single transaction based on Reference, or all transactions can be retrieved if no criteria is specified.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_External_Business_Entity_Contact_RequestType $body
     * @return \StructType\Get_External_Business_Entity_Contacts_ResponseType|bool
     */
    public function Get_External_Business_Entity_Contact(\StructType\Get_External_Business_Entity_Contact_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_External_Business_Entity_Contact($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Get_Supplier_Invoice_System_Validation_Configuration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service allows you to get the Supplier Invoice System Validation Configurations.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Supplier_Invoice_System_Validation_Configuration_RequestType $body
     * @return \StructType\Get_Supplier_Invoice_System_Validation_Configuration_ResponseType|bool
     */
    public function Get_Supplier_Invoice_System_Validation_Configuration(\StructType\Get_Supplier_Invoice_System_Validation_Configuration_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Supplier_Invoice_System_Validation_Configuration($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get_Carriers
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Use this web service operation to retrieve Carrier information.No
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Get_Carriers_RequestType $body
     * @return \StructType\Get_Carriers_ResponseType|bool
     */
    public function Get_Carriers(\StructType\Get_Carriers_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Get_Carriers($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Get_Advanced_Ship_Notices_ResponseType|\StructType\Get_Airlines_ResponseType|\StructType\Get_Airports_ResponseType|\StructType\Get_Assets_ResponseType|\StructType\Get_Asset_Book_Configurations_ResponseType|\StructType\Get_Asset_Book_Rules_ResponseType|\StructType\Get_Asset_Pooling_Rules_ResponseType|\StructType\Get_Asset_Shares_ResponseType|\StructType\Get_Assign_Supplier_to_Contingent_Worker_ResponseType|\StructType\Get_Business_Entity_Contacts_ResponseType|\StructType\Get_Card_Holder_Listing_Files_ResponseType|\StructType\Get_Carriers_ResponseType|\StructType\Get_Car_Rental_Agencies_ResponseType|\StructType\Get_Cash_Advance_Repayments_ResponseType|\StructType\Get_Catalog_Items_ResponseType|\StructType\Get_Catalog_Loads_ResponseType|\StructType\Get_Commodity_Codes_ResponseType|\StructType\Get_Commodity_Code_Types_ResponseType|\StructType\Get_Company_Asset_Book_Restrictions_ResponseType|\StructType\Get_Corporate_Credit_Card_Billing_Accounts_ResponseType|\StructType\Get_Credit_Card_Code_Mappings_ResponseType|\StructType\Get_Credit_Card_Transaction_Files_ResponseType|\StructType\Get_Expense_Company_Defaults_ResponseType|\StructType\Get_Expense_Credit_Cards_ResponseType|\StructType\Get_Expense_Credit_Card_Transactions_ResponseType|\StructType\Get_Expense_Items_ResponseType|\StructType\Get_Expense_Item_Attribute_Groups_ResponseType|\StructType\Get_Expense_Item_Groups_ResponseType|\StructType\Get_Expense_Policy_Groups_ResponseType|\StructType\Get_Expense_Rate_Tables_ResponseType|\StructType\Get_Expense_Rate_Table_Rules_ResponseType|\StructType\Get_Expense_Reports_ResponseType|\StructType\Get_External_Business_Entity_Contacts_ResponseType|\StructType\Get_External_Transaction_Sources_ResponseType|\StructType\Get_Guests_ResponseType|\StructType\Get_Guest_Listing_Files_ResponseType|\StructType\Get_Hotels_ResponseType|\StructType\Get_Internal_Catalogs_ResponseType|\StructType\Get_Internal_Service_Deliveries_ResponseType|\StructType\Get_Internal_Service_Providers_ResponseType|\StructType\Get_Invoice_Types_ResponseType|\StructType\Get_Item_Identifier_Types_ResponseType|\StructType\Get_Item_Tags_ResponseType|\StructType\Get_Location_Customer_Account_Number_Details_ResponseType|\StructType\Get_Netting_Transactions_ResponseType|\StructType\Get_Order_From_Supplier_Connections_ResponseType|\StructType\Get_Payroll_Timesheets_Time_In_Time_Out_ResponseType|\StructType\Get_Payroll_Timesheets_Total_Hours_ResponseType|\StructType\Get_Prepaid_Spend_Amortizations_ResponseType|\StructType\Get_Prepaid_Spend_Amortization_Schedules_ResponseType|\StructType\Get_Procurement_Card_Transaction_Verifications_ResponseType|\StructType\Get_Procurement_Conditional_Rules_ResponseType|\StructType\Get_Procurement_Conditional_Rules_Without_Dependencies_ResponseType|\StructType\Get_Procurement_Mass_Close_ResponseType|\StructType\Get_Projects_ResponseType|\StructType\Get_Project_Asset_ResponseType|\StructType\Get_Project_Budget_Templates_ResponseType|\StructType\Get_Project_Phases_ResponseType|\StructType\Get_Project_Plans_ResponseType|\StructType\Get_Project_Plans_without_Dependencies_ResponseType|\StructType\Get_Project_Plan_Templates_ResponseType|\StructType\Get_Project_Portfolios_ResponseType|\StructType\Get_Project_Portfolios_without_Dependencies_ResponseType|\StructType\Get_Project_Role_Categories_ResponseType|\StructType\Get_Project_Standard_Cost_Rate_Sheets_ResponseType|\StructType\Get_Project_Tasks_ResponseType|\StructType\Get_Project_Task_Resources_ResponseType|\StructType\Get_Project_Templates_ResponseType|\StructType\Get_Project_Timesheets_ResponseType|\StructType\Get_Project_Worker_Roles_ResponseType|\StructType\Get_Purchase_Items_ResponseType|\StructType\Get_Purchase_Item_Groups_ResponseType|\StructType\Get_Purchase_Item_Lists_ResponseType|\StructType\Get_Purchase_Item_Request_Templates_ResponseType|\StructType\Get_Purchase_Item_Request_Types_ResponseType|\StructType\Get_Purchase_Orders_ResponseType|\StructType\Get_Purchase_Order_Acknowledgements_ResponseType|\StructType\Get_Purchase_Order_Change_Orders_ResponseType|\StructType\Get_Purchase_Order_Lines_Additional_Data_ResponseType|\StructType\Get_Purchase_Order_Schedules_ResponseType|\StructType\Get_Receipts_ResponseType|\StructType\Get_Receipt_Adjustments_ResponseType|\StructType\Get_Receivable_Repayment_ResponseType|\StructType\Get_Remit_To_Supplier_Connections_ResponseType|\StructType\Get_Requesting_Entities_ResponseType|\StructType\Get_Request_for_Quote_Awards_ResponseType|\StructType\Get_Request_for_Quote_Responses_ResponseType|\StructType\Get_Request_for_Quote_ResponseType|\StructType\Get_Requirements_for_Resource_Plan_ResponseType|\StructType\Get_Requisitions_ResponseType|\StructType\Get_Requisition_Additional_Data_ResponseType|\StructType\Get_Requisition_Line_Additional_Data_ResponseType|\StructType\Get_Requisition_Sourcing_Rules_ResponseType|\StructType\Get_Requisition_Templates_ResponseType|\StructType\Get_Resource_Categories_ResponseType|\StructType\Get_Resource_Forecasts_ResponseType|\StructType\Get_Resource_Plans_ResponseType|\StructType\Get_Resource_Plan_Templates_ResponseType|\StructType\Get_Resource_Pools_ResponseType|\StructType\Get_Resource_Pool_Hierarchies_ResponseType|\StructType\Get_Resource_Pool_Hierarchies_without_Dependencies_ResponseType|\StructType\Get_Returns_ResponseType|\StructType\Get_Revenue_Centers_ResponseType|\StructType\Get_Spend_Authorizations_ResponseType|\StructType\Get_Spend_Category_Hierarchies_ResponseType|\StructType\Get_Suppliers_ResponseType|\StructType\Get_Supplier_Catalogs_ResponseType|\StructType\Get_Supplier_Categories_ResponseType|\StructType\Get_Supplier_Classifications_ResponseType|\StructType\Get_Supplier_Contact_Information_ResponseType|\StructType\Get_Supplier_Contracts_ResponseType|\StructType\Get_Supplier_Contract_Amendments_ResponseType|\StructType\Get_Supplier_Contract_Lease_Amendments_ResponseType|\StructType\Get_Supplier_Groups_ResponseType|\StructType\Get_Supplier_Invoices_ResponseType|\StructType\Get_Supplier_Invoice_Adjustments_ResponseType|\StructType\Get_Supplier_Invoice_Assignment_Rules_ResponseType|\StructType\Get_Supplier_Invoice_Histories_ResponseType|\StructType\Get_Supplier_Invoice_Lines_ResponseType|\StructType\Get_Supplier_Invoice_Line_Additional_Data_ResponseType|\StructType\Get_Supplier_Invoice_Requests_ResponseType|\StructType\Get_Supplier_Invoice_Schedules_ResponseType|\StructType\Get_Supplier_Invoice_System_Validation_Configuration_ResponseType|\StructType\Get_Supplier_Invoice_Work_Queue_Tags_ResponseType|\StructType\Get_Supplier_Invoice_Work_Queue_Tag_Assignment_Rules_ResponseType|\StructType\Get_Supplier_Items_ResponseType|\StructType\Get_Supplier_Order_Contracts_ResponseType|\StructType\Get_Supplier_Refunds_ResponseType|\StructType\Get_Timesheets_ResponseType|\StructType\Get_Transfer_Pricing_Rate_Sheets_ResponseType|\StructType\Get_Travel_Booking_Files_ResponseType|\StructType\Get_Travel_Booking_Records_ResponseType|\StructType\Get_Travel_Cities_ResponseType|\StructType\Get_Travel_Profiles_ResponseType|\StructType\Get_Web_Item_Attributes_ResponseType|\StructType\Get_Workday_Project_Hierarchies_ResponseType|\StructType\Get_Workday_Project_Hierarchies_without_Dependencies_ResponseType|\StructType\Get_Worker_Travel_Profile_Listing_Files_ResponseType|\StructType\Get_Worker_Utilization_Target_Sheets_ResponseType|\StructType\Get_Worktag_Split_Templates_ResponseType|\StructType\Get_Worktag_Split_Template_Restrictions_ResponseType|\StructType\Issue_Purchase_Order_OutboundType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
