<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_City_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Travel City request criteria
 * @subpackage Structs
 */
class Travel_City_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: Country Reference
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Travel_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Travel Region.
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Travel_Region_Reference;
    /**
     * Constructor method for Travel_City_Request_CriteriaType
     * @uses Travel_City_Request_CriteriaType::setCountry_Reference()
     * @uses Travel_City_Request_CriteriaType::setTravel_Region_Reference()
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     */
    public function __construct(\StructType\CountryObjectType $country_Reference = null, \StructType\Country_RegionObjectType $travel_Region_Reference = null)
    {
        $this
            ->setCountry_Reference($country_Reference)
            ->setTravel_Region_Reference($travel_Region_Reference);
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Travel_City_Request_CriteriaType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Travel_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getTravel_Region_Reference()
    {
        return $this->Travel_Region_Reference;
    }
    /**
     * Set Travel_Region_Reference value
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     * @return \StructType\Travel_City_Request_CriteriaType
     */
    public function setTravel_Region_Reference(\StructType\Country_RegionObjectType $travel_Region_Reference = null)
    {
        $this->Travel_Region_Reference = $travel_Region_Reference;
        return $this;
    }
}
