<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_ItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Item Reference and Data
 * @subpackage Structs
 */
class Supplier_ItemType extends AbstractStructBase
{
    /**
     * The Supplier_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Supplier Item
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Details_AbstractObjectType
     */
    public $Supplier_Item_Reference;
    /**
     * The Supplier_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Item_Price_Update__HV__DataType[]
     */
    public $Supplier_Item_Data;
    /**
     * Constructor method for Supplier_ItemType
     * @uses Supplier_ItemType::setSupplier_Item_Reference()
     * @uses Supplier_ItemType::setSupplier_Item_Data()
     * @param \StructType\Supplier_Item_Details_AbstractObjectType $supplier_Item_Reference
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType[] $supplier_Item_Data
     */
    public function __construct(\StructType\Supplier_Item_Details_AbstractObjectType $supplier_Item_Reference = null, array $supplier_Item_Data = array())
    {
        $this
            ->setSupplier_Item_Reference($supplier_Item_Reference)
            ->setSupplier_Item_Data($supplier_Item_Data);
    }
    /**
     * Get Supplier_Item_Reference value
     * @return \StructType\Supplier_Item_Details_AbstractObjectType|null
     */
    public function getSupplier_Item_Reference()
    {
        return $this->Supplier_Item_Reference;
    }
    /**
     * Set Supplier_Item_Reference value
     * @param \StructType\Supplier_Item_Details_AbstractObjectType $supplier_Item_Reference
     * @return \StructType\Supplier_ItemType
     */
    public function setSupplier_Item_Reference(\StructType\Supplier_Item_Details_AbstractObjectType $supplier_Item_Reference = null)
    {
        $this->Supplier_Item_Reference = $supplier_Item_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Data value
     * @return \StructType\Supplier_Item_Price_Update__HV__DataType[]|null
     */
    public function getSupplier_Item_Data()
    {
        return $this->Supplier_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_ItemTypeSupplier_Item_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_ItemTypeSupplier_Item_DataItem instanceof \StructType\Supplier_Item_Price_Update__HV__DataType) {
                $invalidValues[] = is_object($supplier_ItemTypeSupplier_Item_DataItem) ? get_class($supplier_ItemTypeSupplier_Item_DataItem) : sprintf('%s(%s)', gettype($supplier_ItemTypeSupplier_Item_DataItem), var_export($supplier_ItemTypeSupplier_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Supplier_Item_Price_Update__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType[] $supplier_Item_Data
     * @return \StructType\Supplier_ItemType
     */
    public function setSupplier_Item_Data(array $supplier_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Item_DataArrayErrorMessage = self::validateSupplier_Item_DataForArrayConstraintsFromSetSupplier_Item_Data($supplier_Item_Data))) {
            throw new \InvalidArgumentException($supplier_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item_Data = $supplier_Item_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Item_Price_Update__HV__DataType $item
     * @return \StructType\Supplier_ItemType
     */
    public function addToSupplier_Item_Data(\StructType\Supplier_Item_Price_Update__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Item_Price_Update__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item_Data property can only contain items of type \StructType\Supplier_Item_Price_Update__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item_Data[] = $item;
        return $this;
    }
}
