<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Authorization_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Spend Authorization response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Spend_Authorization_Response_DataType extends AbstractStructBase
{
    /**
     * The Spend_Authorization
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes spend authorization instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_AuthorizationType[]
     */
    public $Spend_Authorization;
    /**
     * Constructor method for Spend_Authorization_Response_DataType
     * @uses Spend_Authorization_Response_DataType::setSpend_Authorization()
     * @param \StructType\Spend_AuthorizationType[] $spend_Authorization
     */
    public function __construct(array $spend_Authorization = array())
    {
        $this
            ->setSpend_Authorization($spend_Authorization);
    }
    /**
     * Get Spend_Authorization value
     * @return \StructType\Spend_AuthorizationType[]|null
     */
    public function getSpend_Authorization()
    {
        return $this->Spend_Authorization;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Authorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Authorization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_AuthorizationForArrayConstraintsFromSetSpend_Authorization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Authorization_Response_DataTypeSpend_AuthorizationItem) {
            // validation for constraint: itemType
            if (!$spend_Authorization_Response_DataTypeSpend_AuthorizationItem instanceof \StructType\Spend_AuthorizationType) {
                $invalidValues[] = is_object($spend_Authorization_Response_DataTypeSpend_AuthorizationItem) ? get_class($spend_Authorization_Response_DataTypeSpend_AuthorizationItem) : sprintf('%s(%s)', gettype($spend_Authorization_Response_DataTypeSpend_AuthorizationItem), var_export($spend_Authorization_Response_DataTypeSpend_AuthorizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Authorization property can only contain items of type \StructType\Spend_AuthorizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_AuthorizationType[] $spend_Authorization
     * @return \StructType\Spend_Authorization_Response_DataType
     */
    public function setSpend_Authorization(array $spend_Authorization = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_AuthorizationArrayErrorMessage = self::validateSpend_AuthorizationForArrayConstraintsFromSetSpend_Authorization($spend_Authorization))) {
            throw new \InvalidArgumentException($spend_AuthorizationArrayErrorMessage, __LINE__);
        }
        $this->Spend_Authorization = $spend_Authorization;
        return $this;
    }
    /**
     * Add item to Spend_Authorization value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_AuthorizationType $item
     * @return \StructType\Spend_Authorization_Response_DataType
     */
    public function addToSpend_Authorization(\StructType\Spend_AuthorizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_AuthorizationType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Authorization property can only contain items of type \StructType\Spend_AuthorizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Authorization[] = $item;
        return $this;
    }
}
