<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restricted_Purchase_Item_ListObjectType StructType
 * @subpackage Structs
 */
class Restricted_Purchase_Item_ListObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restricted_Purchase_Item_ListObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Restricted_Purchase_Item_ListObjectType
     * @uses Restricted_Purchase_Item_ListObjectType::setID()
     * @uses Restricted_Purchase_Item_ListObjectType::setDescriptor()
     * @param \StructType\Restricted_Purchase_Item_ListObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Restricted_Purchase_Item_ListObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_ListObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_ListObjectTypeIDItem instanceof \StructType\Restricted_Purchase_Item_ListObjectIDType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_ListObjectTypeIDItem) ? get_class($restricted_Purchase_Item_ListObjectTypeIDItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_ListObjectTypeIDItem), var_export($restricted_Purchase_Item_ListObjectTypeIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectIDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectIDType[] $iD
     * @return \StructType\Restricted_Purchase_Item_ListObjectType
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectIDType $item
     * @return \StructType\Restricted_Purchase_Item_ListObjectType
     */
    public function addToID(\StructType\Restricted_Purchase_Item_ListObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_ListObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectIDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Restricted_Purchase_Item_ListObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptor, true), gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
}
