<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Detail_for_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains project resource plan detail template information, such as worker, percent allocation, currency, etc.
 * @subpackage Structs
 */
class Resource_Plan_Detail_for_Template_DataType extends AbstractStructBase
{
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: If true, the resource plan line in the resource plan template is to be deleted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Delete;
    /**
     * The Resource_Plan_Detail_for_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Detail ID. This is the project resource plan detail unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_Detail_for_Template_ID;
    /**
     * The Project_Role_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project role associated to the resource plan line in the resource plan template.
     * - minOccurs: 0
     * @var \StructType\Project_RoleObjectType
     */
    public $Project_Role_Reference;
    /**
     * The Project_Role_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project role category associated to the resource plan line in the resource plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Role_CategoryObjectType
     */
    public $Project_Role_Category_Reference;
    /**
     * The Start_Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: The start date offset for the project plan template. | The start date offset associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Start_Date_Offset;
    /**
     * The End_Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: The end date offset for the project plan template. | The end date offset associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $End_Date_Offset;
    /**
     * The isAssociation
     * Meta information extracted from the WSDL
     * - documentation: If true, resource type is 'association' for the resource plan line in the resource plan template, otherwise, resource type is 'assignment'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isAssociation;
    /**
     * The Add_Additional_Unnamed_Resources
     * Meta information extracted from the WSDL
     * - documentation: Specify the quantity of additional unnamed resources to create. | Adds the number of unnamed resources in sequence of unnamed resources specified for "Unnamed Resources"
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Add_Additional_Unnamed_Resources;
    /**
     * The Unnamed_Resource_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing unnamed resource data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType[]
     */
    public $Unnamed_Resource_Data;
    /**
     * The isToBeHired
     * Meta information extracted from the WSDL
     * - documentation: If true, the assigned worker is to be hired for the resource plan line in the resource plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isToBeHired;
    /**
     * The Percent_Allocation
     * Meta information extracted from the WSDL
     * - documentation: % Allocation for the Project Task Resource | Percent Allocation | Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Percent_Allocation;
    /**
     * The Estimated_Hours
     * Meta information extracted from the WSDL
     * - documentation: Estimated Hours for the Project Task Resource | Estimated Hours | The estimated hours associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Estimated_Hours;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: The memo details associated to the resource plan line in the resource plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Project_Booking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The project booking status associated to the resource plan line in the resource plan template.
     * - minOccurs: 0
     * @var \StructType\Project_Booking_StatusObjectType
     */
    public $Project_Booking_Status_Reference;
    /**
     * The Worker_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worker group associated to the resource plan line in the resource plan template if ‘association’ type is true. A worker group can be a Job Profile, Resource Pool, Cost Center, or Talent Pool.
     * - minOccurs: 0
     * @var \StructType\Project_Member_ResourceObjectType
     */
    public $Worker_Group_Reference;
    /**
     * The Standard_Cost_Rate
     * Meta information extracted from the WSDL
     * - documentation: Standard Cost Rate | The standard cost rate override associated to the resource plan line in the resource plan template.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Standard_Cost_Rate;
    /**
     * The Standard_Cost_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The standard cost rate currency override associated to the resource plan line in the resource plan template.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Standard_Cost_Currency_Reference;
    /**
     * Constructor method for Resource_Plan_Detail_for_Template_DataType
     * @uses Resource_Plan_Detail_for_Template_DataType::setDelete()
     * @uses Resource_Plan_Detail_for_Template_DataType::setResource_Plan_Detail_for_Template_ID()
     * @uses Resource_Plan_Detail_for_Template_DataType::setProject_Role_Reference()
     * @uses Resource_Plan_Detail_for_Template_DataType::setProject_Role_Category_Reference()
     * @uses Resource_Plan_Detail_for_Template_DataType::setStart_Date_Offset()
     * @uses Resource_Plan_Detail_for_Template_DataType::setEnd_Date_Offset()
     * @uses Resource_Plan_Detail_for_Template_DataType::setIsAssociation()
     * @uses Resource_Plan_Detail_for_Template_DataType::setAdd_Additional_Unnamed_Resources()
     * @uses Resource_Plan_Detail_for_Template_DataType::setUnnamed_Resource_Data()
     * @uses Resource_Plan_Detail_for_Template_DataType::setIsToBeHired()
     * @uses Resource_Plan_Detail_for_Template_DataType::setPercent_Allocation()
     * @uses Resource_Plan_Detail_for_Template_DataType::setEstimated_Hours()
     * @uses Resource_Plan_Detail_for_Template_DataType::setMemo()
     * @uses Resource_Plan_Detail_for_Template_DataType::setProject_Booking_Status_Reference()
     * @uses Resource_Plan_Detail_for_Template_DataType::setWorker_Group_Reference()
     * @uses Resource_Plan_Detail_for_Template_DataType::setStandard_Cost_Rate()
     * @uses Resource_Plan_Detail_for_Template_DataType::setStandard_Cost_Currency_Reference()
     * @param bool $delete
     * @param string $resource_Plan_Detail_for_Template_ID
     * @param \StructType\Project_RoleObjectType $project_Role_Reference
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @param float $start_Date_Offset
     * @param float $end_Date_Offset
     * @param bool $isAssociation
     * @param float $add_Additional_Unnamed_Resources
     * @param \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType[] $unnamed_Resource_Data
     * @param bool $isToBeHired
     * @param float $percent_Allocation
     * @param float $estimated_Hours
     * @param string $memo
     * @param \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference
     * @param \StructType\Project_Member_ResourceObjectType $worker_Group_Reference
     * @param float $standard_Cost_Rate
     * @param \StructType\CurrencyObjectType $standard_Cost_Currency_Reference
     */
    public function __construct($delete = null, $resource_Plan_Detail_for_Template_ID = null, \StructType\Project_RoleObjectType $project_Role_Reference = null, \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null, $start_Date_Offset = null, $end_Date_Offset = null, $isAssociation = null, $add_Additional_Unnamed_Resources = null, array $unnamed_Resource_Data = array(), $isToBeHired = null, $percent_Allocation = null, $estimated_Hours = null, $memo = null, \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference = null, \StructType\Project_Member_ResourceObjectType $worker_Group_Reference = null, $standard_Cost_Rate = null, \StructType\CurrencyObjectType $standard_Cost_Currency_Reference = null)
    {
        $this
            ->setDelete($delete)
            ->setResource_Plan_Detail_for_Template_ID($resource_Plan_Detail_for_Template_ID)
            ->setProject_Role_Reference($project_Role_Reference)
            ->setProject_Role_Category_Reference($project_Role_Category_Reference)
            ->setStart_Date_Offset($start_Date_Offset)
            ->setEnd_Date_Offset($end_Date_Offset)
            ->setIsAssociation($isAssociation)
            ->setAdd_Additional_Unnamed_Resources($add_Additional_Unnamed_Resources)
            ->setUnnamed_Resource_Data($unnamed_Resource_Data)
            ->setIsToBeHired($isToBeHired)
            ->setPercent_Allocation($percent_Allocation)
            ->setEstimated_Hours($estimated_Hours)
            ->setMemo($memo)
            ->setProject_Booking_Status_Reference($project_Booking_Status_Reference)
            ->setWorker_Group_Reference($worker_Group_Reference)
            ->setStandard_Cost_Rate($standard_Cost_Rate)
            ->setStandard_Cost_Currency_Reference($standard_Cost_Currency_Reference);
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
    /**
     * Get Resource_Plan_Detail_for_Template_ID value
     * @return string|null
     */
    public function getResource_Plan_Detail_for_Template_ID()
    {
        return $this->Resource_Plan_Detail_for_Template_ID;
    }
    /**
     * Set Resource_Plan_Detail_for_Template_ID value
     * @param string $resource_Plan_Detail_for_Template_ID
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setResource_Plan_Detail_for_Template_ID($resource_Plan_Detail_for_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_Detail_for_Template_ID) && !is_string($resource_Plan_Detail_for_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_Detail_for_Template_ID, true), gettype($resource_Plan_Detail_for_Template_ID)), __LINE__);
        }
        $this->Resource_Plan_Detail_for_Template_ID = $resource_Plan_Detail_for_Template_ID;
        return $this;
    }
    /**
     * Get Project_Role_Reference value
     * @return \StructType\Project_RoleObjectType|null
     */
    public function getProject_Role_Reference()
    {
        return $this->Project_Role_Reference;
    }
    /**
     * Set Project_Role_Reference value
     * @param \StructType\Project_RoleObjectType $project_Role_Reference
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setProject_Role_Reference(\StructType\Project_RoleObjectType $project_Role_Reference = null)
    {
        $this->Project_Role_Reference = $project_Role_Reference;
        return $this;
    }
    /**
     * Get Project_Role_Category_Reference value
     * @return \StructType\Project_Role_CategoryObjectType|null
     */
    public function getProject_Role_Category_Reference()
    {
        return $this->Project_Role_Category_Reference;
    }
    /**
     * Set Project_Role_Category_Reference value
     * @param \StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setProject_Role_Category_Reference(\StructType\Project_Role_CategoryObjectType $project_Role_Category_Reference = null)
    {
        $this->Project_Role_Category_Reference = $project_Role_Category_Reference;
        return $this;
    }
    /**
     * Get Start_Date_Offset value
     * @return float|null
     */
    public function getStart_Date_Offset()
    {
        return $this->Start_Date_Offset;
    }
    /**
     * Set Start_Date_Offset value
     * @param float $start_Date_Offset
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setStart_Date_Offset($start_Date_Offset = null)
    {
        // validation for constraint: float
        if (!is_null($start_Date_Offset) && !(is_float($start_Date_Offset) || is_numeric($start_Date_Offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($start_Date_Offset, true), gettype($start_Date_Offset)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($start_Date_Offset) && mb_strlen(mb_substr($start_Date_Offset, false !== mb_strpos($start_Date_Offset, '.') ? mb_strpos($start_Date_Offset, '.') + 1 : mb_strlen($start_Date_Offset))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($start_Date_Offset, true), mb_strlen(mb_substr($start_Date_Offset, mb_strpos($start_Date_Offset, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($start_Date_Offset) && $start_Date_Offset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($start_Date_Offset, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($start_Date_Offset) && mb_strlen(preg_replace('/(\D)/', '', $start_Date_Offset)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($start_Date_Offset, true), mb_strlen(preg_replace('/(\D)/', '', $start_Date_Offset))), __LINE__);
        }
        $this->Start_Date_Offset = $start_Date_Offset;
        return $this;
    }
    /**
     * Get End_Date_Offset value
     * @return float|null
     */
    public function getEnd_Date_Offset()
    {
        return $this->End_Date_Offset;
    }
    /**
     * Set End_Date_Offset value
     * @param float $end_Date_Offset
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setEnd_Date_Offset($end_Date_Offset = null)
    {
        // validation for constraint: float
        if (!is_null($end_Date_Offset) && !(is_float($end_Date_Offset) || is_numeric($end_Date_Offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($end_Date_Offset, true), gettype($end_Date_Offset)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($end_Date_Offset) && mb_strlen(mb_substr($end_Date_Offset, false !== mb_strpos($end_Date_Offset, '.') ? mb_strpos($end_Date_Offset, '.') + 1 : mb_strlen($end_Date_Offset))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($end_Date_Offset, true), mb_strlen(mb_substr($end_Date_Offset, mb_strpos($end_Date_Offset, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($end_Date_Offset) && $end_Date_Offset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($end_Date_Offset, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($end_Date_Offset) && mb_strlen(preg_replace('/(\D)/', '', $end_Date_Offset)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($end_Date_Offset, true), mb_strlen(preg_replace('/(\D)/', '', $end_Date_Offset))), __LINE__);
        }
        $this->End_Date_Offset = $end_Date_Offset;
        return $this;
    }
    /**
     * Get isAssociation value
     * @return bool|null
     */
    public function getIsAssociation()
    {
        return $this->isAssociation;
    }
    /**
     * Set isAssociation value
     * @param bool $isAssociation
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setIsAssociation($isAssociation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssociation) && !is_bool($isAssociation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssociation, true), gettype($isAssociation)), __LINE__);
        }
        $this->isAssociation = $isAssociation;
        return $this;
    }
    /**
     * Get Add_Additional_Unnamed_Resources value
     * @return float|null
     */
    public function getAdd_Additional_Unnamed_Resources()
    {
        return $this->Add_Additional_Unnamed_Resources;
    }
    /**
     * Set Add_Additional_Unnamed_Resources value
     * @param float $add_Additional_Unnamed_Resources
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setAdd_Additional_Unnamed_Resources($add_Additional_Unnamed_Resources = null)
    {
        // validation for constraint: float
        if (!is_null($add_Additional_Unnamed_Resources) && !(is_float($add_Additional_Unnamed_Resources) || is_numeric($add_Additional_Unnamed_Resources))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($add_Additional_Unnamed_Resources, true), gettype($add_Additional_Unnamed_Resources)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($add_Additional_Unnamed_Resources) && mb_strlen(mb_substr($add_Additional_Unnamed_Resources, false !== mb_strpos($add_Additional_Unnamed_Resources, '.') ? mb_strpos($add_Additional_Unnamed_Resources, '.') + 1 : mb_strlen($add_Additional_Unnamed_Resources))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($add_Additional_Unnamed_Resources, true), mb_strlen(mb_substr($add_Additional_Unnamed_Resources, mb_strpos($add_Additional_Unnamed_Resources, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($add_Additional_Unnamed_Resources) && $add_Additional_Unnamed_Resources < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($add_Additional_Unnamed_Resources, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($add_Additional_Unnamed_Resources) && mb_strlen(preg_replace('/(\D)/', '', $add_Additional_Unnamed_Resources)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($add_Additional_Unnamed_Resources, true), mb_strlen(preg_replace('/(\D)/', '', $add_Additional_Unnamed_Resources))), __LINE__);
        }
        $this->Add_Additional_Unnamed_Resources = $add_Additional_Unnamed_Resources;
        return $this;
    }
    /**
     * Get Unnamed_Resource_Data value
     * @return \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType[]|null
     */
    public function getUnnamed_Resource_Data()
    {
        return $this->Unnamed_Resource_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setUnnamed_Resource_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnnamed_Resource_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUnnamed_Resource_DataForArrayConstraintsFromSetUnnamed_Resource_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem instanceof \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType) {
                $invalidValues[] = is_object($resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem) ? get_class($resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem), var_export($resource_Plan_Detail_for_Template_DataTypeUnnamed_Resource_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Unnamed_Resource_Data property can only contain items of type \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Unnamed_Resource_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType[] $unnamed_Resource_Data
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setUnnamed_Resource_Data(array $unnamed_Resource_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($unnamed_Resource_DataArrayErrorMessage = self::validateUnnamed_Resource_DataForArrayConstraintsFromSetUnnamed_Resource_Data($unnamed_Resource_Data))) {
            throw new \InvalidArgumentException($unnamed_Resource_DataArrayErrorMessage, __LINE__);
        }
        $this->Unnamed_Resource_Data = $unnamed_Resource_Data;
        return $this;
    }
    /**
     * Add item to Unnamed_Resource_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType $item
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function addToUnnamed_Resource_Data(\StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType) {
            throw new \InvalidArgumentException(sprintf('The Unnamed_Resource_Data property can only contain items of type \StructType\Unnamed_Resource_WWS_Data_for_Resource_Plan_TemplateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Unnamed_Resource_Data[] = $item;
        return $this;
    }
    /**
     * Get isToBeHired value
     * @return bool|null
     */
    public function getIsToBeHired()
    {
        return $this->isToBeHired;
    }
    /**
     * Set isToBeHired value
     * @param bool $isToBeHired
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setIsToBeHired($isToBeHired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isToBeHired) && !is_bool($isToBeHired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isToBeHired, true), gettype($isToBeHired)), __LINE__);
        }
        $this->isToBeHired = $isToBeHired;
        return $this;
    }
    /**
     * Get Percent_Allocation value
     * @return float|null
     */
    public function getPercent_Allocation()
    {
        return $this->Percent_Allocation;
    }
    /**
     * Set Percent_Allocation value
     * @param float $percent_Allocation
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setPercent_Allocation($percent_Allocation = null)
    {
        // validation for constraint: float
        if (!is_null($percent_Allocation) && !(is_float($percent_Allocation) || is_numeric($percent_Allocation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent_Allocation, true), gettype($percent_Allocation)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($percent_Allocation) && mb_strlen(mb_substr($percent_Allocation, false !== mb_strpos($percent_Allocation, '.') ? mb_strpos($percent_Allocation, '.') + 1 : mb_strlen($percent_Allocation))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($percent_Allocation, true), mb_strlen(mb_substr($percent_Allocation, mb_strpos($percent_Allocation, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percent_Allocation) && $percent_Allocation < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percent_Allocation, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($percent_Allocation) && mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($percent_Allocation, true), mb_strlen(preg_replace('/(\D)/', '', $percent_Allocation))), __LINE__);
        }
        $this->Percent_Allocation = $percent_Allocation;
        return $this;
    }
    /**
     * Get Estimated_Hours value
     * @return float|null
     */
    public function getEstimated_Hours()
    {
        return $this->Estimated_Hours;
    }
    /**
     * Set Estimated_Hours value
     * @param float $estimated_Hours
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setEstimated_Hours($estimated_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Hours) && !(is_float($estimated_Hours) || is_numeric($estimated_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Hours, true), gettype($estimated_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($estimated_Hours) && mb_strlen(mb_substr($estimated_Hours, false !== mb_strpos($estimated_Hours, '.') ? mb_strpos($estimated_Hours, '.') + 1 : mb_strlen($estimated_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($estimated_Hours, true), mb_strlen(mb_substr($estimated_Hours, mb_strpos($estimated_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Hours) && $estimated_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($estimated_Hours) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($estimated_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Hours))), __LINE__);
        }
        $this->Estimated_Hours = $estimated_Hours;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Project_Booking_Status_Reference value
     * @return \StructType\Project_Booking_StatusObjectType|null
     */
    public function getProject_Booking_Status_Reference()
    {
        return $this->Project_Booking_Status_Reference;
    }
    /**
     * Set Project_Booking_Status_Reference value
     * @param \StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setProject_Booking_Status_Reference(\StructType\Project_Booking_StatusObjectType $project_Booking_Status_Reference = null)
    {
        $this->Project_Booking_Status_Reference = $project_Booking_Status_Reference;
        return $this;
    }
    /**
     * Get Worker_Group_Reference value
     * @return \StructType\Project_Member_ResourceObjectType|null
     */
    public function getWorker_Group_Reference()
    {
        return $this->Worker_Group_Reference;
    }
    /**
     * Set Worker_Group_Reference value
     * @param \StructType\Project_Member_ResourceObjectType $worker_Group_Reference
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setWorker_Group_Reference(\StructType\Project_Member_ResourceObjectType $worker_Group_Reference = null)
    {
        $this->Worker_Group_Reference = $worker_Group_Reference;
        return $this;
    }
    /**
     * Get Standard_Cost_Rate value
     * @return float|null
     */
    public function getStandard_Cost_Rate()
    {
        return $this->Standard_Cost_Rate;
    }
    /**
     * Set Standard_Cost_Rate value
     * @param float $standard_Cost_Rate
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setStandard_Cost_Rate($standard_Cost_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($standard_Cost_Rate) && !(is_float($standard_Cost_Rate) || is_numeric($standard_Cost_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($standard_Cost_Rate, true), gettype($standard_Cost_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($standard_Cost_Rate) && mb_strlen(mb_substr($standard_Cost_Rate, false !== mb_strpos($standard_Cost_Rate, '.') ? mb_strpos($standard_Cost_Rate, '.') + 1 : mb_strlen($standard_Cost_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($standard_Cost_Rate, true), mb_strlen(mb_substr($standard_Cost_Rate, mb_strpos($standard_Cost_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($standard_Cost_Rate) && $standard_Cost_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($standard_Cost_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($standard_Cost_Rate) && mb_strlen(preg_replace('/(\D)/', '', $standard_Cost_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($standard_Cost_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $standard_Cost_Rate))), __LINE__);
        }
        $this->Standard_Cost_Rate = $standard_Cost_Rate;
        return $this;
    }
    /**
     * Get Standard_Cost_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getStandard_Cost_Currency_Reference()
    {
        return $this->Standard_Cost_Currency_Reference;
    }
    /**
     * Set Standard_Cost_Currency_Reference value
     * @param \StructType\CurrencyObjectType $standard_Cost_Currency_Reference
     * @return \StructType\Resource_Plan_Detail_for_Template_DataType
     */
    public function setStandard_Cost_Currency_Reference(\StructType\CurrencyObjectType $standard_Cost_Currency_Reference = null)
    {
        $this->Standard_Cost_Currency_Reference = $standard_Cost_Currency_Reference;
        return $this;
    }
}
