<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Expense_Item_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Expense Item reference for update and all Expense Item data items
 * @subpackage Structs
 */
class Put_Expense_Item_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Item for update only purposes
     * - minOccurs: 0
     * @var \StructType\Expense_ItemObjectType
     */
    public $Expense_Item_Reference;
    /**
     * The Expense_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Data
     * @var \StructType\Expense_Item_DataType
     */
    public $Expense_Item_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Expense_Item_RequestType
     * @uses Put_Expense_Item_RequestType::setExpense_Item_Reference()
     * @uses Put_Expense_Item_RequestType::setExpense_Item_Data()
     * @uses Put_Expense_Item_RequestType::setAdd_Only()
     * @uses Put_Expense_Item_RequestType::setVersion()
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @param \StructType\Expense_Item_DataType $expense_Item_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Expense_ItemObjectType $expense_Item_Reference = null, \StructType\Expense_Item_DataType $expense_Item_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setExpense_Item_Data($expense_Item_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Expense_ItemObjectType|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * Set Expense_Item_Reference value
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @return \StructType\Put_Expense_Item_RequestType
     */
    public function setExpense_Item_Reference(\StructType\Expense_ItemObjectType $expense_Item_Reference = null)
    {
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Data value
     * @return \StructType\Expense_Item_DataType|null
     */
    public function getExpense_Item_Data()
    {
        return $this->Expense_Item_Data;
    }
    /**
     * Set Expense_Item_Data value
     * @param \StructType\Expense_Item_DataType $expense_Item_Data
     * @return \StructType\Put_Expense_Item_RequestType
     */
    public function setExpense_Item_Data(\StructType\Expense_Item_DataType $expense_Item_Data = null)
    {
        $this->Expense_Item_Data = $expense_Item_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Expense_Item_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Expense_Item_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
