<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Provider_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains references to existing Internal Service Providers to be retrieved.
 * @subpackage Structs
 */
class Internal_Service_Provider_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to existing Internal Service Providers to be retrieved via the Get Internal Service Provider Web Service operation
     * - maxOccurs: unbounded
     * @var \StructType\Internal_Service_ProviderObjectType[]
     */
    public $Internal_Service_Provider_Reference;
    /**
     * Constructor method for Internal_Service_Provider_Request_ReferencesType
     * @uses Internal_Service_Provider_Request_ReferencesType::setInternal_Service_Provider_Reference()
     * @param \StructType\Internal_Service_ProviderObjectType[] $internal_Service_Provider_Reference
     */
    public function __construct(array $internal_Service_Provider_Reference = array())
    {
        $this
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference);
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType[]|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Provider_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Provider_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Provider_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem instanceof \StructType\Internal_Service_ProviderObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem) ? get_class($internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem), var_export($internal_Service_Provider_Request_ReferencesTypeInternal_Service_Provider_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Provider_Reference property can only contain items of type \StructType\Internal_Service_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderObjectType[] $internal_Service_Provider_Reference
     * @return \StructType\Internal_Service_Provider_Request_ReferencesType
     */
    public function setInternal_Service_Provider_Reference(array $internal_Service_Provider_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Provider_ReferenceArrayErrorMessage = self::validateInternal_Service_Provider_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Reference($internal_Service_Provider_Reference))) {
            throw new \InvalidArgumentException($internal_Service_Provider_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Service_Provider_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_ProviderObjectType $item
     * @return \StructType\Internal_Service_Provider_Request_ReferencesType
     */
    public function addToInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Provider_Reference property can only contain items of type \StructType\Internal_Service_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Provider_Reference[] = $item;
        return $this;
    }
}
