<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Pooling_Rule_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Put Asset Pooling Rule web service cannot be used to edit an existing rule; it can only add rules, or replace all rules. | Element containing asset pooling rule replacement data.
 * @subpackage Structs
 */
class Asset_Pooling_Rule_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Asset_Pooling_Rule_ID
     * Meta information extracted from the WSDL
     * - documentation: This is a unique reference identifier to the set of asset pooling rules.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Pooling_Rule_ID;
    /**
     * The Asset_Pooling_Rule_Order
     * Meta information extracted from the WSDL
     * - documentation: Used to define the order of the rules (ascending).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Pooling_Rule_Order;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing companies or company hierarchies to which the asset pooling rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Spend_Category_or_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing spend categories or spend category hierarchies to which the asset pooling rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_Category_or_HierarchyObjectType[]
     */
    public $Spend_Category_or_Hierarchy_Reference;
    /**
     * The Items_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing item to which the asset pooling rule applies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType[]
     */
    public $Items_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing currency to which the asset pooling rule applies. This is required if Less Than Amount is specified.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Quantity_Greater_Than
     * Meta information extracted from the WSDL
     * - documentation: The quantity above which the asset pooling rule applies. Quantity must be greater than zero.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 22
     * @var float
     */
    public $Quantity_Greater_Than;
    /**
     * The Unit_Cost_Threshold
     * Meta information extracted from the WSDL
     * - documentation: The amount below which the asset pooling rule applies.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost_Threshold;
    /**
     * Constructor method for Asset_Pooling_Rule_Replacement_DataType
     * @uses Asset_Pooling_Rule_Replacement_DataType::setAsset_Pooling_Rule_ID()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setAsset_Pooling_Rule_Order()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setCompany_Reference()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setSpend_Category_or_Hierarchy_Reference()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setItems_Reference()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setCurrency_Reference()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setQuantity_Greater_Than()
     * @uses Asset_Pooling_Rule_Replacement_DataType::setUnit_Cost_Threshold()
     * @param string $asset_Pooling_Rule_ID
     * @param string $asset_Pooling_Rule_Order
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @param \StructType\Item_DescriptorObjectType[] $items_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $quantity_Greater_Than
     * @param float $unit_Cost_Threshold
     */
    public function __construct($asset_Pooling_Rule_ID = null, $asset_Pooling_Rule_Order = null, array $company_Reference = array(), array $spend_Category_or_Hierarchy_Reference = array(), array $items_Reference = array(), \StructType\CurrencyObjectType $currency_Reference = null, $quantity_Greater_Than = null, $unit_Cost_Threshold = null)
    {
        $this
            ->setAsset_Pooling_Rule_ID($asset_Pooling_Rule_ID)
            ->setAsset_Pooling_Rule_Order($asset_Pooling_Rule_Order)
            ->setCompany_Reference($company_Reference)
            ->setSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference)
            ->setItems_Reference($items_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setQuantity_Greater_Than($quantity_Greater_Than)
            ->setUnit_Cost_Threshold($unit_Cost_Threshold);
    }
    /**
     * Get Asset_Pooling_Rule_ID value
     * @return string|null
     */
    public function getAsset_Pooling_Rule_ID()
    {
        return $this->Asset_Pooling_Rule_ID;
    }
    /**
     * Set Asset_Pooling_Rule_ID value
     * @param string $asset_Pooling_Rule_ID
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setAsset_Pooling_Rule_ID($asset_Pooling_Rule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Pooling_Rule_ID) && !is_string($asset_Pooling_Rule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Pooling_Rule_ID, true), gettype($asset_Pooling_Rule_ID)), __LINE__);
        }
        $this->Asset_Pooling_Rule_ID = $asset_Pooling_Rule_ID;
        return $this;
    }
    /**
     * Get Asset_Pooling_Rule_Order value
     * @return string|null
     */
    public function getAsset_Pooling_Rule_Order()
    {
        return $this->Asset_Pooling_Rule_Order;
    }
    /**
     * Set Asset_Pooling_Rule_Order value
     * @param string $asset_Pooling_Rule_Order
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setAsset_Pooling_Rule_Order($asset_Pooling_Rule_Order = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Pooling_Rule_Order) && !is_string($asset_Pooling_Rule_Order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Pooling_Rule_Order, true), gettype($asset_Pooling_Rule_Order)), __LINE__);
        }
        $this->Asset_Pooling_Rule_Order = $asset_Pooling_Rule_Order;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem) ? get_class($asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem), var_export($asset_Pooling_Rule_Replacement_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_or_Hierarchy_Reference value
     * @return \StructType\Spend_Category_or_HierarchyObjectType[]|null
     */
    public function getSpend_Category_or_Hierarchy_Reference()
    {
        return $this->Spend_Category_or_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_or_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_or_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
                $invalidValues[] = is_object($asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) ? get_class($asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem), var_export($asset_Pooling_Rule_Replacement_DataTypeSpend_Category_or_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType[] $spend_Category_or_Hierarchy_Reference
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setSpend_Category_or_Hierarchy_Reference(array $spend_Category_or_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage = self::validateSpend_Category_or_Hierarchy_ReferenceForArrayConstraintsFromSetSpend_Category_or_Hierarchy_Reference($spend_Category_or_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($spend_Category_or_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference = $spend_Category_or_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_or_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_Category_or_HierarchyObjectType $item
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function addToSpend_Category_or_Hierarchy_Reference(\StructType\Spend_Category_or_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_Category_or_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_or_Hierarchy_Reference property can only contain items of type \StructType\Spend_Category_or_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_or_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Items_Reference value
     * @return \StructType\Item_DescriptorObjectType[]|null
     */
    public function getItems_Reference()
    {
        return $this->Items_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItems_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItems_ReferenceForArrayConstraintsFromSetItems_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem instanceof \StructType\Item_DescriptorObjectType) {
                $invalidValues[] = is_object($asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem) ? get_class($asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem), var_export($asset_Pooling_Rule_Replacement_DataTypeItems_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Items_Reference property can only contain items of type \StructType\Item_DescriptorObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_DescriptorObjectType[] $items_Reference
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setItems_Reference(array $items_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($items_ReferenceArrayErrorMessage = self::validateItems_ReferenceForArrayConstraintsFromSetItems_Reference($items_Reference))) {
            throw new \InvalidArgumentException($items_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Items_Reference = $items_Reference;
        return $this;
    }
    /**
     * Add item to Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_DescriptorObjectType $item
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function addToItems_Reference(\StructType\Item_DescriptorObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_DescriptorObjectType) {
            throw new \InvalidArgumentException(sprintf('The Items_Reference property can only contain items of type \StructType\Item_DescriptorObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Items_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Quantity_Greater_Than value
     * @return float|null
     */
    public function getQuantity_Greater_Than()
    {
        return $this->Quantity_Greater_Than;
    }
    /**
     * Set Quantity_Greater_Than value
     * @param float $quantity_Greater_Than
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setQuantity_Greater_Than($quantity_Greater_Than = null)
    {
        // validation for constraint: float
        if (!is_null($quantity_Greater_Than) && !(is_float($quantity_Greater_Than) || is_numeric($quantity_Greater_Than))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity_Greater_Than, true), gettype($quantity_Greater_Than)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity_Greater_Than) && mb_strlen(mb_substr($quantity_Greater_Than, false !== mb_strpos($quantity_Greater_Than, '.') ? mb_strpos($quantity_Greater_Than, '.') + 1 : mb_strlen($quantity_Greater_Than))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity_Greater_Than, true), mb_strlen(mb_substr($quantity_Greater_Than, mb_strpos($quantity_Greater_Than, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity_Greater_Than) && mb_strlen(preg_replace('/(\D)/', '', $quantity_Greater_Than)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity_Greater_Than, true), mb_strlen(preg_replace('/(\D)/', '', $quantity_Greater_Than))), __LINE__);
        }
        $this->Quantity_Greater_Than = $quantity_Greater_Than;
        return $this;
    }
    /**
     * Get Unit_Cost_Threshold value
     * @return float|null
     */
    public function getUnit_Cost_Threshold()
    {
        return $this->Unit_Cost_Threshold;
    }
    /**
     * Set Unit_Cost_Threshold value
     * @param float $unit_Cost_Threshold
     * @return \StructType\Asset_Pooling_Rule_Replacement_DataType
     */
    public function setUnit_Cost_Threshold($unit_Cost_Threshold = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost_Threshold) && !(is_float($unit_Cost_Threshold) || is_numeric($unit_Cost_Threshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost_Threshold, true), gettype($unit_Cost_Threshold)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost_Threshold) && mb_strlen(mb_substr($unit_Cost_Threshold, false !== mb_strpos($unit_Cost_Threshold, '.') ? mb_strpos($unit_Cost_Threshold, '.') + 1 : mb_strlen($unit_Cost_Threshold))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost_Threshold, true), mb_strlen(mb_substr($unit_Cost_Threshold, mb_strpos($unit_Cost_Threshold, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost_Threshold) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost_Threshold)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost_Threshold, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost_Threshold))), __LINE__);
        }
        $this->Unit_Cost_Threshold = $unit_Cost_Threshold;
        return $this;
    }
}
