<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Time_Card_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains Worker Time Card (Timesheet) Data.
 * @subpackage Structs
 */
class Worker_Time_Card_WWS_DataType extends AbstractStructBase
{
    /**
     * The Worker_Time_Card_ID
     * Meta information extracted from the WSDL
     * - documentation: The ID returned for each Timesheet (Worker Time Card) for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Time_Card_ID;
    /**
     * The Last_Updated_Date
     * Meta information extracted from the WSDL
     * - documentation: The Last Updated Date of Worker Time Card for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Last_Updated_Date;
    /**
     * The Is_Payroll_Timesheet
     * Meta information extracted from the WSDL
     * - documentation: Is this a Payroll Timesheet for Worker Time Card for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Payroll_Timesheet;
    /**
     * The Worker_Time_Card_Status
     * Meta information extracted from the WSDL
     * - documentation: Status for worker time card (timesheet) for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Time_Card_Status;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worker for worker time card (timesheet) for Get_Timesheet operation's response.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Period_Reference
     * Meta information extracted from the WSDL
     * - documentation: Period for the Timesheet. A Period may have only one Timesheet per worker per timesheet type (project or payroll).
     * - minOccurs: 0
     * @var \StructType\PeriodObjectType
     */
    public $Period_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The period start date for worker time card (timesheet) for Get_Timesheet operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Period end date for worker time card (timesheet) for Get_Timesheet operation's response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Time_Zone_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Time Zone chosen on the Worker Time Card for TITO Timesheets.
     * - minOccurs: 0
     * @var \StructType\Time_ZoneObjectType
     */
    public $Time_Zone_Reference;
    /**
     * Constructor method for Worker_Time_Card_WWS_DataType
     * @uses Worker_Time_Card_WWS_DataType::setWorker_Time_Card_ID()
     * @uses Worker_Time_Card_WWS_DataType::setLast_Updated_Date()
     * @uses Worker_Time_Card_WWS_DataType::setIs_Payroll_Timesheet()
     * @uses Worker_Time_Card_WWS_DataType::setWorker_Time_Card_Status()
     * @uses Worker_Time_Card_WWS_DataType::setWorker_Reference()
     * @uses Worker_Time_Card_WWS_DataType::setPeriod_Reference()
     * @uses Worker_Time_Card_WWS_DataType::setStart_Date()
     * @uses Worker_Time_Card_WWS_DataType::setEnd_Date()
     * @uses Worker_Time_Card_WWS_DataType::setTime_Zone_Reference()
     * @param string $worker_Time_Card_ID
     * @param string $last_Updated_Date
     * @param bool $is_Payroll_Timesheet
     * @param string $worker_Time_Card_Status
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\PeriodObjectType $period_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     */
    public function __construct($worker_Time_Card_ID = null, $last_Updated_Date = null, $is_Payroll_Timesheet = null, $worker_Time_Card_Status = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\PeriodObjectType $period_Reference = null, $start_Date = null, $end_Date = null, \StructType\Time_ZoneObjectType $time_Zone_Reference = null)
    {
        $this
            ->setWorker_Time_Card_ID($worker_Time_Card_ID)
            ->setLast_Updated_Date($last_Updated_Date)
            ->setIs_Payroll_Timesheet($is_Payroll_Timesheet)
            ->setWorker_Time_Card_Status($worker_Time_Card_Status)
            ->setWorker_Reference($worker_Reference)
            ->setPeriod_Reference($period_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setTime_Zone_Reference($time_Zone_Reference);
    }
    /**
     * Get Worker_Time_Card_ID value
     * @return string|null
     */
    public function getWorker_Time_Card_ID()
    {
        return $this->Worker_Time_Card_ID;
    }
    /**
     * Set Worker_Time_Card_ID value
     * @param string $worker_Time_Card_ID
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setWorker_Time_Card_ID($worker_Time_Card_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Time_Card_ID) && !is_string($worker_Time_Card_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Time_Card_ID, true), gettype($worker_Time_Card_ID)), __LINE__);
        }
        $this->Worker_Time_Card_ID = $worker_Time_Card_ID;
        return $this;
    }
    /**
     * Get Last_Updated_Date value
     * @return string|null
     */
    public function getLast_Updated_Date()
    {
        return $this->Last_Updated_Date;
    }
    /**
     * Set Last_Updated_Date value
     * @param string $last_Updated_Date
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setLast_Updated_Date($last_Updated_Date = null)
    {
        // validation for constraint: string
        if (!is_null($last_Updated_Date) && !is_string($last_Updated_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last_Updated_Date, true), gettype($last_Updated_Date)), __LINE__);
        }
        $this->Last_Updated_Date = $last_Updated_Date;
        return $this;
    }
    /**
     * Get Is_Payroll_Timesheet value
     * @return bool|null
     */
    public function getIs_Payroll_Timesheet()
    {
        return $this->Is_Payroll_Timesheet;
    }
    /**
     * Set Is_Payroll_Timesheet value
     * @param bool $is_Payroll_Timesheet
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setIs_Payroll_Timesheet($is_Payroll_Timesheet = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Payroll_Timesheet) && !is_bool($is_Payroll_Timesheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Payroll_Timesheet, true), gettype($is_Payroll_Timesheet)), __LINE__);
        }
        $this->Is_Payroll_Timesheet = $is_Payroll_Timesheet;
        return $this;
    }
    /**
     * Get Worker_Time_Card_Status value
     * @return string|null
     */
    public function getWorker_Time_Card_Status()
    {
        return $this->Worker_Time_Card_Status;
    }
    /**
     * Set Worker_Time_Card_Status value
     * @param string $worker_Time_Card_Status
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setWorker_Time_Card_Status($worker_Time_Card_Status = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Time_Card_Status) && !is_string($worker_Time_Card_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Time_Card_Status, true), gettype($worker_Time_Card_Status)), __LINE__);
        }
        $this->Worker_Time_Card_Status = $worker_Time_Card_Status;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Period_Reference value
     * @return \StructType\PeriodObjectType|null
     */
    public function getPeriod_Reference()
    {
        return $this->Period_Reference;
    }
    /**
     * Set Period_Reference value
     * @param \StructType\PeriodObjectType $period_Reference
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setPeriod_Reference(\StructType\PeriodObjectType $period_Reference = null)
    {
        $this->Period_Reference = $period_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Time_Zone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getTime_Zone_Reference()
    {
        return $this->Time_Zone_Reference;
    }
    /**
     * Set Time_Zone_Reference value
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @return \StructType\Worker_Time_Card_WWS_DataType
     */
    public function setTime_Zone_Reference(\StructType\Time_ZoneObjectType $time_Zone_Reference = null)
    {
        $this->Time_Zone_Reference = $time_Zone_Reference;
        return $this;
    }
}
