<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Forecast_Line_Allocation_for_Web_ServiceType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element contain Resource Forecast Line Allocation Details such as Period Start date for the allocation and Forecasted Hours.
 * @subpackage Structs
 */
class Resource_Forecast_Line_Allocation_for_Web_ServiceType extends AbstractStructBase
{
    /**
     * The Period_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Period Start Date for Resource Forecast Line Allocation
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Period_Start_Date;
    /**
     * The Forecasted_Hours
     * Meta information extracted from the WSDL
     * - documentation: Forecasted Hours for Resource Forecast Line Allocation | Forecasted hours for weekly allocation data
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Forecasted_Hours;
    /**
     * Constructor method for Resource_Forecast_Line_Allocation_for_Web_ServiceType
     * @uses Resource_Forecast_Line_Allocation_for_Web_ServiceType::setPeriod_Start_Date()
     * @uses Resource_Forecast_Line_Allocation_for_Web_ServiceType::setForecasted_Hours()
     * @param string $period_Start_Date
     * @param float $forecasted_Hours
     */
    public function __construct($period_Start_Date = null, $forecasted_Hours = null)
    {
        $this
            ->setPeriod_Start_Date($period_Start_Date)
            ->setForecasted_Hours($forecasted_Hours);
    }
    /**
     * Get Period_Start_Date value
     * @return string|null
     */
    public function getPeriod_Start_Date()
    {
        return $this->Period_Start_Date;
    }
    /**
     * Set Period_Start_Date value
     * @param string $period_Start_Date
     * @return \StructType\Resource_Forecast_Line_Allocation_for_Web_ServiceType
     */
    public function setPeriod_Start_Date($period_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($period_Start_Date) && !is_string($period_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period_Start_Date, true), gettype($period_Start_Date)), __LINE__);
        }
        $this->Period_Start_Date = $period_Start_Date;
        return $this;
    }
    /**
     * Get Forecasted_Hours value
     * @return float|null
     */
    public function getForecasted_Hours()
    {
        return $this->Forecasted_Hours;
    }
    /**
     * Set Forecasted_Hours value
     * @param float $forecasted_Hours
     * @return \StructType\Resource_Forecast_Line_Allocation_for_Web_ServiceType
     */
    public function setForecasted_Hours($forecasted_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($forecasted_Hours) && !(is_float($forecasted_Hours) || is_numeric($forecasted_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($forecasted_Hours, true), gettype($forecasted_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($forecasted_Hours) && mb_strlen(mb_substr($forecasted_Hours, false !== mb_strpos($forecasted_Hours, '.') ? mb_strpos($forecasted_Hours, '.') + 1 : mb_strlen($forecasted_Hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($forecasted_Hours, true), mb_strlen(mb_substr($forecasted_Hours, mb_strpos($forecasted_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($forecasted_Hours) && $forecasted_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($forecasted_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($forecasted_Hours) && mb_strlen(preg_replace('/(\D)/', '', $forecasted_Hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($forecasted_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $forecasted_Hours))), __LINE__);
        }
        $this->Forecasted_Hours = $forecasted_Hours;
        return $this;
    }
}
