<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Expense_Policy_Group_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Expense Policy Group reference for update and all Expense Policy Group data items
 * @subpackage Structs
 */
class Put_Expense_Policy_Group_RequestType extends AbstractStructBase
{
    /**
     * The Expense_Policy_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Policy Group for update only purposes
     * - minOccurs: 0
     * @var \StructType\Expense_Policy_GroupObjectType
     */
    public $Expense_Policy_Group_Reference;
    /**
     * The Expense_Policy_Group_Data
     * @var \StructType\Expense_Policy_Group_DataType
     */
    public $Expense_Policy_Group_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. If an existing instance is found and this flag is set there will be an error.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Expense_Policy_Group_RequestType
     * @uses Put_Expense_Policy_Group_RequestType::setExpense_Policy_Group_Reference()
     * @uses Put_Expense_Policy_Group_RequestType::setExpense_Policy_Group_Data()
     * @uses Put_Expense_Policy_Group_RequestType::setAdd_Only()
     * @uses Put_Expense_Policy_Group_RequestType::setVersion()
     * @param \StructType\Expense_Policy_GroupObjectType $expense_Policy_Group_Reference
     * @param \StructType\Expense_Policy_Group_DataType $expense_Policy_Group_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Expense_Policy_GroupObjectType $expense_Policy_Group_Reference = null, \StructType\Expense_Policy_Group_DataType $expense_Policy_Group_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Policy_Group_Reference($expense_Policy_Group_Reference)
            ->setExpense_Policy_Group_Data($expense_Policy_Group_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Policy_Group_Reference value
     * @return \StructType\Expense_Policy_GroupObjectType|null
     */
    public function getExpense_Policy_Group_Reference()
    {
        return $this->Expense_Policy_Group_Reference;
    }
    /**
     * Set Expense_Policy_Group_Reference value
     * @param \StructType\Expense_Policy_GroupObjectType $expense_Policy_Group_Reference
     * @return \StructType\Put_Expense_Policy_Group_RequestType
     */
    public function setExpense_Policy_Group_Reference(\StructType\Expense_Policy_GroupObjectType $expense_Policy_Group_Reference = null)
    {
        $this->Expense_Policy_Group_Reference = $expense_Policy_Group_Reference;
        return $this;
    }
    /**
     * Get Expense_Policy_Group_Data value
     * @return \StructType\Expense_Policy_Group_DataType|null
     */
    public function getExpense_Policy_Group_Data()
    {
        return $this->Expense_Policy_Group_Data;
    }
    /**
     * Set Expense_Policy_Group_Data value
     * @param \StructType\Expense_Policy_Group_DataType $expense_Policy_Group_Data
     * @return \StructType\Put_Expense_Policy_Group_RequestType
     */
    public function setExpense_Policy_Group_Data(\StructType\Expense_Policy_Group_DataType $expense_Policy_Group_Data = null)
    {
        $this->Expense_Policy_Group_Data = $expense_Policy_Group_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Expense_Policy_Group_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Expense_Policy_Group_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
