<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Conditions_Rule_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Utilize the following criteria options to search for Procurement Conditional Rules.
 * @subpackage Structs
 */
class Procurement_Conditions_Rule_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Rule_Description
     * Meta information extracted from the WSDL
     * - documentation: Procurement Condition Rule Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rule_Description;
    /**
     * Constructor method for Procurement_Conditions_Rule_Request_CriteriaType
     * @uses Procurement_Conditions_Rule_Request_CriteriaType::setRule_Description()
     * @param string $rule_Description
     */
    public function __construct($rule_Description = null)
    {
        $this
            ->setRule_Description($rule_Description);
    }
    /**
     * Get Rule_Description value
     * @return string|null
     */
    public function getRule_Description()
    {
        return $this->Rule_Description;
    }
    /**
     * Set Rule_Description value
     * @param string $rule_Description
     * @return \StructType\Procurement_Conditions_Rule_Request_CriteriaType
     */
    public function setRule_Description($rule_Description = null)
    {
        // validation for constraint: string
        if (!is_null($rule_Description) && !is_string($rule_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rule_Description, true), gettype($rule_Description)), __LINE__);
        }
        $this->Rule_Description = $rule_Description;
        return $this;
    }
}
