<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Expense Item Instance and Data
 * @subpackage Structs
 */
class Expense_Item_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item
     * Meta information extracted from the WSDL
     * - documentation: Expense Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_ItemType[]
     */
    public $Expense_Item;
    /**
     * Constructor method for Expense_Item_Response_DataType
     * @uses Expense_Item_Response_DataType::setExpense_Item()
     * @param \StructType\Expense_ItemType[] $expense_Item
     */
    public function __construct(array $expense_Item = array())
    {
        $this
            ->setExpense_Item($expense_Item);
    }
    /**
     * Get Expense_Item value
     * @return \StructType\Expense_ItemType[]|null
     */
    public function getExpense_Item()
    {
        return $this->Expense_Item;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_ItemForArrayConstraintsFromSetExpense_Item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Response_DataTypeExpense_ItemItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Response_DataTypeExpense_ItemItem instanceof \StructType\Expense_ItemType) {
                $invalidValues[] = is_object($expense_Item_Response_DataTypeExpense_ItemItem) ? get_class($expense_Item_Response_DataTypeExpense_ItemItem) : sprintf('%s(%s)', gettype($expense_Item_Response_DataTypeExpense_ItemItem), var_export($expense_Item_Response_DataTypeExpense_ItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item property can only contain items of type \StructType\Expense_ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemType[] $expense_Item
     * @return \StructType\Expense_Item_Response_DataType
     */
    public function setExpense_Item(array $expense_Item = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_ItemArrayErrorMessage = self::validateExpense_ItemForArrayConstraintsFromSetExpense_Item($expense_Item))) {
            throw new \InvalidArgumentException($expense_ItemArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item = $expense_Item;
        return $this;
    }
    /**
     * Add item to Expense_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemType $item
     * @return \StructType\Expense_Item_Response_DataType
     */
    public function addToExpense_Item(\StructType\Expense_ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ItemType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item property can only contain items of type \StructType\Expense_ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item[] = $item;
        return $this;
    }
}
