<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Company_DefaultType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that encapsulates all the data related to the Expense Company Default.
 * @subpackage Structs
 */
class Expense_Company_DefaultType extends AbstractStructBase
{
    /**
     * The Expense_Company_Default_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that encapsulates all the data related to the Expense Company Default.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Company_Default_DataType[]
     */
    public $Expense_Company_Default_Data;
    /**
     * Constructor method for Expense_Company_DefaultType
     * @uses Expense_Company_DefaultType::setExpense_Company_Default_Data()
     * @param \StructType\Expense_Company_Default_DataType[] $expense_Company_Default_Data
     */
    public function __construct(array $expense_Company_Default_Data = array())
    {
        $this
            ->setExpense_Company_Default_Data($expense_Company_Default_Data);
    }
    /**
     * Get Expense_Company_Default_Data value
     * @return \StructType\Expense_Company_Default_DataType[]|null
     */
    public function getExpense_Company_Default_Data()
    {
        return $this->Expense_Company_Default_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Company_Default_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Company_Default_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Company_Default_DataForArrayConstraintsFromSetExpense_Company_Default_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Company_DefaultTypeExpense_Company_Default_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Company_DefaultTypeExpense_Company_Default_DataItem instanceof \StructType\Expense_Company_Default_DataType) {
                $invalidValues[] = is_object($expense_Company_DefaultTypeExpense_Company_Default_DataItem) ? get_class($expense_Company_DefaultTypeExpense_Company_Default_DataItem) : sprintf('%s(%s)', gettype($expense_Company_DefaultTypeExpense_Company_Default_DataItem), var_export($expense_Company_DefaultTypeExpense_Company_Default_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Company_Default_Data property can only contain items of type \StructType\Expense_Company_Default_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Company_Default_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Company_Default_DataType[] $expense_Company_Default_Data
     * @return \StructType\Expense_Company_DefaultType
     */
    public function setExpense_Company_Default_Data(array $expense_Company_Default_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Company_Default_DataArrayErrorMessage = self::validateExpense_Company_Default_DataForArrayConstraintsFromSetExpense_Company_Default_Data($expense_Company_Default_Data))) {
            throw new \InvalidArgumentException($expense_Company_Default_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Company_Default_Data = $expense_Company_Default_Data;
        return $this;
    }
    /**
     * Add item to Expense_Company_Default_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Company_Default_DataType $item
     * @return \StructType\Expense_Company_DefaultType
     */
    public function addToExpense_Company_Default_Data(\StructType\Expense_Company_Default_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Company_Default_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Company_Default_Data property can only contain items of type \StructType\Expense_Company_Default_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Company_Default_Data[] = $item;
        return $this;
    }
}
