<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Sourcing_Rule_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing global attributes for different kinds of sourcing rules (buyer, supplier, order-from connection, inventory site) as well as individual Requisition Sourcing Rule data. Global attributes are only allowed to be
 * retrieved prior to v33.0. This was removed to support import and export of requisition rule data via spreadsheet generation.
 * @subpackage Structs
 */
class Requisition_Sourcing_Rule_Response_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Sourcing_Rule
     * Meta information extracted from the WSDL
     * - documentation: Requisition Sourcing Rule data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_Sourcing_RuleType[]
     */
    public $Requisition_Sourcing_Rule;
    /**
     * Constructor method for Requisition_Sourcing_Rule_Response_DataType
     * @uses Requisition_Sourcing_Rule_Response_DataType::setRequisition_Sourcing_Rule()
     * @param \StructType\Requisition_Sourcing_RuleType[] $requisition_Sourcing_Rule
     */
    public function __construct(array $requisition_Sourcing_Rule = array())
    {
        $this
            ->setRequisition_Sourcing_Rule($requisition_Sourcing_Rule);
    }
    /**
     * Get Requisition_Sourcing_Rule value
     * @return \StructType\Requisition_Sourcing_RuleType[]|null
     */
    public function getRequisition_Sourcing_Rule()
    {
        return $this->Requisition_Sourcing_Rule;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Sourcing_Rule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Rule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Sourcing_RuleForArrayConstraintsFromSetRequisition_Sourcing_Rule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem) {
            // validation for constraint: itemType
            if (!$requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem instanceof \StructType\Requisition_Sourcing_RuleType) {
                $invalidValues[] = is_object($requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem) ? get_class($requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem) : sprintf('%s(%s)', gettype($requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem), var_export($requisition_Sourcing_Rule_Response_DataTypeRequisition_Sourcing_RuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Sourcing_Rule property can only contain items of type \StructType\Requisition_Sourcing_RuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_RuleType[] $requisition_Sourcing_Rule
     * @return \StructType\Requisition_Sourcing_Rule_Response_DataType
     */
    public function setRequisition_Sourcing_Rule(array $requisition_Sourcing_Rule = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Sourcing_RuleArrayErrorMessage = self::validateRequisition_Sourcing_RuleForArrayConstraintsFromSetRequisition_Sourcing_Rule($requisition_Sourcing_Rule))) {
            throw new \InvalidArgumentException($requisition_Sourcing_RuleArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Sourcing_Rule = $requisition_Sourcing_Rule;
        return $this;
    }
    /**
     * Add item to Requisition_Sourcing_Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_Sourcing_RuleType $item
     * @return \StructType\Requisition_Sourcing_Rule_Response_DataType
     */
    public function addToRequisition_Sourcing_Rule(\StructType\Requisition_Sourcing_RuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_Sourcing_RuleType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Sourcing_Rule property can only contain items of type \StructType\Requisition_Sourcing_RuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Sourcing_Rule[] = $item;
        return $this;
    }
}
