<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receivable_Repayment_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Receivable Repayment Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Receivable_Repayment_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Applicant, Contingent Worker, or Employee
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType[]
     */
    public $Expense_Payee_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receivable Repayment Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Receivable_Repayment_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receivable Repayment Payment Type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Receivable_Repayment_Payment_Type_Reference;
    /**
     * The Receivable_Repayment_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Report From Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receivable_Repayment_From_Date;
    /**
     * The Receivable_Repayment_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Report To Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receivable_Repayment_To_Date;
    /**
     * Constructor method for Receivable_Repayment_Request_CriteriaType
     * @uses Receivable_Repayment_Request_CriteriaType::setOrganization_Reference()
     * @uses Receivable_Repayment_Request_CriteriaType::setExpense_Payee_Reference()
     * @uses Receivable_Repayment_Request_CriteriaType::setCurrency_Reference()
     * @uses Receivable_Repayment_Request_CriteriaType::setReceivable_Repayment_Payment_Type_Reference()
     * @uses Receivable_Repayment_Request_CriteriaType::setReceivable_Repayment_From_Date()
     * @uses Receivable_Repayment_Request_CriteriaType::setReceivable_Repayment_To_Date()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Payment_TypeObjectType $receivable_Repayment_Payment_Type_Reference
     * @param string $receivable_Repayment_From_Date
     * @param string $receivable_Repayment_To_Date
     */
    public function __construct(array $organization_Reference = array(), array $expense_Payee_Reference = array(), \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Payment_TypeObjectType $receivable_Repayment_Payment_Type_Reference = null, $receivable_Repayment_From_Date = null, $receivable_Repayment_To_Date = null)
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setReceivable_Repayment_Payment_Type_Reference($receivable_Repayment_Payment_Type_Reference)
            ->setReceivable_Repayment_From_Date($receivable_Repayment_From_Date)
            ->setReceivable_Repayment_To_Date($receivable_Repayment_To_Date);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem), var_export($receivable_Repayment_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType[]|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Payee_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Payee_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem instanceof \StructType\Expense_PayeeObjectType) {
                $invalidValues[] = is_object($receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem) ? get_class($receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem) : sprintf('%s(%s)', gettype($receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem), var_export($receivable_Repayment_Request_CriteriaTypeExpense_Payee_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType[] $expense_Payee_Reference
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setExpense_Payee_Reference(array $expense_Payee_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Payee_ReferenceArrayErrorMessage = self::validateExpense_Payee_ReferenceForArrayConstraintsFromSetExpense_Payee_Reference($expense_Payee_Reference))) {
            throw new \InvalidArgumentException($expense_Payee_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Payee_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $item
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function addToExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_PayeeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Payee_Reference property can only contain items of type \StructType\Expense_PayeeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Payee_Reference[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Receivable_Repayment_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getReceivable_Repayment_Payment_Type_Reference()
    {
        return $this->Receivable_Repayment_Payment_Type_Reference;
    }
    /**
     * Set Receivable_Repayment_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $receivable_Repayment_Payment_Type_Reference
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setReceivable_Repayment_Payment_Type_Reference(\StructType\Payment_TypeObjectType $receivable_Repayment_Payment_Type_Reference = null)
    {
        $this->Receivable_Repayment_Payment_Type_Reference = $receivable_Repayment_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Receivable_Repayment_From_Date value
     * @return string|null
     */
    public function getReceivable_Repayment_From_Date()
    {
        return $this->Receivable_Repayment_From_Date;
    }
    /**
     * Set Receivable_Repayment_From_Date value
     * @param string $receivable_Repayment_From_Date
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setReceivable_Repayment_From_Date($receivable_Repayment_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($receivable_Repayment_From_Date) && !is_string($receivable_Repayment_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivable_Repayment_From_Date, true), gettype($receivable_Repayment_From_Date)), __LINE__);
        }
        $this->Receivable_Repayment_From_Date = $receivable_Repayment_From_Date;
        return $this;
    }
    /**
     * Get Receivable_Repayment_To_Date value
     * @return string|null
     */
    public function getReceivable_Repayment_To_Date()
    {
        return $this->Receivable_Repayment_To_Date;
    }
    /**
     * Set Receivable_Repayment_To_Date value
     * @param string $receivable_Repayment_To_Date
     * @return \StructType\Receivable_Repayment_Request_CriteriaType
     */
    public function setReceivable_Repayment_To_Date($receivable_Repayment_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($receivable_Repayment_To_Date) && !is_string($receivable_Repayment_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivable_Repayment_To_Date, true), gettype($receivable_Repayment_To_Date)), __LINE__);
        }
        $this->Receivable_Repayment_To_Date = $receivable_Repayment_To_Date;
        return $this;
    }
}
