<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReceiptType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Receipt Instance and Data
 * @subpackage Structs
 */
class ReceiptType extends AbstractStructBase
{
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt
     * - minOccurs: 0
     * @var \StructType\ReceiptObjectType
     */
    public $Receipt_Reference;
    /**
     * The Receipt_Data
     * Meta information extracted from the WSDL
     * - documentation: Receipt Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_DataType[]
     */
    public $Receipt_Data;
    /**
     * Constructor method for ReceiptType
     * @uses ReceiptType::setReceipt_Reference()
     * @uses ReceiptType::setReceipt_Data()
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @param \StructType\Receipt_DataType[] $receipt_Data
     */
    public function __construct(\StructType\ReceiptObjectType $receipt_Reference = null, array $receipt_Data = array())
    {
        $this
            ->setReceipt_Reference($receipt_Reference)
            ->setReceipt_Data($receipt_Data);
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * Set Receipt_Reference value
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @return \StructType\ReceiptType
     */
    public function setReceipt_Reference(\StructType\ReceiptObjectType $receipt_Reference = null)
    {
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Get Receipt_Data value
     * @return \StructType\Receipt_DataType[]|null
     */
    public function getReceipt_Data()
    {
        return $this->Receipt_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_DataForArrayConstraintsFromSetReceipt_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receiptTypeReceipt_DataItem) {
            // validation for constraint: itemType
            if (!$receiptTypeReceipt_DataItem instanceof \StructType\Receipt_DataType) {
                $invalidValues[] = is_object($receiptTypeReceipt_DataItem) ? get_class($receiptTypeReceipt_DataItem) : sprintf('%s(%s)', gettype($receiptTypeReceipt_DataItem), var_export($receiptTypeReceipt_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Data property can only contain items of type \StructType\Receipt_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_DataType[] $receipt_Data
     * @return \StructType\ReceiptType
     */
    public function setReceipt_Data(array $receipt_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_DataArrayErrorMessage = self::validateReceipt_DataForArrayConstraintsFromSetReceipt_Data($receipt_Data))) {
            throw new \InvalidArgumentException($receipt_DataArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Data = $receipt_Data;
        return $this;
    }
    /**
     * Add item to Receipt_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_DataType $item
     * @return \StructType\ReceiptType
     */
    public function addToReceipt_Data(\StructType\Receipt_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_DataType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Data property can only contain items of type \StructType\Receipt_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Data[] = $item;
        return $this;
    }
}
