<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Purchase Item Instance and Data
 * @subpackage Structs
 */
class Purchase_Item_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemType[]
     */
    public $Purchase_Item;
    /**
     * Constructor method for Purchase_Item_Response_DataType
     * @uses Purchase_Item_Response_DataType::setPurchase_Item()
     * @param \StructType\Purchase_ItemType[] $purchase_Item
     */
    public function __construct(array $purchase_Item = array())
    {
        $this
            ->setPurchase_Item($purchase_Item);
    }
    /**
     * Get Purchase_Item value
     * @return \StructType\Purchase_ItemType[]|null
     */
    public function getPurchase_Item()
    {
        return $this->Purchase_Item;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_ItemForArrayConstraintsFromSetPurchase_Item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Response_DataTypePurchase_ItemItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Response_DataTypePurchase_ItemItem instanceof \StructType\Purchase_ItemType) {
                $invalidValues[] = is_object($purchase_Item_Response_DataTypePurchase_ItemItem) ? get_class($purchase_Item_Response_DataTypePurchase_ItemItem) : sprintf('%s(%s)', gettype($purchase_Item_Response_DataTypePurchase_ItemItem), var_export($purchase_Item_Response_DataTypePurchase_ItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item property can only contain items of type \StructType\Purchase_ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemType[] $purchase_Item
     * @return \StructType\Purchase_Item_Response_DataType
     */
    public function setPurchase_Item(array $purchase_Item = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_ItemArrayErrorMessage = self::validatePurchase_ItemForArrayConstraintsFromSetPurchase_Item($purchase_Item))) {
            throw new \InvalidArgumentException($purchase_ItemArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item = $purchase_Item;
        return $this;
    }
    /**
     * Add item to Purchase_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemType $item
     * @return \StructType\Purchase_Item_Response_DataType
     */
    public function addToPurchase_Item(\StructType\Purchase_ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item property can only contain items of type \StructType\Purchase_ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item[] = $item;
        return $this;
    }
}
