<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passenger_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that encapsulates the passenger type info (worker, passenger, passenger name). Only one value can be used at a time.
 * @subpackage Structs
 */
class Passenger_DataType extends AbstractStructBase
{
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The applicant you have entered is not valid. You must use the employee instance for this person. | Reference to the worker or applicant who was an attendee for the expense.
     * - choice: Worker_Reference | Passenger_Reference | Passenger_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Worker_Reference;
    /**
     * The Passenger_Reference
     * Meta information extracted from the WSDL
     * - documentation: The passenger you have entered is not valid for the expense payee | Reference to the person who was a passenger for the expense. Only passengers associated with the expense payee will be allowed.
     * - choice: Worker_Reference | Passenger_Reference | Passenger_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Passenger_Reference;
    /**
     * The Passenger_Name
     * Meta information extracted from the WSDL
     * - documentation: Text representing the name of the passenger. If the passenger exists already and is associated with the expense payee then it will be used. Otherwise, a new passenger will be created.
     * - choice: Worker_Reference | Passenger_Reference | Passenger_Name
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Passenger_Name;
    /**
     * Constructor method for Passenger_DataType
     * @uses Passenger_DataType::setWorker_Reference()
     * @uses Passenger_DataType::setPassenger_Reference()
     * @uses Passenger_DataType::setPassenger_Name()
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @param \StructType\Unique_IdentifierObjectType $passenger_Reference
     * @param string $passenger_Name
     */
    public function __construct(\StructType\Expense_PayeeObjectType $worker_Reference = null, \StructType\Unique_IdentifierObjectType $passenger_Reference = null, $passenger_Name = null)
    {
        $this
            ->setWorker_Reference($worker_Reference)
            ->setPassenger_Reference($passenger_Reference)
            ->setPassenger_Name($passenger_Name);
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getWorker_Reference()
    {
        return isset($this->Worker_Reference) ? $this->Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Passenger_Reference',
            'Passenger_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_PayeeObjectType $worker_Reference
     * @return \StructType\Passenger_DataType
     */
    public function setWorker_Reference(\StructType\Expense_PayeeObjectType $worker_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Passenger_Reference, Passenger_Name)
        if ('' !== ($worker_ReferenceChoiceErrorMessage = self::validateWorker_ReferenceForChoiceConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($worker_Reference) || (is_array($worker_Reference) && empty($worker_Reference))) {
            unset($this->Worker_Reference);
        } else {
            $this->Worker_Reference = $worker_Reference;
        }
        return $this;
    }
    /**
     * Get Passenger_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getPassenger_Reference()
    {
        return isset($this->Passenger_Reference) ? $this->Passenger_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPassenger_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassenger_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePassenger_ReferenceForChoiceConstraintsFromSetPassenger_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Passenger_Name',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Passenger_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Passenger_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Passenger_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $passenger_Reference
     * @return \StructType\Passenger_DataType
     */
    public function setPassenger_Reference(\StructType\Unique_IdentifierObjectType $passenger_Reference = null)
    {
        // validation for constraint: choice(Worker_Reference, Passenger_Reference, Passenger_Name)
        if ('' !== ($passenger_ReferenceChoiceErrorMessage = self::validatePassenger_ReferenceForChoiceConstraintsFromSetPassenger_Reference($passenger_Reference))) {
            throw new \InvalidArgumentException($passenger_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($passenger_Reference) || (is_array($passenger_Reference) && empty($passenger_Reference))) {
            unset($this->Passenger_Reference);
        } else {
            $this->Passenger_Reference = $passenger_Reference;
        }
        return $this;
    }
    /**
     * Get Passenger_Name value
     * @return string|null
     */
    public function getPassenger_Name()
    {
        return isset($this->Passenger_Name) ? $this->Passenger_Name : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPassenger_Name method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassenger_Name method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePassenger_NameForChoiceConstraintsFromSetPassenger_Name($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Worker_Reference',
            'Passenger_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Passenger_Name can\'t be set as the property %s is already set. Only one property must be set among these properties: Passenger_Name, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Passenger_Name value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $passenger_Name
     * @return \StructType\Passenger_DataType
     */
    public function setPassenger_Name($passenger_Name = null)
    {
        // validation for constraint: string
        if (!is_null($passenger_Name) && !is_string($passenger_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passenger_Name, true), gettype($passenger_Name)), __LINE__);
        }
        // validation for constraint: choice(Worker_Reference, Passenger_Reference, Passenger_Name)
        if ('' !== ($passenger_NameChoiceErrorMessage = self::validatePassenger_NameForChoiceConstraintsFromSetPassenger_Name($passenger_Name))) {
            throw new \InvalidArgumentException($passenger_NameChoiceErrorMessage, __LINE__);
        }
        if (is_null($passenger_Name) || (is_array($passenger_Name) && empty($passenger_Name))) {
            unset($this->Passenger_Name);
        } else {
            $this->Passenger_Name = $passenger_Name;
        }
        return $this;
    }
}
