<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction_Header__HV__RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; but the Expense Credit Card Transaction File already exists. | Credit Card Transaction Header Request.
 * @subpackage Structs
 */
class Credit_Card_Transaction_Header__HV__RequestType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Credit Card Transaction File for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_FileObjectType
     */
    public $Expense_Credit_Card_Transaction_File_Reference;
    /**
     * The Expense_Credit_Card_Transaction_File_Data
     * @var \StructType\Credit_Card_Transaction_File__HV__DataType
     */
    public $Expense_Credit_Card_Transaction_File_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Credit_Card_Transaction_Header__HV__RequestType
     * @uses Credit_Card_Transaction_Header__HV__RequestType::setExpense_Credit_Card_Transaction_File_Reference()
     * @uses Credit_Card_Transaction_Header__HV__RequestType::setExpense_Credit_Card_Transaction_File_Data()
     * @uses Credit_Card_Transaction_Header__HV__RequestType::setAdd_Only()
     * @uses Credit_Card_Transaction_Header__HV__RequestType::setVersion()
     * @param \StructType\Credit_Card_Transaction_FileObjectType $expense_Credit_Card_Transaction_File_Reference
     * @param \StructType\Credit_Card_Transaction_File__HV__DataType $expense_Credit_Card_Transaction_File_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Credit_Card_Transaction_FileObjectType $expense_Credit_Card_Transaction_File_Reference = null, \StructType\Credit_Card_Transaction_File__HV__DataType $expense_Credit_Card_Transaction_File_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Credit_Card_Transaction_File_Reference($expense_Credit_Card_Transaction_File_Reference)
            ->setExpense_Credit_Card_Transaction_File_Data($expense_Credit_Card_Transaction_File_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Credit_Card_Transaction_File_Reference value
     * @return \StructType\Credit_Card_Transaction_FileObjectType|null
     */
    public function getExpense_Credit_Card_Transaction_File_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_File_Reference;
    }
    /**
     * Set Expense_Credit_Card_Transaction_File_Reference value
     * @param \StructType\Credit_Card_Transaction_FileObjectType $expense_Credit_Card_Transaction_File_Reference
     * @return \StructType\Credit_Card_Transaction_Header__HV__RequestType
     */
    public function setExpense_Credit_Card_Transaction_File_Reference(\StructType\Credit_Card_Transaction_FileObjectType $expense_Credit_Card_Transaction_File_Reference = null)
    {
        $this->Expense_Credit_Card_Transaction_File_Reference = $expense_Credit_Card_Transaction_File_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_File_Data value
     * @return \StructType\Credit_Card_Transaction_File__HV__DataType|null
     */
    public function getExpense_Credit_Card_Transaction_File_Data()
    {
        return $this->Expense_Credit_Card_Transaction_File_Data;
    }
    /**
     * Set Expense_Credit_Card_Transaction_File_Data value
     * @param \StructType\Credit_Card_Transaction_File__HV__DataType $expense_Credit_Card_Transaction_File_Data
     * @return \StructType\Credit_Card_Transaction_Header__HV__RequestType
     */
    public function setExpense_Credit_Card_Transaction_File_Data(\StructType\Credit_Card_Transaction_File__HV__DataType $expense_Credit_Card_Transaction_File_Data = null)
    {
        $this->Expense_Credit_Card_Transaction_File_Data = $expense_Credit_Card_Transaction_File_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Credit_Card_Transaction_Header__HV__RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Credit_Card_Transaction_Header__HV__RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
