<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Share_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the business asset and its corresponding asset shares
 * @subpackage Structs
 */
class Asset_Share_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't maintain asset shares for assets with a lease spend category. | Reference to the business asset for which the asset shares will be created or maintained.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The effective date of the newly created or changed shares.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Asset_Share_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Asset_Share_Replacement_DataType[]
     */
    public $Asset_Share_Replacement_Data;
    /**
     * Constructor method for Asset_Share_DataType
     * @uses Asset_Share_DataType::setAsset_Reference()
     * @uses Asset_Share_DataType::setBusiness_Process_Parameters()
     * @uses Asset_Share_DataType::setTransaction_Effective_Date()
     * @uses Asset_Share_DataType::setAsset_Share_Replacement_Data()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_Share_Replacement_DataType[] $asset_Share_Replacement_Data
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, $transaction_Effective_Date = null, array $asset_Share_Replacement_Data = array())
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setAsset_Share_Replacement_Data($asset_Share_Replacement_Data);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Asset_Share_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Asset_Share_DataType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Share_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Asset_Share_Replacement_Data value
     * @return \StructType\Asset_Share_Replacement_DataType[]|null
     */
    public function getAsset_Share_Replacement_Data()
    {
        return $this->Asset_Share_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Share_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Share_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Share_Replacement_DataForArrayConstraintsFromSetAsset_Share_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Share_DataTypeAsset_Share_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Share_DataTypeAsset_Share_Replacement_DataItem instanceof \StructType\Asset_Share_Replacement_DataType) {
                $invalidValues[] = is_object($asset_Share_DataTypeAsset_Share_Replacement_DataItem) ? get_class($asset_Share_DataTypeAsset_Share_Replacement_DataItem) : sprintf('%s(%s)', gettype($asset_Share_DataTypeAsset_Share_Replacement_DataItem), var_export($asset_Share_DataTypeAsset_Share_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Share_Replacement_Data property can only contain items of type \StructType\Asset_Share_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Share_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Replacement_DataType[] $asset_Share_Replacement_Data
     * @return \StructType\Asset_Share_DataType
     */
    public function setAsset_Share_Replacement_Data(array $asset_Share_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Share_Replacement_DataArrayErrorMessage = self::validateAsset_Share_Replacement_DataForArrayConstraintsFromSetAsset_Share_Replacement_Data($asset_Share_Replacement_Data))) {
            throw new \InvalidArgumentException($asset_Share_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Share_Replacement_Data = $asset_Share_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Asset_Share_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Share_Replacement_DataType $item
     * @return \StructType\Asset_Share_DataType
     */
    public function addToAsset_Share_Replacement_Data(\StructType\Asset_Share_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Share_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Share_Replacement_Data property can only contain items of type \StructType\Asset_Share_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Share_Replacement_Data[] = $item;
        return $this;
    }
}
