<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Order_Contract_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Provider reference is for a supplier that can be used as a basic worktag only. | Resource Provider must be active or on hold. | Resource Provider must be a Supplier or an Independent Contingent Worker. | The End Date must be
 * greater than the Start Date. | Supplier Order Contract details
 * @subpackage Structs
 */
class Supplier_Order_Contract_DataType extends AbstractStructBase
{
    /**
     * The Contract_ID
     * Meta information extracted from the WSDL
     * - documentation: Contract ID. This is the unique identifier for supplier order contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_ID;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract Name
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Name;
    /**
     * The Resource_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Provider Reference
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Resource_Provider_Reference;
    /**
     * The Supplier_Contract_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Contract_Reference_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - choice: Company_Reference | Company_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Hierarchy Reference. Can only specify either a Company Reference or a Company Hierarchy Reference, not both
     * - choice: Company_Reference | Company_Hierarchy_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\OrganizationObjectType
     */
    public $Company_Hierarchy_Reference;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the named Buyer for the Supplier Order Contract
     * @var \StructType\WorkerObjectType
     */
    public $Buyer_Reference;
    /**
     * The Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract Start Date
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_Start_Date;
    /**
     * The Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date
     * - maxOccurs: 1
     * @var string
     */
    public $Contract_End_Date;
    /**
     * The Total_Contract_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total Contract Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Contract_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Contract_Overview
     * Meta information extracted from the WSDL
     * - documentation: Contract Overview
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Overview;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing of supplier order contract inside the Workday application. Supplier order contract can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Attachment_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Replacement_Data;
    /**
     * Constructor method for Supplier_Order_Contract_DataType
     * @uses Supplier_Order_Contract_DataType::setContract_ID()
     * @uses Supplier_Order_Contract_DataType::setContract_Name()
     * @uses Supplier_Order_Contract_DataType::setResource_Provider_Reference()
     * @uses Supplier_Order_Contract_DataType::setSupplier_Contract_Reference_Number()
     * @uses Supplier_Order_Contract_DataType::setCompany_Reference()
     * @uses Supplier_Order_Contract_DataType::setCompany_Hierarchy_Reference()
     * @uses Supplier_Order_Contract_DataType::setBuyer_Reference()
     * @uses Supplier_Order_Contract_DataType::setContract_Start_Date()
     * @uses Supplier_Order_Contract_DataType::setContract_End_Date()
     * @uses Supplier_Order_Contract_DataType::setTotal_Contract_Amount()
     * @uses Supplier_Order_Contract_DataType::setCurrency_Reference()
     * @uses Supplier_Order_Contract_DataType::setContract_Overview()
     * @uses Supplier_Order_Contract_DataType::setLocked_in_Workday()
     * @uses Supplier_Order_Contract_DataType::setAttachment_Replacement_Data()
     * @param string $contract_ID
     * @param string $contract_Name
     * @param \StructType\Resource_ProviderObjectType $resource_Provider_Reference
     * @param string $supplier_Contract_Reference_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\OrganizationObjectType $company_Hierarchy_Reference
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @param string $contract_Start_Date
     * @param string $contract_End_Date
     * @param float $total_Contract_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $contract_Overview
     * @param bool $locked_in_Workday
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Replacement_Data
     */
    public function __construct($contract_ID = null, $contract_Name = null, \StructType\Resource_ProviderObjectType $resource_Provider_Reference = null, $supplier_Contract_Reference_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\OrganizationObjectType $company_Hierarchy_Reference = null, \StructType\WorkerObjectType $buyer_Reference = null, $contract_Start_Date = null, $contract_End_Date = null, $total_Contract_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $contract_Overview = null, $locked_in_Workday = null, array $attachment_Replacement_Data = array())
    {
        $this
            ->setContract_ID($contract_ID)
            ->setContract_Name($contract_Name)
            ->setResource_Provider_Reference($resource_Provider_Reference)
            ->setSupplier_Contract_Reference_Number($supplier_Contract_Reference_Number)
            ->setCompany_Reference($company_Reference)
            ->setCompany_Hierarchy_Reference($company_Hierarchy_Reference)
            ->setBuyer_Reference($buyer_Reference)
            ->setContract_Start_Date($contract_Start_Date)
            ->setContract_End_Date($contract_End_Date)
            ->setTotal_Contract_Amount($total_Contract_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setContract_Overview($contract_Overview)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setAttachment_Replacement_Data($attachment_Replacement_Data);
    }
    /**
     * Get Contract_ID value
     * @return string|null
     */
    public function getContract_ID()
    {
        return $this->Contract_ID;
    }
    /**
     * Set Contract_ID value
     * @param string $contract_ID
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setContract_ID($contract_ID = null)
    {
        // validation for constraint: string
        if (!is_null($contract_ID) && !is_string($contract_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_ID, true), gettype($contract_ID)), __LINE__);
        }
        $this->Contract_ID = $contract_ID;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Resource_Provider_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getResource_Provider_Reference()
    {
        return $this->Resource_Provider_Reference;
    }
    /**
     * Set Resource_Provider_Reference value
     * @param \StructType\Resource_ProviderObjectType $resource_Provider_Reference
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setResource_Provider_Reference(\StructType\Resource_ProviderObjectType $resource_Provider_Reference = null)
    {
        $this->Resource_Provider_Reference = $resource_Provider_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Contract_Reference_Number()
    {
        return $this->Supplier_Contract_Reference_Number;
    }
    /**
     * Set Supplier_Contract_Reference_Number value
     * @param string $supplier_Contract_Reference_Number
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setSupplier_Contract_Reference_Number($supplier_Contract_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Contract_Reference_Number) && !is_string($supplier_Contract_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Contract_Reference_Number, true), gettype($supplier_Contract_Reference_Number)), __LINE__);
        }
        $this->Supplier_Contract_Reference_Number = $supplier_Contract_Reference_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return isset($this->Company_Reference) ? $this->Company_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompany_ReferenceForChoiceConstraintsFromSetCompany_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Company_Hierarchy_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Company_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Company_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Company_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        // validation for constraint: choice(Company_Reference, Company_Hierarchy_Reference)
        if ('' !== ($company_ReferenceChoiceErrorMessage = self::validateCompany_ReferenceForChoiceConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($company_Reference) || (is_array($company_Reference) && empty($company_Reference))) {
            unset($this->Company_Reference);
        } else {
            $this->Company_Reference = $company_Reference;
        }
        return $this;
    }
    /**
     * Get Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_Hierarchy_Reference()
    {
        return isset($this->Company_Hierarchy_Reference) ? $this->Company_Hierarchy_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCompany_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Hierarchy_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCompany_Hierarchy_ReferenceForChoiceConstraintsFromSetCompany_Hierarchy_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Company_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Company_Hierarchy_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Company_Hierarchy_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Company_Hierarchy_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $company_Hierarchy_Reference
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setCompany_Hierarchy_Reference(\StructType\OrganizationObjectType $company_Hierarchy_Reference = null)
    {
        // validation for constraint: choice(Company_Reference, Company_Hierarchy_Reference)
        if ('' !== ($company_Hierarchy_ReferenceChoiceErrorMessage = self::validateCompany_Hierarchy_ReferenceForChoiceConstraintsFromSetCompany_Hierarchy_Reference($company_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($company_Hierarchy_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($company_Hierarchy_Reference) || (is_array($company_Hierarchy_Reference) && empty($company_Hierarchy_Reference))) {
            unset($this->Company_Hierarchy_Reference);
        } else {
            $this->Company_Hierarchy_Reference = $company_Hierarchy_Reference;
        }
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * Set Buyer_Reference value
     * @param \StructType\WorkerObjectType $buyer_Reference
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setBuyer_Reference(\StructType\WorkerObjectType $buyer_Reference = null)
    {
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Get Contract_Start_Date value
     * @return string|null
     */
    public function getContract_Start_Date()
    {
        return $this->Contract_Start_Date;
    }
    /**
     * Set Contract_Start_Date value
     * @param string $contract_Start_Date
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setContract_Start_Date($contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date) && !is_string($contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date, true), gettype($contract_Start_Date)), __LINE__);
        }
        $this->Contract_Start_Date = $contract_Start_Date;
        return $this;
    }
    /**
     * Get Contract_End_Date value
     * @return string|null
     */
    public function getContract_End_Date()
    {
        return $this->Contract_End_Date;
    }
    /**
     * Set Contract_End_Date value
     * @param string $contract_End_Date
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setContract_End_Date($contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date) && !is_string($contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date, true), gettype($contract_End_Date)), __LINE__);
        }
        $this->Contract_End_Date = $contract_End_Date;
        return $this;
    }
    /**
     * Get Total_Contract_Amount value
     * @return float|null
     */
    public function getTotal_Contract_Amount()
    {
        return $this->Total_Contract_Amount;
    }
    /**
     * Set Total_Contract_Amount value
     * @param float $total_Contract_Amount
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setTotal_Contract_Amount($total_Contract_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Contract_Amount) && !(is_float($total_Contract_Amount) || is_numeric($total_Contract_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Contract_Amount, true), gettype($total_Contract_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Contract_Amount) && mb_strlen(mb_substr($total_Contract_Amount, false !== mb_strpos($total_Contract_Amount, '.') ? mb_strpos($total_Contract_Amount, '.') + 1 : mb_strlen($total_Contract_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Contract_Amount, true), mb_strlen(mb_substr($total_Contract_Amount, mb_strpos($total_Contract_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($total_Contract_Amount) && $total_Contract_Amount < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($total_Contract_Amount, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Contract_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Contract_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Contract_Amount))), __LINE__);
        }
        $this->Total_Contract_Amount = $total_Contract_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Contract_Overview value
     * @return string|null
     */
    public function getContract_Overview()
    {
        return $this->Contract_Overview;
    }
    /**
     * Set Contract_Overview value
     * @param string $contract_Overview
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setContract_Overview($contract_Overview = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Overview) && !is_string($contract_Overview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Overview, true), gettype($contract_Overview)), __LINE__);
        }
        $this->Contract_Overview = $contract_Overview;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Attachment_Replacement_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Replacement_Data()
    {
        return $this->Attachment_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_Replacement_DataForArrayConstraintsFromSetAttachment_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem) ? get_class($supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem), var_export($supplier_Order_Contract_DataTypeAttachment_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Replacement_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Replacement_Data
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function setAttachment_Replacement_Data(array $attachment_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_Replacement_DataArrayErrorMessage = self::validateAttachment_Replacement_DataForArrayConstraintsFromSetAttachment_Replacement_Data($attachment_Replacement_Data))) {
            throw new \InvalidArgumentException($attachment_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Replacement_Data = $attachment_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Order_Contract_DataType
     */
    public function addToAttachment_Replacement_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Replacement_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Replacement_Data[] = $item;
        return $this;
    }
}
