<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Group_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Group Instance and Data
 * @subpackage Structs
 */
class Supplier_Group_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Group
     * Meta information extracted from the WSDL
     * - documentation: Supplier Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_GroupType[]
     */
    public $Supplier_Group;
    /**
     * Constructor method for Supplier_Group_Response_DataType
     * @uses Supplier_Group_Response_DataType::setSupplier_Group()
     * @param \StructType\Supplier_GroupType[] $supplier_Group
     */
    public function __construct(array $supplier_Group = array())
    {
        $this
            ->setSupplier_Group($supplier_Group);
    }
    /**
     * Get Supplier_Group value
     * @return \StructType\Supplier_GroupType[]|null
     */
    public function getSupplier_Group()
    {
        return $this->Supplier_Group;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Group method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Group method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_GroupForArrayConstraintsFromSetSupplier_Group(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Group_Response_DataTypeSupplier_GroupItem) {
            // validation for constraint: itemType
            if (!$supplier_Group_Response_DataTypeSupplier_GroupItem instanceof \StructType\Supplier_GroupType) {
                $invalidValues[] = is_object($supplier_Group_Response_DataTypeSupplier_GroupItem) ? get_class($supplier_Group_Response_DataTypeSupplier_GroupItem) : sprintf('%s(%s)', gettype($supplier_Group_Response_DataTypeSupplier_GroupItem), var_export($supplier_Group_Response_DataTypeSupplier_GroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Group property can only contain items of type \StructType\Supplier_GroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupType[] $supplier_Group
     * @return \StructType\Supplier_Group_Response_DataType
     */
    public function setSupplier_Group(array $supplier_Group = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_GroupArrayErrorMessage = self::validateSupplier_GroupForArrayConstraintsFromSetSupplier_Group($supplier_Group))) {
            throw new \InvalidArgumentException($supplier_GroupArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Group = $supplier_Group;
        return $this;
    }
    /**
     * Add item to Supplier_Group value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_GroupType $item
     * @return \StructType\Supplier_Group_Response_DataType
     */
    public function addToSupplier_Group(\StructType\Supplier_GroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_GroupType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Group property can only contain items of type \StructType\Supplier_GroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Group[] = $item;
        return $this;
    }
}
